/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.measure.bitmap;

import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import org.apache.kylin.measure.bitmap.BitmapCounter;
import org.apache.kylin.measure.bitmap.BitmapCounterFactory;
import org.apache.kylin.measure.bitmap.RoaringBitmapCounter;
import org.roaringbitmap.longlong.Roaring64NavigableMap;

public class RoaringBitmapCounterFactory
implements BitmapCounterFactory,
Serializable {
    public static final BitmapCounterFactory INSTANCE = new RoaringBitmapCounterFactory();

    private RoaringBitmapCounterFactory() {
    }

    @Override
    public BitmapCounter newBitmap() {
        return new RoaringBitmapCounter();
    }

    @Override
    public BitmapCounter newBitmap(long ... values) {
        return new RoaringBitmapCounter(Roaring64NavigableMap.bitmapOf((long[])values));
    }

    @Override
    public BitmapCounter newBitmap(long counter) {
        return new RoaringBitmapCounter(counter);
    }

    @Override
    public BitmapCounter newBitmap(ByteBuffer in) throws IOException {
        RoaringBitmapCounter counter = new RoaringBitmapCounter();
        counter.readFields(in);
        return counter;
    }
}

