/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql;

import java.util.HashSet;
import java.util.Locale;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.exception.ErrorCodeSupplier;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.ServerErrorCode;
import org.apache.kylin.common.util.NamedThreadFactory;
import org.apache.kylin.common.util.StringHelper;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.kylin.metadata.model.ISourceAware;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.metadata.view.LogicalView;
import org.apache.kylin.metadata.view.LogicalViewManager;
import org.apache.kylin.source.ISourceMetadataExplorer;
import org.apache.kylin.source.SourceFactory;
import org.apache.kylin.source.SupportsSparkCatalog;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SparderEnv;
import org.apache.spark.sql.SparkSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogicalViewLoader {
    public static final Logger LOGGER = LoggerFactory.getLogger(LogicalViewLoader.class);
    public static final ConcurrentMap<String, LogicalView> LOADED_LOGICAL_VIEWS = Maps.newConcurrentMap();
    public static final ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new NamedThreadFactory("logical_view"));
    private static ScheduledFuture<?> syncViewScheduler;

    public static void initScheduler() {
        LOADED_LOGICAL_VIEWS.clear();
        LOGGER.info("Start sync logical view...");
        LogicalViewLoader.stopScheduler();
        syncViewScheduler = executorService.scheduleAtFixedRate(() -> {
            try {
                LogicalViewLoader.syncViewFromDB();
            }
            catch (Throwable e) {
                LOGGER.error("Error when sync logical view", e);
            }
        }, 0L, KylinConfig.getInstanceFromEnv().getDDLLogicalViewCatchupInterval(), TimeUnit.SECONDS);
    }

    public static void syncViewAsync() {
        executorService.schedule(LogicalViewLoader::syncViewFromDB, 0L, TimeUnit.SECONDS);
    }

    public static synchronized void loadView(String viewName, boolean loadBySpark, SparkSession spark) {
        LOGGER.info("start load new logical view, view name is {}", (Object)viewName);
        LogicalViewManager viewManager = LogicalViewManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv());
        LogicalView toLoadView = viewManager.get(viewName);
        try {
            if (toLoadView == null) {
                LOGGER.warn("failed to find logical view {} ", (Object)viewName);
                return;
            }
            if (loadBySpark) {
                LogicalViewLoader.dropLogicalViewIfExist(toLoadView.getTableName(), spark);
                LogicalViewLoader.createLogicalView(toLoadView.getCreatedSql(), toLoadView.getCreatedProject(), spark);
            }
            LOADED_LOGICAL_VIEWS.put(toLoadView.getTableName().toUpperCase(Locale.ROOT), toLoadView);
            LOGGER.info("The new table loaded successfully is {}", (Object)viewName);
        }
        catch (Throwable e) {
            LOGGER.error("Error when load new Logical View {}", (Object)viewName, (Object)e);
        }
    }

    public static synchronized void unloadView(String viewName, SparkSession spark) {
        LOADED_LOGICAL_VIEWS.remove(viewName.toUpperCase(Locale.ROOT));
        LogicalViewLoader.dropLogicalViewIfExist(viewName, spark);
    }

    public static synchronized void syncViewFromDB() {
        LogicalViewLoader.checkConfigIfNeed();
        long start = System.currentTimeMillis();
        LogicalViewManager viewManager = LogicalViewManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv());
        HashSet toLoadViews = Sets.newHashSet();
        HashSet toReplaceViews = Sets.newHashSet();
        HashSet toRemoveViews = Sets.newHashSet();
        HashSet successLoadViews = Sets.newHashSet();
        HashSet successReplaceViews = Sets.newHashSet();
        HashSet successRemoveViews = Sets.newHashSet();
        viewManager.list().forEach(view -> {
            if (LOADED_LOGICAL_VIEWS.containsKey(view.getTableName())) {
                LogicalView viewLoaded = (LogicalView)LOADED_LOGICAL_VIEWS.get(view.getTableName());
                if (viewLoaded.getLastModified() != view.getLastModified()) {
                    toReplaceViews.add(view);
                }
            } else {
                toLoadViews.add(view);
            }
        });
        LOADED_LOGICAL_VIEWS.keySet().forEach(table -> {
            if (viewManager.get(table) == null) {
                toRemoveViews.add(LOADED_LOGICAL_VIEWS.get(table));
            }
        });
        SparkSession spark = SparderEnv.getSparkSession();
        toLoadViews.forEach(view -> {
            try {
                LogicalViewLoader.dropLogicalViewIfExist(view.getTableName(), spark);
                LogicalViewLoader.createLogicalView(view.getCreatedSql(), view.getCreatedProject(), spark);
                LOADED_LOGICAL_VIEWS.put(view.getTableName(), (LogicalView)view);
                successLoadViews.add(view.getTableName());
            }
            catch (Throwable e) {
                LOGGER.error("Error when load new Logical View {}", (Object)view.getTableName());
            }
        });
        toReplaceViews.forEach(view -> {
            try {
                LogicalViewLoader.dropLogicalViewIfExist(view.getTableName(), spark);
                LogicalViewLoader.createLogicalView(view.getCreatedSql(), view.getCreatedProject(), spark);
                LOADED_LOGICAL_VIEWS.put(view.getTableName(), (LogicalView)view);
                successReplaceViews.add(view.getTableName());
            }
            catch (Throwable e) {
                LOGGER.error("Error when replace new Logical View {}", (Object)view.getTableName());
            }
        });
        toRemoveViews.forEach(view -> {
            try {
                LogicalViewLoader.dropLogicalViewIfExist(view.getTableName(), spark);
                LOADED_LOGICAL_VIEWS.remove(view.getTableName());
                successRemoveViews.add(view.getTableName());
            }
            catch (Throwable e) {
                LOGGER.error("Error when remove Logical View {}", (Object)view.getTableName());
            }
        });
        long costTime = (System.currentTimeMillis() - start) / 1000L;
        LOGGER.info("End sync logical view, cost time is {}, \tsuccess loaded views: {},\tsuccess replaced views: {},\tsuccess removed views: {}.", new Object[]{costTime, successLoadViews, successReplaceViews, successRemoveViews});
    }

    private static void dropLogicalViewIfExist(String tableName, SparkSession spark) {
        String quotedDatabase = StringHelper.backtickQuote((String)KylinConfig.getInstanceFromEnv().getDDLLogicalViewDB());
        String quotedTableName = StringHelper.backtickQuote((String)tableName);
        spark.sql("DROP LOGICAL VIEW IF EXISTS " + quotedDatabase + "." + quotedTableName);
    }

    private static void createLogicalView(String sql, String project, SparkSession spark) {
        String logicalSql = LogicalViewLoader.addCatalog(sql, project, spark);
        spark.sql(logicalSql);
    }

    public static String addCatalog(String sql, String project, SparkSession spark) {
        if (project == null) {
            return sql;
        }
        ProjectInstance projectInstance = ((NProjectManager)KylinConfig.getInstanceFromEnv().getManager(NProjectManager.class)).getProject(project);
        ISourceMetadataExplorer explorer = SourceFactory.getSource((ISourceAware)projectInstance).getSourceMetadataExplorer();
        if (explorer instanceof SupportsSparkCatalog) {
            SupportsSparkCatalog sparkCatalog = (SupportsSparkCatalog)explorer;
            sparkCatalog.getSourceCatalogConf((KylinConfig)projectInstance.getConfig(), project).forEach((arg_0, arg_1) -> ((SQLContext)spark.sqlContext()).setConf(arg_0, arg_1));
            return sparkCatalog.addCatalog((KylinConfig)projectInstance.getConfig(), sql, project);
        }
        return sql;
    }

    public static void addCatalogConfByJdbc(SparkSession ss, String project) {
        ProjectInstance projectInstance = ((NProjectManager)KylinConfig.getInstanceFromEnv().getManager(NProjectManager.class)).getProject(project);
        ISourceMetadataExplorer explorer = SourceFactory.getSource((ISourceAware)projectInstance).getSourceMetadataExplorer();
        if (explorer instanceof SupportsSparkCatalog) {
            SupportsSparkCatalog sparkCatalog = (SupportsSparkCatalog)explorer;
            sparkCatalog.getSourceCatalogConf((KylinConfig)projectInstance.getConfig(), project).forEach((arg_0, arg_1) -> ((SQLContext)ss.sqlContext()).setConf(arg_0, arg_1));
        }
    }

    public static void checkConfigIfNeed() {
        if (!KylinConfig.getInstanceFromEnv().isDDLLogicalViewEnabled()) {
            return;
        }
        try {
            SourceFactory.getSparkSource().getSourceMetadataExplorer().listDatabases();
        }
        catch (Exception e) {
            LOGGER.warn("Error when list databases....", (Throwable)e);
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.DDL_CHECK_ERROR, "Logical view database should not be duplicated with normal hive database!!!");
        }
    }

    public static void stopScheduler() {
        try {
            if (null != syncViewScheduler && !syncViewScheduler.isCancelled()) {
                syncViewScheduler.cancel(true);
            }
        }
        catch (Exception e) {
            LOGGER.error("Error when cancel syncViewScheduler", (Throwable)e);
        }
    }

    private LogicalViewLoader() {
    }
}

