/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql;

import java.io.Serializable;
import java.util.List;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.DDLDesc;
import org.apache.spark.sql.DdlOperation;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparderEnv$;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType$;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.delta.DeltaTableUtils$;
import org.apache.spark.sql.execution.CommandExecutionMode$;
import org.apache.spark.sql.execution.CommandResultExec;
import org.apache.spark.sql.execution.QueryExecution;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.command.AlterTableAddPartitionCommand;
import org.apache.spark.sql.execution.command.CreateDatabaseCommand;
import org.apache.spark.sql.execution.command.CreateTableCommand;
import org.apache.spark.sql.execution.command.CreateViewCommand;
import org.apache.spark.sql.execution.command.DDLUtils$;
import org.apache.spark.sql.execution.command.DropDatabaseCommand;
import org.apache.spark.sql.execution.command.DropTableCommand;
import org.apache.spark.sql.execution.command.ExecutedCommandExec;
import org.apache.spark.sql.execution.command.RunnableCommand;
import org.apache.spark.sql.execution.command.ShowCreateTableAsSerdeCommand;
import org.apache.spark.sql.execution.command.ShowCreateTableCommand;
import org.apache.spark.sql.execution.command.ShowPartitionsCommand;
import org.apache.spark.sql.execution.datasources.v2.CreateNamespaceExec;
import org.apache.spark.sql.execution.datasources.v2.DropNamespaceExec;
import org.apache.spark.sql.execution.datasources.v2.ShowCreateTableExec;
import org.apache.spark.sql.types.StructField;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;

public final class DdlOperation$
implements Logging {
    public static DdlOperation$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new DdlOperation$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DDLDesc executeSQL(String sqlText) {
        RunnableCommand addPartition;
        DropNamespaceExec dropNamespaceExec;
        Seq namespace;
        RunnableCommand db;
        CreateNamespaceExec createNamespaceExec;
        Seq namespace2;
        RunnableCommand db2;
        RunnableCommand drop;
        RunnableCommand view;
        LogicalPlan logicalPlan = SparderEnv$.MODULE$.getSparkSession().sessionState().sqlParser().parsePlan(sqlText);
        QueryExecution queryExecution = SparderEnv$.MODULE$.getSparkSession().sessionState().executePlan(logicalPlan, CommandExecutionMode$.MODULE$.SKIP());
        String currentDatabase = SparderEnv$.MODULE$.getSparkSession().catalog().currentDatabase();
        boolean bl = false;
        ExecutedCommandExec executedCommandExec = null;
        SparkPlan sparkPlan = this.stripRootCommandResult(queryExecution.executedPlan());
        if (sparkPlan instanceof ExecutedCommandExec) {
            bl = true;
            executedCommandExec = (ExecutedCommandExec)sparkPlan;
            RunnableCommand create = executedCommandExec.cmd();
            if (create instanceof CreateTableCommand) {
                CreateTableCommand createTableCommand = (CreateTableCommand)create;
                TableIdentifier tableIdentifier = createTableCommand.table().identifier();
                CatalogTableType catalogTableType = createTableCommand.table().tableType();
                CatalogTableType catalogTableType2 = CatalogTableType$.MODULE$.MANAGED();
                if (catalogTableType == null) {
                    if (catalogTableType2 == null) throw new RuntimeException(new java.lang.StringBuilder(55).append("Table ").append(tableIdentifier).append(" is managed table.Please modify to external table").toString());
                } else if (catalogTableType.equals(catalogTableType2)) {
                    throw new RuntimeException(new java.lang.StringBuilder(55).append("Table ").append(tableIdentifier).append(" is managed table.Please modify to external table").toString());
                }
                SparderEnv$.MODULE$.getSparkSession().sql(sqlText);
                return new DDLDesc(sqlText, (String)tableIdentifier.database().getOrElse((Function0 & Serializable & scala.Serializable)() -> currentDatabase), tableIdentifier.table(), DDLDesc.DDLType.CREATE_TABLE);
            }
        }
        if (bl && (view = executedCommandExec.cmd()) instanceof CreateViewCommand) {
            CreateViewCommand createViewCommand = (CreateViewCommand)view;
            TableIdentifier viewIdentifier = createViewCommand.name();
            SparderEnv$.MODULE$.getSparkSession().sql(sqlText);
            return new DDLDesc(sqlText, (String)viewIdentifier.database().getOrElse((Function0 & Serializable & scala.Serializable)() -> currentDatabase), viewIdentifier.table(), DDLDesc.DDLType.CREATE_VIEW);
        }
        if (bl && (drop = executedCommandExec.cmd()) instanceof DropTableCommand) {
            DropTableCommand dropTableCommand = (DropTableCommand)drop;
            SparderEnv$.MODULE$.getSparkSession().sql(sqlText);
            return new DDLDesc(sqlText, (String)dropTableCommand.tableName().database().getOrElse((Function0 & Serializable & scala.Serializable)() -> currentDatabase), dropTableCommand.tableName().table(), DDLDesc.DDLType.DROP_TABLE);
        }
        if (bl && (db2 = executedCommandExec.cmd()) instanceof CreateDatabaseCommand) {
            CreateDatabaseCommand createDatabaseCommand = (CreateDatabaseCommand)db2;
            SparderEnv$.MODULE$.getSparkSession().sql(sqlText);
            return new DDLDesc(sqlText, createDatabaseCommand.databaseName(), null, DDLDesc.DDLType.CREATE_DATABASE);
        }
        if (sparkPlan instanceof CreateNamespaceExec && (namespace2 = (createNamespaceExec = (CreateNamespaceExec)sparkPlan).namespace()) != null) {
            Seq seq = namespace2;
            SparderEnv$.MODULE$.getSparkSession().sql(sqlText);
            return new DDLDesc(sqlText, (String)seq.apply(0), null, DDLDesc.DDLType.CREATE_DATABASE);
        }
        if (bl && (db = executedCommandExec.cmd()) instanceof DropDatabaseCommand) {
            DropDatabaseCommand dropDatabaseCommand = (DropDatabaseCommand)db;
            SparderEnv$.MODULE$.getSparkSession().sql(sqlText);
            return new DDLDesc(sqlText, dropDatabaseCommand.databaseName(), null, DDLDesc.DDLType.DROP_DATABASE);
        }
        if (sparkPlan instanceof DropNamespaceExec && (namespace = (dropNamespaceExec = (DropNamespaceExec)sparkPlan).namespace()) != null) {
            Seq seq = namespace;
            SparderEnv$.MODULE$.getSparkSession().sql(sqlText);
            return new DDLDesc(sqlText, (String)seq.apply(0), null, DDLDesc.DDLType.DROP_DATABASE);
        }
        if (bl && (addPartition = executedCommandExec.cmd()) instanceof AlterTableAddPartitionCommand) {
            AlterTableAddPartitionCommand alterTableAddPartitionCommand = (AlterTableAddPartitionCommand)addPartition;
            SparderEnv$.MODULE$.getSparkSession().sql(sqlText);
            return new DDLDesc(sqlText, (String)alterTableAddPartitionCommand.tableName().database().getOrElse((Function0 & Serializable & scala.Serializable)() -> currentDatabase), alterTableAddPartitionCommand.tableName().table(), DDLDesc.DDLType.ADD_PARTITION);
        }
        SparderEnv$.MODULE$.getSparkSession().sql(sqlText);
        return new DDLDesc(sqlText, null, null, DDLDesc.DDLType.NONE);
    }

    public DdlOperation.RichStructField RichStructField(StructField structField) {
        return new DdlOperation.RichStructField(structField);
    }

    public List<String> msck(String database, String table) {
        Seq<Row> before = this.calculatePartition(database, table);
        String tableIdentifier = new java.lang.StringBuilder(1).append(database).append(".").append(table).toString();
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(33).append("Before ").append(tableIdentifier).append(" msck partition number is ").append(before.size()).toString());
        SparderEnv$.MODULE$.getSparkSession().sql(new java.lang.StringBuilder(18).append("msck repair table ").append(tableIdentifier).toString());
        Seq<Row> after = this.calculatePartition(database, table);
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(32).append("After ").append(tableIdentifier).append(" msck partition number is ").append(after.size()).toString());
        Seq diff = (Seq)after.diff(before);
        return (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)diff.map((Function1 & Serializable & scala.Serializable)row -> row.getString(0), Seq$.MODULE$.canBuildFrom())).asJava();
    }

    public boolean hasPartition(String database, String table) {
        SessionCatalog catalog = SparderEnv$.MODULE$.getSparkSession().sessionState().catalog();
        CatalogTable catalogTable = catalog.getTableMetadata(new TableIdentifier(table, (Option)new Some((Object)database)));
        CatalogTableType catalogTableType = catalogTable.tableType();
        CatalogTableType catalogTableType2 = CatalogTableType$.MODULE$.VIEW();
        return (catalogTableType == null ? catalogTableType2 != null : !catalogTableType.equals(catalogTableType2)) ? catalogTable.partitionColumnNames().nonEmpty() && catalogTable.storage().locationUri().nonEmpty() : false;
    }

    /*
     * Unable to fully structure code
     */
    public String getTableDesc(String database, String table) {
        block6: {
            block5: {
                sql = new java.lang.StringBuilder(19).append("SHOW CREATE TABLE ").append(database).append(".").append(table).toString();
                tableMetadata = SparderEnv$.MODULE$.getSparkSession().sessionState().catalog().getTableRawMetadata(new TableIdentifier(table, (Option)new Some((Object)database)));
                if (DeltaTableUtils$.MODULE$.isDeltaTable(tableMetadata)) {
                    return this.generateDeltaTableDDL(tableMetadata);
                }
                sql = DDLUtils$.MODULE$.isHiveTable(tableMetadata) != false ? new java.lang.StringBuilder(9).append(sql).append(" AS SERDE").toString() : sql;
                logicalPlan = SparderEnv$.MODULE$.getSparkSession().sessionState().sqlParser().parsePlan(sql);
                queryExecution = SparderEnv$.MODULE$.getSparkSession().sessionState().executePlan(logicalPlan, CommandExecutionMode$.MODULE$.SKIP());
                show = this.stripRootCommandResult(queryExecution.executedPlan());
                if (!(show instanceof ShowCreateTableExec)) break block5;
                v0 = this.collectDDL(new TableIdentifier(table, (Option)new Some((Object)database)), sql);
                break block6;
            }
            var9_8 = false;
            var10_9 = null;
            var11_10 = show;
            if (!(var11_10 instanceof ExecutedCommandExec)) ** GOTO lbl-1000
            var9_8 = true;
            var10_9 = (ExecutedCommandExec)var11_10;
            show = var10_9.cmd();
            if (show instanceof ShowCreateTableCommand) {
                var13_12 = (ShowCreateTableCommand)show;
                var3_13 = this.collectDDL(var13_12.table(), sql);
            } else if (var9_8 && (show = var10_9.cmd()) instanceof ShowCreateTableAsSerdeCommand) {
                var15_15 = (ShowCreateTableAsSerdeCommand)show;
                var3_13 = this.collectDDL(var15_15.table(), sql);
            } else {
                throw new MatchError((Object)var11_10);
            }
            v0 = var3_13;
        }
        return v0;
    }

    public String generateDeltaTableDDL(CatalogTable tableMetadata) {
        return new java.lang.StringBuilder(37).append("CREATE TABLE ").append(tableMetadata.identifier().quotedString()).append(" USING delta LOCATION '").append(tableMetadata.location()).append("'").toString();
    }

    public String collectDDL(TableIdentifier tableIdentifier, String sql) {
        String string;
        SessionCatalog catalog = SparderEnv$.MODULE$.getSparkSession().sessionState().catalog();
        CatalogTable metadata = catalog.getTableMetadata(tableIdentifier);
        CatalogTableType catalogTableType = metadata.tableType();
        CatalogTableType catalogTableType2 = CatalogTableType$.MODULE$.VIEW();
        CatalogTableType catalogTableType3 = catalogTableType;
        if (!(catalogTableType2 != null ? !catalogTableType2.equals(catalogTableType3) : catalogTableType3 != null)) {
            StringBuilder builder = new StringBuilder();
            builder.$plus$plus$eq(new java.lang.StringBuilder(12).append("CREATE VIEW ").append(tableIdentifier.quotedString()).toString());
            Object object = metadata.schema().nonEmpty() ? builder.$plus$plus$eq(((TraversableOnce)metadata.schema().map((Function1 & Serializable & scala.Serializable)x$2 -> MODULE$.RichStructField((StructField)x$2).toViewDDL(), Seq$.MODULE$.canBuildFrom())).mkString("(", ", ", ")")) : BoxedUnit.UNIT;
            builder.$plus$plus$eq(Option$.MODULE$.option2Iterable(metadata.viewText()).mkString(" AS\n", "", "\n"));
            string = builder.toString();
        } else {
            CatalogTableType catalogTableType4 = CatalogTableType$.MODULE$.MANAGED();
            CatalogTableType catalogTableType5 = catalogTableType;
            if (!(catalogTableType4 != null ? !catalogTableType4.equals(catalogTableType5) : catalogTableType5 != null)) {
                string = "";
            } else {
                CatalogTableType catalogTableType6 = CatalogTableType$.MODULE$.EXTERNAL();
                CatalogTableType catalogTableType7 = catalogTableType;
                if (!(catalogTableType6 != null ? !catalogTableType6.equals(catalogTableType7) : catalogTableType7 != null)) {
                    string = ((Row)SparderEnv$.MODULE$.getSparkSession().sql(sql).takeAsList(1).get(0)).getString(0);
                } else {
                    throw new MatchError((Object)catalogTableType);
                }
            }
        }
        return string;
    }

    public Seq<Row> calculatePartition(String database, String table) {
        Seq rows;
        ExecutedCommandExec executedCommandExec;
        RunnableCommand showPartitions;
        LogicalPlan logicalPlan = SparderEnv$.MODULE$.getSparkSession().sessionState().sqlParser().parsePlan(new java.lang.StringBuilder(17).append("show partitions ").append(database).append(".").append(table).toString());
        QueryExecution queryExecution = SparderEnv$.MODULE$.getSparkSession().sessionState().executePlan(logicalPlan, CommandExecutionMode$.MODULE$.SKIP());
        SparkPlan sparkPlan = this.stripRootCommandResult(queryExecution.executedPlan());
        if (!(sparkPlan instanceof ExecutedCommandExec) || !((showPartitions = (executedCommandExec = (ExecutedCommandExec)sparkPlan).cmd()) instanceof ShowPartitionsCommand)) {
            throw new MatchError((Object)sparkPlan);
        }
        ShowPartitionsCommand showPartitionsCommand = (ShowPartitionsCommand)showPartitions;
        Seq seq = rows = showPartitionsCommand.run(SparderEnv$.MODULE$.getSparkSession());
        return seq;
    }

    private SparkPlan stripRootCommandResult(SparkPlan executedPlan) {
        SparkPlan sparkPlan;
        SparkPlan sparkPlan2 = executedPlan;
        if (sparkPlan2 instanceof CommandResultExec) {
            SparkPlan plan;
            CommandResultExec commandResultExec = (CommandResultExec)sparkPlan2;
            sparkPlan = plan = commandResultExec.commandPhysicalPlan();
        } else {
            sparkPlan = sparkPlan2;
        }
        return sparkPlan;
    }

    private DdlOperation$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
    }
}

