/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.plugin.profiler;

import java.io.File;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.CountDownLatch;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.exception.ErrorCodeSupplier;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.QueryErrorCode;
import org.apache.kylin.profiler.AsyncProfilerTool$;
import org.apache.kylin.profiler.AsyncProfilerUtils;
import org.apache.kylin.profiler.Message$;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.SparderEnv$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Option$;

public final class AsyncProfiling$
implements Logging {
    public static AsyncProfiling$ MODULE$;
    private File localCacheDir;
    private final long resultCollectionTimeout;
    private final long profilingTimeout;
    private Thread timeoutExecutionThread;
    private String command;
    private boolean running;
    private boolean dumped;
    private CountDownLatch cachedResult;
    private final AsyncProfilerUtils asyncProfilerUtils;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new AsyncProfiling$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public File localCacheDir() {
        return this.localCacheDir;
    }

    public void localCacheDir_$eq(File x$1) {
        this.localCacheDir = x$1;
    }

    private long resultCollectionTimeout() {
        return this.resultCollectionTimeout;
    }

    private long profilingTimeout() {
        return this.profilingTimeout;
    }

    private Thread timeoutExecutionThread() {
        return this.timeoutExecutionThread;
    }

    private void timeoutExecutionThread_$eq(Thread x$1) {
        this.timeoutExecutionThread = x$1;
    }

    private String command() {
        return this.command;
    }

    private void command_$eq(String x$1) {
        this.command = x$1;
    }

    private boolean running() {
        return this.running;
    }

    private void running_$eq(boolean x$1) {
        this.running = x$1;
    }

    private boolean dumped() {
        return this.dumped;
    }

    private void dumped_$eq(boolean x$1) {
        this.dumped = x$1;
    }

    private CountDownLatch cachedResult() {
        return this.cachedResult;
    }

    private void cachedResult_$eq(CountDownLatch x$1) {
        this.cachedResult = x$1;
    }

    public AsyncProfilerUtils asyncProfilerUtils() {
        return this.asyncProfilerUtils;
    }

    public String nextCommand() {
        return this.command();
    }

    public void start(String params) {
        String startParam = (String)Option$.MODULE$.apply((Object)params).getOrElse((Function0 & Serializable & scala.Serializable)() -> "start,event=cpu");
        AsyncProfiling$ asyncProfiling$ = this;
        synchronized (asyncProfiling$) {
            if (this.running()) {
                throw new KylinException((ErrorCodeSupplier)QueryErrorCode.PROFILING_ALREADY_STARTED, "profiling is already started, stop it first");
            }
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "profiler start");
            if (!this.localCacheDir().exists()) {
                this.localCacheDir_$eq(Files.createTempDirectory("ke-async-profiler-result-", new FileAttribute[0]).toFile());
                this.asyncProfilerUtils().build(this.localCacheDir());
            }
            this.asyncProfilerUtils().cleanLocalCache();
            this.cachedResult_$eq(new CountDownLatch(SparderEnv$.MODULE$.getSparkSession().sparkContext().getExecutorMemoryStatus().size()));
            this.asyncProfilerUtils().build(this.cachedResult());
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(26).append("expecting ").append(MODULE$.cachedResult().getCount()).append(" to be collected").toString());
            this.running_$eq(true);
            this.dumped_$eq(false);
            this.command_$eq(Message$.MODULE$.createDriverMessage(Message$.MODULE$.START(), startParam));
            AsyncProfilerTool$.MODULE$.start(startParam);
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "profiler started");
            this.timeoutExecutionThread_$eq(new Thread(() -> {
                try {
                    Thread.sleep(MODULE$.profilingTimeout());
                }
                catch (InterruptedException interruptedException) {
                    MODULE$.logTrace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "profiler stopped normally, timeout thread interrupted and exit");
                    Thread.currentThread().interrupt();
                }
                if (!Thread.interrupted()) {
                    MODULE$.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(46).append("profiling timeout after ").append(MODULE$.profilingTimeout()).append("ms, stopping profiling").toString());
                    AsyncProfiling$ asyncProfiling$ = MODULE$;
                    synchronized (asyncProfiling$) {
                        if (MODULE$.running()) {
                            MODULE$.running_$eq(false);
                            MODULE$.command_$eq(Message$.MODULE$.createDriverMessage(Message$.MODULE$.STOP(), Message$.MODULE$.createDriverMessage$default$2()));
                            AsyncProfilerTool$.MODULE$.stop();
                        }
                    }
                }
            }));
            this.timeoutExecutionThread().start();
        }
    }

    public void dump(String params) {
        String dumpParam = (String)Option$.MODULE$.apply((Object)params).getOrElse((Function0 & Serializable & scala.Serializable)() -> "flamegraph");
        AsyncProfiling$ asyncProfiling$ = this;
        synchronized (asyncProfiling$) {
            if (this.dumped()) {
                throw new KylinException((ErrorCodeSupplier)QueryErrorCode.PROFILER_ALREADY_DUMPED, "result is already dumped.");
            }
            if (this.running()) {
                this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "profiler stop");
                this.running_$eq(false);
                this.timeoutExecutionThread().interrupt();
            } else {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "profiling is not started");
            }
            this.dumped_$eq(true);
            this.command_$eq(Message$.MODULE$.createDriverMessage(Message$.MODULE$.DUMP(), dumpParam));
            this.asyncProfilerUtils().cacheDriverResult(AsyncProfilerTool$.MODULE$.dump(dumpParam));
        }
    }

    public void waitForResult(OutputStream outStream) {
        this.asyncProfilerUtils().waitForResult(outStream);
    }

    public void cacheExecutorResult(String content, String executorId) {
        this.asyncProfilerUtils().cacheExecutorResult(content, executorId);
    }

    private AsyncProfiling$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        this.localCacheDir = Files.createTempDirectory("ke-async-profiler-result-", new FileAttribute[0]).toFile();
        this.localCacheDir().deleteOnExit();
        this.resultCollectionTimeout = KylinConfig.getInstanceFromEnv().asyncProfilingResultTimeout();
        this.profilingTimeout = KylinConfig.getInstanceFromEnv().asyncProfilingProfileTimeout();
        this.command = Message$.MODULE$.createDriverMessage(Message$.MODULE$.NOP(), Message$.MODULE$.createDriverMessage$default$2());
        this.running = false;
        this.dumped = false;
        this.asyncProfilerUtils = AsyncProfilerUtils.getInstance();
        this.asyncProfilerUtils().build(this.resultCollectionTimeout(), this.localCacheDir());
    }
}

