/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.mask;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.calcite.avatica.util.Quoting;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlSelect;
import org.apache.calcite.sql.parser.SqlParseException;
import org.apache.calcite.sql.parser.SqlParser;
import org.apache.kylin.common.exception.ErrorCodeSupplier;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.QueryErrorCode;
import org.apache.kylin.query.util.EscapeDialect;
import org.apache.kylin.query.util.EscapeParser;
import org.apache.kylin.query.util.ParseException;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;

class MaskUtil {
    private MaskUtil() {
    }

    static Dataset<Row> dFToDFWithIndexedColumns(Dataset<Row> df) {
        String[] indexedColNames = new String[df.columns().length];
        for (int i = 0; i < indexedColNames.length; ++i) {
            indexedColNames[i] = df.columns()[i].replaceAll("[`.]", "_") + "_" + i;
        }
        return df.toDF(indexedColNames);
    }

    static List<SqlIdentifier> getCCCols(String ccExpr) {
        SqlSelect select;
        SqlParser.ConfigBuilder parserBuilder = SqlParser.configBuilder().setQuoting(Quoting.BACK_TICK);
        String selectSql = "select " + ccExpr;
        EscapeParser parser = new EscapeParser(EscapeDialect.CALCITE, selectSql);
        try {
            selectSql = parser.Input();
        }
        catch (ParseException e) {
            throw new KylinException((ErrorCodeSupplier)QueryErrorCode.FAILED_PARSE_ERROR, "Failed to convert column expr " + ccExpr, (Throwable)e);
        }
        SqlParser sqlParser = SqlParser.create((String)selectSql, (SqlParser.Config)parserBuilder.build());
        try {
            select = (SqlSelect)sqlParser.parseQuery();
        }
        catch (SqlParseException e) {
            throw new KylinException((ErrorCodeSupplier)QueryErrorCode.FAILED_PARSE_ERROR, "Failed to parse computed column expr " + ccExpr, (Throwable)e);
        }
        return select.getSelectList().getList().stream().flatMap(op -> MaskUtil.getSqlIdentifiers(op).stream()).collect(Collectors.toList());
    }

    static List<SqlIdentifier> getSqlIdentifiers(SqlNode sqlNode) {
        ArrayList<SqlIdentifier> ids = new ArrayList<SqlIdentifier>();
        if (sqlNode instanceof SqlIdentifier) {
            ids.add((SqlIdentifier)sqlNode);
            return ids;
        }
        if (sqlNode instanceof SqlCall) {
            return ((SqlCall)sqlNode).getOperandList().stream().flatMap(op -> MaskUtil.getSqlIdentifiers(op).stream()).collect(Collectors.toList());
        }
        return ids;
    }
}

