/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.planner;

import java.io.IOException;
import java.util.Locale;
import org.apache.kylin.engine.spark.planner.HLLCountCounter;
import org.apache.kylin.measure.hllc.HLLCounter;
import org.apache.spark.api.java.function.Function2;

public class HLLCountReduceFunc2
implements Function2<byte[], byte[], byte[]> {
    private final int precision;

    public HLLCountReduceFunc2(int precision) {
        this.precision = precision;
    }

    public byte[] call(byte[] bytes1, byte[] bytes2) throws Exception {
        int f2;
        int f1 = HLLCountCounter.readFlag(bytes1);
        if (f1 != (f2 = HLLCountCounter.readFlag(bytes2))) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Bytes flag not matched %d %d", f1, f2));
        }
        switch (f1) {
            case 0: {
                return this.mergePlain(bytes1, bytes2);
            }
            case 1: {
                return this.mergeHll(bytes1, bytes2);
            }
        }
        throw new IllegalArgumentException("Unknown bytes flag " + f1);
    }

    private byte[] mergePlain(byte[] bytes1, byte[] bytes2) {
        long count1 = HLLCountCounter.readPlainCount(bytes1);
        long count2 = HLLCountCounter.readPlainCount(bytes2);
        return HLLCountCounter.plainBytes(count1 + count2);
    }

    private byte[] mergeHll(byte[] bytes1, byte[] bytes2) throws IOException {
        HLLCounter hll1 = HLLCountCounter.readHllCounter(bytes1, this.precision);
        HLLCounter hll2 = HLLCountCounter.readHllCounter(bytes2, this.precision);
        hll1.merge(hll2);
        return HLLCountCounter.hllBytes(hll1);
    }
}

