/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.job;

import java.util.Collection;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.engine.spark.job.ExecutableHandlerFactory;
import org.apache.kylin.engine.spark.job.InternalTableLoadCacheStep;
import org.apache.kylin.engine.spark.job.InternalTableLoadingStep;
import org.apache.kylin.engine.spark.job.InternalTableUpdateMetadataStep;
import org.apache.kylin.engine.spark.job.ModelIndexLoadCacheStep;
import org.apache.kylin.engine.spark.job.NResourceDetectStep;
import org.apache.kylin.engine.spark.job.NSparkCleanupAfterMergeStep;
import org.apache.kylin.engine.spark.job.NSparkCubingStep;
import org.apache.kylin.engine.spark.job.NSparkExecutable;
import org.apache.kylin.engine.spark.job.NSparkIndexPlanOptimizeJob;
import org.apache.kylin.engine.spark.job.NSparkLayoutDataOptimizeStep;
import org.apache.kylin.engine.spark.job.NSparkMergingStep;
import org.apache.kylin.engine.spark.job.NSparkSnapshotBuildingStep;
import org.apache.kylin.engine.spark.job.NSparkUpdateMetadataStep;
import org.apache.kylin.engine.spark.job.NTableSamplingJob;
import org.apache.kylin.engine.spark.job.SparkCleanupTransactionalTableStep;
import org.apache.kylin.engine.spark.job.StageEnum;
import org.apache.kylin.job.execution.AbstractExecutable;
import org.apache.kylin.job.execution.DefaultExecutable;
import org.apache.kylin.job.execution.DefaultExecutableOnModel;
import org.apache.kylin.job.execution.DefaultExecutableOnTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum StepEnum {
    RESOURCE_DETECT{

        @Override
        protected AbstractExecutable createInner(DefaultExecutable parent, KylinConfig config) {
            if (config.getSparkEngineBuildStepsToSkip().contains(NResourceDetectStep.class.getName())) {
                return null;
            }
            return new NResourceDetectStep(parent);
        }
    }
    ,
    CLEANUP_AFTER_MERGE{

        @Override
        protected AbstractExecutable createInner(DefaultExecutable parent, KylinConfig config) {
            return new NSparkCleanupAfterMergeStep();
        }
    }
    ,
    CUBING{

        @Override
        protected AbstractExecutable createInner(DefaultExecutable parent, KylinConfig config) {
            return new NSparkCubingStep(config.getSparkBuildClassName());
        }

        @Override
        protected void addStage(NSparkExecutable step) {
            step.addStage(StageEnum.WAIT_FOR_RESOURCE);
            step.addStage(StageEnum.REFRESH_SNAPSHOT);
            step.addStage(StageEnum.MATERIALIZE_FACT_VIEW);
            step.addStage(StageEnum.BUILD_GLOBAL_DICT);
            step.addStage(StageEnum.MATERIALIZE_FLAT_TABLE);
            String enablePlanner = StringUtils.trim((String)step.getParam("enablePlanner"));
            if (StringUtils.equalsIgnoreCase((CharSequence)enablePlanner, (CharSequence)"true")) {
                step.addStage(StageEnum.COST_BASED_PLANNER);
            }
            step.addStage(StageEnum.BUILD_FLAT_TABLE_STATS);
            step.addStage(StageEnum.BUILD_LAYER);
            step.addStage(StageEnum.REFRESH_COLUMN_BYTES);
        }
    }
    ,
    MERGING{

        @Override
        protected AbstractExecutable createInner(DefaultExecutable parent, KylinConfig config) {
            return new NSparkMergingStep(config.getSparkMergeClassName());
        }

        @Override
        protected void addStage(NSparkExecutable step) {
            step.addStage(StageEnum.WAIT_FOR_RESOURCE);
            step.addStage(StageEnum.MERGE_FLAT_TABLE);
            step.addStage(StageEnum.MERGE_INDICES);
            step.addStage(StageEnum.MERGE_COLUMN_BYTES);
        }
    }
    ,
    BUILD_SNAPSHOT{

        @Override
        protected AbstractExecutable createInner(DefaultExecutable parent, KylinConfig config) {
            return new NSparkSnapshotBuildingStep(config.getSnapshotBuildClassName());
        }

        @Override
        protected void addStage(NSparkExecutable step) {
            step.addStage(StageEnum.WAIT_FOR_RESOURCE);
            step.addStage(StageEnum.BUILD_SNAPSHOT);
        }
    }
    ,
    BUILD_INTERNAL{

        @Override
        protected AbstractExecutable createInner(DefaultExecutable parent, KylinConfig config) {
            return new InternalTableLoadingStep(config.getInternalTableBuildClassName());
        }

        @Override
        protected void addStage(NSparkExecutable step) {
            step.addStage(StageEnum.WAIT_FOR_RESOURCE);
            step.addStage(StageEnum.INTERNAL_TABLE_LOAD);
        }
    }
    ,
    SAMPLING{

        @Override
        protected AbstractExecutable createInner(DefaultExecutable parent, KylinConfig config) {
            return new NTableSamplingJob.SamplingStep(config.getSparkTableSamplingClassName());
        }

        @Override
        protected void addStage(NSparkExecutable step) {
            step.addStage(StageEnum.WAIT_FOR_RESOURCE);
            step.addStage(StageEnum.TABLE_SAMPLING);
        }
    }
    ,
    UPDATE_METADATA{

        @Override
        protected AbstractExecutable createInner(DefaultExecutable parent, KylinConfig config) {
            if (parent instanceof DefaultExecutableOnModel) {
                ((DefaultExecutableOnModel)parent).setHandler(ExecutableHandlerFactory.createExecutableHandler((DefaultExecutableOnModel)parent));
                return new NSparkUpdateMetadataStep();
            }
            if (parent instanceof DefaultExecutableOnTable) {
                return new InternalTableUpdateMetadataStep();
            }
            throw new IllegalArgumentException();
        }
    }
    ,
    CLEANUP_TRANSACTIONAL_TABLE{

        @Override
        protected AbstractExecutable createInner(DefaultExecutable parent, KylinConfig config) {
            return new SparkCleanupTransactionalTableStep();
        }
    }
    ,
    LOAD_GLUTEN_CACHE{

        @Override
        protected AbstractExecutable createInner(DefaultExecutable parent, KylinConfig config) {
            if (parent instanceof DefaultExecutableOnTable) {
                return new InternalTableLoadCacheStep();
            }
            return new ModelIndexLoadCacheStep();
        }
    }
    ,
    LAYOUT_DATA_OPTIMIZE{

        @Override
        protected AbstractExecutable createInner(DefaultExecutable parent, KylinConfig config) {
            return new NSparkLayoutDataOptimizeStep(config.getSparkOptimizeClassName());
        }

        @Override
        protected void addStage(NSparkExecutable step) {
            step.addStage(StageEnum.WAIT_FOR_RESOURCE);
            step.addStage(StageEnum.DELETE_USELESS_LAYOUT_DATA);
            step.addStage(StageEnum.OPTIMIZE_LAYOUT_DATA_BY_REPARTITION);
            step.addStage(StageEnum.OPTIMIZE_LAYOUT_DATA_BY_ZORDER);
            step.addStage(StageEnum.OPTIMIZE_LAYOUT_DATA_BY_COMPACTION);
        }
    }
    ,
    OPTIMIZE_INDEX_PLAN{

        @Override
        protected AbstractExecutable createInner(DefaultExecutable parent, KylinConfig config) {
            return new NSparkIndexPlanOptimizeJob.IndexPlanOptimizeStep(config.getSparkIndexPlanOptClassName());
        }

        @Override
        protected void addStage(NSparkExecutable step) {
            step.addStage(StageEnum.WAIT_FOR_RESOURCE);
            step.addStage(StageEnum.OPTIMIZE_INDEX_PLAN);
        }
    };

    @Generated
    private static final Logger log;

    protected abstract AbstractExecutable createInner(DefaultExecutable var1, KylinConfig var2);

    protected void addStage(NSparkExecutable step) {
    }

    public final AbstractExecutable create(DefaultExecutable parent, KylinConfig config) {
        AbstractExecutable step = this.createInner(parent, config);
        if (step == null) {
            log.info("{} skipped", (Object)this);
        } else {
            this.addParam(parent, step);
        }
        return step;
    }

    protected void addParam(DefaultExecutable parent, AbstractExecutable step) {
        step.setParams(parent.getParams());
        step.setProject(parent.getProject());
        step.setTargetSubject(parent.getTargetSubject());
        step.setJobType(parent.getJobType());
        parent.addTask(step);
        if (step instanceof NSparkExecutable) {
            this.addStage((NSparkExecutable)step);
            ((NSparkExecutable)step).setStageMap();
            ((NSparkExecutable)step).setDistMetaUrl(KylinConfig.readSystemKylinConfig().getJobTmpMetaStoreUrl(parent.getProject(), step.getId()));
        }
        if (CollectionUtils.isNotEmpty((Collection)parent.getTargetPartitions())) {
            step.setTargetPartitions(parent.getTargetPartitions());
        }
    }

    static {
        log = LoggerFactory.getLogger(StepEnum.class);
    }
}

