/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.job;

import java.util.HashSet;
import java.util.Set;
import lombok.Generated;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.KylinConfigExt;
import org.apache.kylin.common.util.RandomUtil;
import org.apache.kylin.engine.spark.job.NResourceDetectStep;
import org.apache.kylin.engine.spark.job.NSparkExecutable;
import org.apache.kylin.engine.spark.job.StepEnum;
import org.apache.kylin.engine.spark.utils.ExecutableHandleUtils;
import org.apache.kylin.engine.spark.utils.HiveTableRefChecker;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.kylin.job.JobContext;
import org.apache.kylin.job.exception.ExecuteException;
import org.apache.kylin.job.execution.AbstractExecutable;
import org.apache.kylin.job.execution.DefaultExecutable;
import org.apache.kylin.job.execution.DefaultExecutableOnTable;
import org.apache.kylin.job.execution.ExecutableHandler;
import org.apache.kylin.job.execution.ExecuteResult;
import org.apache.kylin.job.execution.JobTypeEnum;
import org.apache.kylin.job.execution.MergerInfo;
import org.apache.kylin.job.factory.JobFactory;
import org.apache.kylin.job.handler.TableSamplingJobHandler;
import org.apache.kylin.metadata.model.NTableMetadataManager;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.model.TableExtDesc;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NTableSamplingJob
extends DefaultExecutableOnTable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NTableSamplingJob.class);

    public NTableSamplingJob() {
    }

    public NTableSamplingJob(Object notSetId) {
        super(notSetId);
    }

    public static NTableSamplingJob create(TableSamplingJobHandler.TableSamplingJobBuildParam param) {
        NTableMetadataManager tblMgr = NTableMetadataManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)param.getProject());
        TableDesc tableDesc = tblMgr.getTableDesc(param.getTable());
        return NTableSamplingJob.internalCreate(tableDesc, param.getProject(), param.getSubmitter(), param.getRow(), param.getJobId());
    }

    public static NTableSamplingJob internalCreate(TableDesc tableDesc, String project, String submitter, int rows) {
        return NTableSamplingJob.internalCreate(tableDesc, project, submitter, rows, RandomUtil.randomUUIDStr());
    }

    public static NTableSamplingJob internalCreate(TableDesc tableDesc, String project, String submitter, int rows, String jobId) {
        Preconditions.checkArgument((tableDesc != null ? 1 : 0) != 0, (Object)"Create table sampling job failed for table not exist!");
        log.info("start creating a table sampling job on table {}", (Object)tableDesc.getIdentity());
        NTableSamplingJob job = new NTableSamplingJob();
        job.setId(jobId);
        job.setName(JobTypeEnum.TABLE_SAMPLING.toString());
        job.setProject(project);
        job.setJobType(JobTypeEnum.TABLE_SAMPLING);
        job.setTargetSubject(tableDesc.getIdentity());
        job.setSubmitter(submitter);
        job.setParam("project", project);
        job.setParam("jobId", job.getId());
        job.setParam("table", tableDesc.getIdentity());
        job.setParam("samplingRows", String.valueOf(rows));
        KylinConfig globalConfig = KylinConfig.getInstanceFromEnv();
        KylinConfigExt config = NProjectManager.getInstance((KylinConfig)globalConfig).getProject(project).getConfig();
        StepEnum.RESOURCE_DETECT.create((DefaultExecutable)job, (KylinConfig)config);
        StepEnum.SAMPLING.create((DefaultExecutable)job, (KylinConfig)config);
        if (HiveTableRefChecker.isNeedCleanUpTransactionalTableJob(tableDesc.isTransactional(), tableDesc.isRangePartition(), config.isReadTransactionalTableEnabled())) {
            StepEnum.CLEANUP_TRANSACTIONAL_TABLE.create((DefaultExecutable)job, (KylinConfig)config);
        }
        log.info("sampling job create success on table {}", (Object)tableDesc.getIdentity());
        return job;
    }

    public Set<String> getMetadataDumpList(KylinConfig config) {
        String table = this.getParam("table");
        TableDesc tableDesc = NTableMetadataManager.getInstance((KylinConfig)config, (String)this.getProject()).getTableDesc(table);
        ProjectInstance projectInstance = NProjectManager.getInstance((KylinConfig)config).getProject(this.getProject());
        HashSet dumpList = Sets.newHashSet((Object[])new String[]{tableDesc.getResourcePath(), projectInstance.getResourcePath()});
        TableExtDesc tableExtDesc = NTableMetadataManager.getInstance((KylinConfig)config, (String)this.getProject()).getTableExtIfExists(tableDesc);
        if (tableExtDesc != null) {
            dumpList.add(tableExtDesc.getResourcePath());
        }
        return dumpList;
    }

    public boolean checkSuicide() {
        return null == NTableMetadataManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)this.getProject()).getTableDesc(this.getTableIdentity());
    }

    public NResourceDetectStep getResourceDetectStep() {
        return (NResourceDetectStep)this.getTask(NResourceDetectStep.class);
    }

    public SamplingStep getSamplingStep() {
        return (SamplingStep)this.getTask(SamplingStep.class);
    }

    static {
        JobFactory.register((String)"TABLE_SAMPLING_JOB_FACTORY", (JobFactory)new TableSamplingJobFactory());
    }

    public static class TableSamplingJobFactory
    extends JobFactory {
        protected TableSamplingJobFactory() {
        }

        protected NTableSamplingJob create(JobFactory.JobBuildParams jobBuildParams) {
            return NTableSamplingJob.create((TableSamplingJobHandler.TableSamplingJobBuildParam)jobBuildParams);
        }
    }

    public static class SamplingStep
    extends NSparkExecutable {
        public SamplingStep() {
        }

        public SamplingStep(Object notSetId) {
            super(notSetId);
        }

        public SamplingStep(String sparkSubmitClassName) {
            this.setSparkSubmitClassName(sparkSubmitClassName);
            this.setName("Table Sampling");
        }

        private String getTableIdentity() {
            return this.getParam("table");
        }

        @Override
        protected ExecuteResult doWork(JobContext context) throws ExecuteException {
            ExecuteResult result = super.doWork(context);
            if (!result.succeed()) {
                return result;
            }
            if (this.checkSuicide()) {
                log.info("This Table Sampling job seems meaningless now, quit before mergeRemoteMetaAfterSampling()");
                return null;
            }
            MergerInfo mergerInfo = new MergerInfo(this.project, ExecutableHandler.HandlerType.SAMPLING);
            mergerInfo.addTaskMergeInfo((AbstractExecutable)this);
            ExecutableHandleUtils.mergeMetadataForTable(this.project, mergerInfo);
            return result;
        }

        @Override
        protected Set<String> getMetadataDumpList(KylinConfig config) {
            TableDesc table;
            HashSet dumpList = Sets.newHashSet();
            ProjectInstance instance = NProjectManager.getInstance((KylinConfig)config).getProject(this.getProject());
            dumpList.add(instance.getResourcePath());
            NTableMetadataManager tableMetadataManager = NTableMetadataManager.getInstance((KylinConfig)config, (String)this.getProject());
            TableExtDesc tableExtDesc = tableMetadataManager.getTableExtIfExists(tableMetadataManager.getTableDesc(this.getTableIdentity()));
            if (tableExtDesc != null) {
                dumpList.add(tableExtDesc.getResourcePath());
            }
            if ((table = tableMetadataManager.getTableDesc(this.getTableIdentity())) != null) {
                dumpList.add(table.getResourcePath());
            }
            dumpList.addAll(this.getLogicalViewMetaDumpList(config));
            return dumpList;
        }
    }
}

