/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.job;

import java.io.IOException;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.engine.spark.application.SparkApplication;
import org.apache.kylin.engine.spark.builder.InternalTableLoader;
import org.apache.kylin.engine.spark.job.exec.InternalTableLoadExec;
import org.apache.kylin.engine.spark.job.stage.internal.InternalTableLoad;
import org.apache.kylin.metadata.table.InternalTableDesc;
import org.apache.kylin.metadata.table.InternalTableManager;
import org.apache.kylin.metadata.table.InternalTablePartitionDetail;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InternalTableLoadJob
extends SparkApplication {
    protected static final Logger logger = LoggerFactory.getLogger(InternalTableLoadJob.class);

    public static void main(String[] args) {
        InternalTableLoadJob job = new InternalTableLoadJob();
        job.execute(args);
    }

    @Override
    protected void doExecute() throws Exception {
        String jobStepId = StringUtils.replace((String)this.infos.getJobStepId(), (String)"job_step_", (String)"");
        InternalTableLoadExec exec = new InternalTableLoadExec(jobStepId);
        exec.addStage(new InternalTableLoad(this));
        exec.executeStep();
    }

    public void innerExecute() throws IOException {
        boolean dropPartition = Boolean.parseBoolean(this.getParam("deletePartition"));
        if (dropPartition) {
            logger.info("Start to drop partitions");
            this.dropPartitons();
        } else {
            logger.info("Start to load data into table");
            this.loadIntoInternalTable();
        }
    }

    public void loadIntoInternalTable() throws IOException {
        String tableIdentity = this.getParam("table");
        InternalTableDesc internalTable = InternalTableManager.getInstance((KylinConfig)this.config, (String)this.project).getInternalTableDesc(tableIdentity);
        boolean incrementalBuild = "true".equals(this.getParam("incrementalBuild"));
        String startDate = this.getParam("startTime");
        String endDate = this.getParam("endTime");
        String storagePolicy = this.config.getGlutenStoragePolicy();
        InternalTableLoader loader = new InternalTableLoader();
        loader.loadInternalTable(this.ss, internalTable, new String[]{startDate, endDate}, null, storagePolicy, incrementalBuild);
    }

    public void dropPartitons() throws IOException {
        InternalTableLoader loader = new InternalTableLoader();
        String tableName = this.getParam("table");
        String toBeDelete = this.getParam("deletePartitionValues");
        InternalTableDesc internalTable = InternalTableManager.getInstance((KylinConfig)this.config, (String)this.project).getInternalTableDesc(tableName);
        loader.dropPartitions(this.ss, internalTable, toBeDelete);
    }

    public static class InternalTableMetaUpdateInfo {
        long finalCount;
        List<String> partitionValues;
        List<InternalTablePartitionDetail> partitionDetails;

        @Generated
        public long getFinalCount() {
            return this.finalCount;
        }

        @Generated
        public List<String> getPartitionValues() {
            return this.partitionValues;
        }

        @Generated
        public List<InternalTablePartitionDetail> getPartitionDetails() {
            return this.partitionDetails;
        }

        @Generated
        public InternalTableMetaUpdateInfo(long finalCount, List<String> partitionValues, List<InternalTablePartitionDetail> partitionDetails) {
            this.finalCount = finalCount;
            this.partitionValues = partitionValues;
            this.partitionDetails = partitionDetails;
        }
    }
}

