/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.builder;

import java.io.IOException;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.kylin.common.KapConfig;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.transaction.UnitOfWork;
import org.apache.kylin.common.persistence.transaction.UnitOfWorkParams;
import org.apache.kylin.engine.spark.builder.SnapshotBuilder;
import org.apache.kylin.engine.spark.builder.SnapshotPartitionBuilder;
import org.apache.kylin.engine.spark.utils.LogUtils$;
import org.apache.kylin.metadata.datatype.DataType;
import org.apache.kylin.metadata.model.NTableMetadataManager;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.model.TableExtDesc;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.utils.ProxyThreadUtils$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set$;
import scala.collection.mutable.ArrayOps;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.ExecutionContextExecutorService;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LazyRef;

@ScalaSignature(bytes="\u0006\u0001\u0005=c\u0001B\u0004\t\u0001UAQA\u0007\u0001\u0005\u0002mAQ!\b\u0001\u0005\u0002yAQ\u0001\u001e\u0001\u0005\u0002UDq!a\u0005\u0001\t\u0003\t)\u0002C\u0004\u0002$\u0001!\t!!\n\t\u000f\u0005u\u0002\u0001\"\u0001\u0002@\tA2K\\1qg\"|G\u000fU1si&$\u0018n\u001c8Ck&dG-\u001a:\u000b\u0005%Q\u0011a\u00022vS2$WM\u001d\u0006\u0003\u00171\tQa\u001d9be.T!!\u0004\b\u0002\r\u0015tw-\u001b8f\u0015\ty\u0001#A\u0003ls2LgN\u0003\u0002\u0012%\u00051\u0011\r]1dQ\u0016T\u0011aE\u0001\u0004_J<7\u0001A\n\u0003\u0001Y\u0001\"a\u0006\r\u000e\u0003!I!!\u0007\u0005\u0003\u001fMs\u0017\r]:i_R\u0014U/\u001b7eKJ\fa\u0001P5oSRtD#\u0001\u000f\u0011\u0005]\u0001\u0011!\u00042vS2$7K\\1qg\"|G\u000fF\u0003 K9BT\t\u0005\u0002!G5\t\u0011EC\u0001#\u0003\u0015\u00198-\u00197b\u0013\t!\u0013E\u0001\u0003V]&$\b\"\u0002\u0014\u0003\u0001\u00049\u0013AA:t!\tAC&D\u0001*\u0015\tQ3&A\u0002tc2T!a\u0003\t\n\u00055J#\u0001D*qCJ\\7+Z:tS>t\u0007\"B\u0018\u0003\u0001\u0004\u0001\u0014!\u0002;bE2,\u0007CA\u00197\u001b\u0005\u0011$BA\u001a5\u0003\u0015iw\u000eZ3m\u0015\t)d\"\u0001\u0005nKR\fG-\u0019;b\u0013\t9$GA\u0005UC\ndW\rR3tG\")\u0011H\u0001a\u0001u\u0005a\u0001/\u0019:uSRLwN\\\"pYB\u00111H\u0011\b\u0003y\u0001\u0003\"!P\u0011\u000e\u0003yR!a\u0010\u000b\u0002\rq\u0012xn\u001c;?\u0013\t\t\u0015%\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u0007\u0012\u0013aa\u0015;sS:<'BA!\"\u0011\u00151%\u00011\u0001H\u0003)\u0001\u0018M\u001d;ji&|gn\u001d\t\u0004\u00116ST\"A%\u000b\u0005)[\u0015\u0001B;uS2T\u0011\u0001T\u0001\u0005U\u00064\u0018-\u0003\u0002O\u0013\n\u00191+\u001a;)\u0007\t\u0001\u0016\fE\u0002!#NK!AU\u0011\u0003\rQD'o\\<t!\t!v+D\u0001V\u0015\t16*\u0001\u0002j_&\u0011\u0001,\u0016\u0002\f\u0013>+\u0005pY3qi&|g.\r\u0003\u001fui\u001b\u0018'B\u0012\\?:\u0004WC\u0001/^+\u0005QD!\u00020\u0015\u0005\u0004\u0019'!\u0001+\n\u0005\u0001\f\u0017a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$\u0013G\u0003\u0002cC\u00051A\u000f\u001b:poN\f\"\u0001Z4\u0011\u0005\u0001*\u0017B\u00014\"\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"\u0001[6\u000f\u0005\u0001J\u0017B\u00016\"\u0003\u001d\u0001\u0018mY6bO\u0016L!\u0001\\7\u0003\u0013QC'o\\<bE2,'B\u00016\"c\u0015\u0019s\u000e]9c\u001d\t\u0001\u0003/\u0003\u0002cCE\"!\u0005I\u0011s\u0005\u0015\u00198-\u00197bc\t13+\u0001\fdQ\u0016\u001c7\u000eU8j]R4uN\u001d)beRLG/[8o)\u0011yb\u000f\u001f>\t\u000b]\u001c\u0001\u0019\u0001\u001e\u0002\u000fA\u0014xN[3di\")\u0011p\u0001a\u0001u\u0005IA/\u00192mK:\u000bW.\u001a\u0005\u0006w\u000e\u0001\r\u0001`\u0001\be\u0016\u001cX\u000f\u001c;t!\u0015i\u0018\u0011AA\u0003\u001d\tq\u0018N\u0004\u0002>\u007f&\t!%C\u0002\u0002\u00045\u0014A\u0001T5tiB1\u0001%a\u0002;\u0003\u0017I1!!\u0003\"\u0005\u0019!V\u000f\u001d7feA!\u0011QBA\b\u001b\u0005\u0001\u0011bAA\t1\t1!+Z:vYR\fA#\u001a=fGV$XMQ;jY\u0012\u001cf.\u00199tQ>$H#C\u0010\u0002\u0018\u0005e\u00111DA\u000f\u0011\u00151C\u00011\u0001(\u0011\u0015yC\u00011\u00011\u0011\u0015ID\u00011\u0001;\u0011\u00191E\u00011\u0001\u0002 A!1(!\t;\u0013\tqE)A\u0005oK^4\u0015\u000e\u001c;feR9!(a\n\u0002*\u00055\u0002\"B\u001d\u0006\u0001\u0004Q\u0004BBA\u0016\u000b\u0001\u0007!(A\u0005qCJ$\u0018\u000e^5p]\"9\u0011qF\u0003A\u0002\u0005E\u0012aB2pYRK\b/\u001a\t\u0005\u0003g\tI$\u0004\u0002\u00026)\u0019\u0011q\u0007\u001b\u0002\u0011\u0011\fG/\u0019;za\u0016LA!a\u000f\u00026\tAA)\u0019;b)f\u0004X-A\u000fck&dGmU5oO2,7K\\1qg\"|GoV5uQ>,H/\u001436)1\tY!!\u0011\u0002D\u0005\u001d\u0013\u0011JA&\u0011\u00151c\u00011\u0001(\u0011\u0019\t)E\u0002a\u0001a\u0005IA/\u00192mK\u0012+7o\u0019\u0005\u0006s\u0019\u0001\rA\u000f\u0005\u0007\u0003W1\u0001\u0019\u0001\u001e\t\r\u00055c\u00011\u0001;\u0003E\u0019h.\u00199tQ>$H+\u00192mKB\u000bG\u000f\u001b")
public class SnapshotPartitionBuilder
extends SnapshotBuilder {
    public void buildSnapshot(SparkSession ss, TableDesc table, String partitionCol, Set<String> partitions) throws IOException {
        this.executeBuildSnapshot(ss, table, partitionCol, (scala.collection.immutable.Set<String>)((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(partitions).asScala()).toSet());
    }

    public void checkPointForPartition(String project, String tableName, List<Tuple2<String, SnapshotBuilder.Result>> results) {
        public class Org_apache_kylin_engine_spark_builder_SnapshotPartitionBuilder$TableUpdateOps$1
        implements UnitOfWork.Callback<TableDesc> {
            private final String project$1;
            private final String tableName$1;
            private final List results$1;

            public void preProcess() {
                super.preProcess();
            }

            public void onProcessError(Throwable x$1) {
                super.onProcessError(x$1);
            }

            public TableDesc process() {
                NTableMetadataManager tableMetadataManager = NTableMetadataManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)this.project$1);
                TableDesc originTable = tableMetadataManager.getTableDesc(this.tableName$1);
                tableMetadataManager.updateTableExt(this.tableName$1, copyForWrite -> $this.results$1.foreach((Function1 & Serializable & scala.Serializable)item -> {
                    Org_apache_kylin_engine_spark_builder_SnapshotPartitionBuilder$TableUpdateOps$1.$anonfun$process$2(copyForWrite, originTable, item);
                    return BoxedUnit.UNIT;
                }));
                tableMetadataManager.updateTableDesc(this.tableName$1, copyForWrite -> $this.results$1.foreach((Function1 & Serializable & scala.Serializable)item -> {
                    Org_apache_kylin_engine_spark_builder_SnapshotPartitionBuilder$TableUpdateOps$1.$anonfun$process$4(copyForWrite, item);
                    return BoxedUnit.UNIT;
                }));
                return tableMetadataManager.getTableDesc(this.tableName$1);
            }

            public static final /* synthetic */ void $anonfun$process$2(TableExtDesc copyForWrite$1, TableDesc originTable$1, Tuple2 item) {
                block0: {
                    String partition = (String)item._1();
                    SnapshotBuilder.Result result = (SnapshotBuilder.Result)item._2();
                    if (result.totalRows() == -1L) break block0;
                    copyForWrite$1.setTotalRows(copyForWrite$1.getTotalRows() + result.totalRows() - originTable$1.getPartitionRow(partition));
                }
            }

            public static final /* synthetic */ void $anonfun$process$4(TableDesc copyForWrite$2, Tuple2 item) {
                String partition = (String)item._1();
                SnapshotBuilder.Result result = (SnapshotBuilder.Result)item._2();
                if (result.totalRows() != -1L) {
                    copyForWrite$2.putPartitionSize(partition, result.originalSize());
                    copyForWrite$2.setSnapshotTotalRows(copyForWrite$2.getSnapshotTotalRows() + result.totalRows() - copyForWrite$2.getPartitionRow(partition));
                    copyForWrite$2.putPartitionRow(partition, result.totalRows());
                } else {
                    copyForWrite$2.putPartitionSize(partition, 0L);
                    copyForWrite$2.putPartitionRow(partition, 0L);
                }
            }

            public Org_apache_kylin_engine_spark_builder_SnapshotPartitionBuilder$TableUpdateOps$1(SnapshotPartitionBuilder $outer, String project$1, String tableName$1, List results$1) {
                this.project$1 = project$1;
                this.tableName$1 = tableName$1;
                this.results$1 = results$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$process$2$adapted(org.apache.kylin.metadata.model.TableExtDesc org.apache.kylin.metadata.model.TableDesc scala.Tuple2 ), $anonfun$process$4$adapted(org.apache.kylin.metadata.model.TableDesc scala.Tuple2 )}, serializedLambda);
            }
        }
        UnitOfWorkParams params = UnitOfWorkParams.builder().unitName(project).maxRetry(3).useProjectLock(true).processor((UnitOfWork.Callback)new Org_apache_kylin_engine_spark_builder_SnapshotPartitionBuilder$TableUpdateOps$1(null, project, tableName, results)).build();
        UnitOfWork.doInTransactionWithRetry((UnitOfWorkParams)params);
        this.log().info(new StringBuilder(46).append("check point partitions for ").append(tableName).append(" , partition size: ").append(results.size()).toString());
    }

    public void executeBuildSnapshot(SparkSession ss, TableDesc table, String partitionCol, scala.collection.immutable.Set<String> partitions) {
        String baseDir = KapConfig.getInstanceFromEnv().getMetadataWorkingDirectory();
        String resourcePath = table.getTempSnapshotPath();
        String snapshotTablePath = new StringBuilder(0).append(baseDir).append('/').append(resourcePath).toString();
        KylinConfig kylinConf = KylinConfig.getInstanceFromEnv();
        int snapshotParallelBuildTimeoutSeconds = kylinConf.snapshotParallelBuildTimeoutSeconds();
        int maxThread = kylinConf.snapshotPartitionBuildMaxThread() >= 2 ? kylinConf.snapshotPartitionBuildMaxThread() : 2;
        ExecutorService service = Executors.newFixedThreadPool(maxThread);
        ExecutionContextExecutorService executorContext = ExecutionContext$.MODULE$.fromExecutorService(service);
        scala.collection.immutable.Set futures = (scala.collection.immutable.Set)partitions.map((Function1 & Serializable & scala.Serializable)partition -> Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (Tuple2)this.wrapConfigExecute((Function0 & Serializable & scala.Serializable)() -> new Tuple2(partition, (Object)this.buildSingleSnapshotWithoutMd5(ss, table, partitionCol, (String)partition, snapshotTablePath)), new StringBuilder(1).append(table.getIdentity()).append(":").append((String)partition).toString()), (ExecutionContext)executorContext), Set$.MODULE$.canBuildFrom());
        try {
            Future eventualTuples = Future$.MODULE$.sequence((TraversableOnce)futures.toList(), List$.MODULE$.canBuildFrom(), (ExecutionContext)executorContext);
            List results = (List)ProxyThreadUtils$.MODULE$.awaitResult(eventualTuples, (Duration)new package.DurationInt(package$.MODULE$.DurationInt(snapshotParallelBuildTimeoutSeconds)).seconds());
            this.checkPointForPartition(table.getProject(), table.getIdentity(), (List<Tuple2<String, SnapshotBuilder.Result>>)results);
        }
        finally {
            ProxyThreadUtils$.MODULE$.shutdown(service, ProxyThreadUtils$.MODULE$.shutdown$default$2());
        }
    }

    public String newFilter(String partitionCol, String partition, DataType colType) {
        return colType.isDate() ? new StringBuilder(20).append("`").append(partitionCol).append("`").append("= cast('").append(partition).append("' as date)").toString() : (colType.isNumberFamily() ? new StringBuilder(4).append("`").append(partitionCol).append("`").append("= ").append(partition).toString() : new StringBuilder(6).append("`").append(partitionCol).append("`").append("= '").append(partition).append("'").toString());
    }

    public SnapshotBuilder.Result buildSingleSnapshotWithoutMd5(SparkSession ss, TableDesc tableDesc, String partitionCol, String partition, String snapshotTablePath) {
        LazyRef snapshotInfo$lzy = new LazyRef();
        Dataset sourceData = this.getSourceData(ss, tableDesc);
        sourceData = sourceData.filter(this.newFilter(partitionCol, partition, tableDesc.findColumnByName(partitionCol).getType()));
        sourceData = sourceData.selectExpr((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sourceData.columns())).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)SnapshotPartitionBuilder.$anonfun$buildSingleSnapshotWithoutMd5$1(partitionCol, x$1))))).map((Function1 & Serializable & scala.Serializable)x$2 -> new StringBuilder(2).append("`").append((String)x$2).append("`").toString(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))));
        String newPartition = partition.replaceAll(" ", "_");
        newPartition = newPartition.replaceAll(":", "_");
        String partitionName = new StringBuilder(0).append(partitionCol).append('=').append(newPartition).toString();
        String resourcePath = new StringBuilder(1).append(snapshotTablePath).append("/").append(partitionName).toString();
        Tuple2<Object, Object> tuple2 = this.decideSparkJobArg((Dataset<Row>)sourceData);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        int repartitionNum = tuple2._1$mcI$sp();
        double sizeMB = tuple2._2$mcD$sp();
        Tuple2.mcID.sp sp2 = new Tuple2.mcID.sp(repartitionNum, sizeMB);
        Tuple2.mcID.sp sp3 = sp2;
        int repartitionNum2 = sp3._1$mcI$sp();
        double sizeMB2 = sp3._2$mcD$sp();
        ss.sparkContext().setJobDescription(new StringBuilder(22).append("Build table snapshot ").append(tableDesc.getIdentity()).append(".").toString());
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(19).append("Building snapshot: ").append(LogUtils$.MODULE$.jsonMap(SnapshotPartitionBuilder.snapshotInfo$1(snapshotInfo$lzy, tableDesc, snapshotTablePath, sizeMB2, repartitionNum2, partition))).toString());
        if (repartitionNum2 == 0) {
            sourceData.write().mode(SaveMode.Overwrite).parquet(resourcePath);
        } else {
            sourceData.repartition(repartitionNum2).write().mode(SaveMode.Overwrite).parquet(resourcePath);
        }
        Tuple2<Object, Object> tuple22 = this.computeSnapshotSize((Dataset<Row>)sourceData);
        if (tuple22 == null) {
            throw new MatchError(tuple22);
        }
        long originSize = tuple22._1$mcJ$sp();
        long totalRows = tuple22._2$mcJ$sp();
        Tuple2.mcJJ.sp sp4 = new Tuple2.mcJJ.sp(originSize, totalRows);
        Tuple2.mcJJ.sp sp5 = sp4;
        long originSize2 = sp5._1$mcJ$sp();
        long totalRows2 = sp5._2$mcJ$sp();
        return new SnapshotBuilder.Result(this, snapshotTablePath, originSize2, totalRows2);
    }

    public static final /* synthetic */ boolean $anonfun$buildSingleSnapshotWithoutMd5$1(String partitionCol$2, String x$1) {
        return !x$1.equals(partitionCol$2);
    }

    private static final /* synthetic */ Map snapshotInfo$lzycompute$1(LazyRef snapshotInfo$lzy$1, TableDesc tableDesc$1, String snapshotTablePath$2, double sizeMB$1, int repartitionNum$1, String partition$2) {
        Map map;
        LazyRef lazyRef = snapshotInfo$lzy$1;
        synchronized (lazyRef) {
            map = snapshotInfo$lzy$1.initialized() ? (Map)snapshotInfo$lzy$1.value() : (Map)snapshotInfo$lzy$1.initialize((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"source"), (Object)tableDesc$1.getIdentity()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"snapshot"), (Object)snapshotTablePath$2), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sizeMB"), (Object)BoxesRunTime.boxToDouble((double)sizeMB$1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partition"), (Object)BoxesRunTime.boxToInteger((int)repartitionNum$1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"buildPartition"), (Object)partition$2)})));
        }
        return map;
    }

    private static final Map snapshotInfo$1(LazyRef snapshotInfo$lzy$1, TableDesc tableDesc$1, String snapshotTablePath$2, double sizeMB$1, int repartitionNum$1, String partition$2) {
        return snapshotInfo$lzy$1.initialized() ? (Map)snapshotInfo$lzy$1.value() : SnapshotPartitionBuilder.snapshotInfo$lzycompute$1(snapshotInfo$lzy$1, tableDesc$1, snapshotTablePath$2, sizeMB$1, repartitionNum$1, partition$2);
    }
}

