/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gluten.substrait.rel;

import io.substrait.proto.Rel;
import io.substrait.proto.RelCommon;
import io.substrait.proto.SortField;
import io.substrait.proto.WindowRel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.gluten.substrait.expression.ExpressionNode;
import org.apache.gluten.substrait.expression.WindowFunctionNode;
import org.apache.gluten.substrait.extensions.AdvancedExtensionNode;
import org.apache.gluten.substrait.rel.RelNode;

public class WindowRelNode
implements RelNode,
Serializable {
    private final RelNode input;
    private final List<WindowFunctionNode> windowFunctionNodes = new ArrayList<WindowFunctionNode>();
    private final List<ExpressionNode> partitionExpressions = new ArrayList<ExpressionNode>();
    private final List<SortField> sorts = new ArrayList<SortField>();
    private final AdvancedExtensionNode extensionNode;

    public WindowRelNode(RelNode input, List<WindowFunctionNode> windowFunctionNodes, List<ExpressionNode> partitionExpressions, List<SortField> sorts) {
        this.input = input;
        this.windowFunctionNodes.addAll(windowFunctionNodes);
        this.partitionExpressions.addAll(partitionExpressions);
        this.sorts.addAll(sorts);
        this.extensionNode = null;
    }

    public WindowRelNode(RelNode input, List<WindowFunctionNode> windowFunctionNodes, List<ExpressionNode> partitionExpressions, List<SortField> sorts, AdvancedExtensionNode extensionNode) {
        this.input = input;
        this.windowFunctionNodes.addAll(windowFunctionNodes);
        this.partitionExpressions.addAll(partitionExpressions);
        this.sorts.addAll(sorts);
        this.extensionNode = extensionNode;
    }

    @Override
    public Rel toProtobuf() {
        int i;
        RelCommon.Builder relCommonBuilder = RelCommon.newBuilder();
        relCommonBuilder.setDirect(RelCommon.Direct.newBuilder());
        WindowRel.Builder windowBuilder = WindowRel.newBuilder();
        windowBuilder.setCommon(relCommonBuilder.build());
        if (this.input != null) {
            windowBuilder.setInput(this.input.toProtobuf());
        }
        for (WindowFunctionNode windowFunctionNode : this.windowFunctionNodes) {
            WindowRel.Measure.Builder measureBuilder = WindowRel.Measure.newBuilder();
            measureBuilder.setMeasure(windowFunctionNode.toProtobuf());
            windowBuilder.addMeasures(measureBuilder.build());
        }
        for (i = 0; i < this.partitionExpressions.size(); ++i) {
            windowBuilder.addPartitionExpressions(i, this.partitionExpressions.get(i).toProtobuf());
        }
        for (i = 0; i < this.sorts.size(); ++i) {
            windowBuilder.addSorts(i, this.sorts.get(i));
        }
        if (this.extensionNode != null) {
            windowBuilder.setAdvancedExtension(this.extensionNode.toProtobuf());
        }
        Rel.Builder builder = Rel.newBuilder();
        builder.setWindow(windowBuilder.build());
        return builder.build();
    }
}

