/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gluten.substrait.expression;

import io.substrait.proto.Expression;
import io.substrait.proto.FunctionArgument;
import io.substrait.proto.FunctionOption;
import io.substrait.proto.WindowType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.gluten.exception.GlutenException;
import org.apache.gluten.expression.ExpressionConverter;
import org.apache.gluten.substrait.expression.ExpressionNode;
import org.apache.gluten.substrait.type.TypeNode;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.PreComputeRangeFrameBound;
import scala.collection.Iterator;
import scala.collection.JavaConverters;
import scala.collection.Seq;

public class WindowFunctionNode
implements Serializable {
    private final Integer functionId;
    private final List<ExpressionNode> expressionNodes = new ArrayList<ExpressionNode>();
    private final String columnName;
    private final TypeNode outputTypeNode;
    private final Expression upperBound;
    private final Expression lowerBound;
    private final String frameType;
    private final boolean ignoreNulls;
    private final List<Attribute> originalInputAttributes;

    WindowFunctionNode(Integer functionId, List<ExpressionNode> expressionNodes, String columnName, TypeNode outputTypeNode, Expression upperBound, Expression lowerBound, String frameType, boolean ignoreNulls, List<Attribute> originalInputAttributes) {
        this.functionId = functionId;
        this.expressionNodes.addAll(expressionNodes);
        this.columnName = columnName;
        this.outputTypeNode = outputTypeNode;
        this.upperBound = upperBound;
        this.lowerBound = lowerBound;
        this.frameType = frameType;
        this.ignoreNulls = ignoreNulls;
        this.originalInputAttributes = originalInputAttributes;
    }

    private Expression.WindowFunction.Bound.Builder setBound(Expression.WindowFunction.Bound.Builder builder, Expression boundType) {
        switch (boundType.sql()) {
            case "CURRENT ROW": {
                Expression.WindowFunction.Bound.CurrentRow.Builder currentRowBuilder = Expression.WindowFunction.Bound.CurrentRow.newBuilder();
                builder.setCurrentRow(currentRowBuilder.build());
                break;
            }
            case "UNBOUNDED PRECEDING": {
                Expression.WindowFunction.Bound.Unbounded_Preceding.Builder precedingBuilder = Expression.WindowFunction.Bound.Unbounded_Preceding.newBuilder();
                builder.setUnboundedPreceding(precedingBuilder.build());
                break;
            }
            case "UNBOUNDED FOLLOWING": {
                Expression.WindowFunction.Bound.Unbounded_Following.Builder followingBuilder = Expression.WindowFunction.Bound.Unbounded_Following.newBuilder();
                builder.setUnboundedFollowing(followingBuilder.build());
                break;
            }
            default: {
                if (boundType instanceof PreComputeRangeFrameBound) {
                    if (!this.frameType.equals("RANGE")) {
                        throw new GlutenException("Only Range frame supports PreComputeRangeFrameBound, but got " + this.frameType);
                    }
                    ExpressionNode refNode = ExpressionConverter.replaceWithExpressionTransformer((Expression)((PreComputeRangeFrameBound)boundType).child().toAttribute(), (Seq<Attribute>)((Iterator)JavaConverters.asScalaIteratorConverter(this.originalInputAttributes.iterator()).asScala()).toSeq()).doTransform(new HashMap());
                    Long offset = Long.valueOf(boundType.eval(null).toString());
                    if (offset < 0L) {
                        Expression.WindowFunction.Bound.Preceding.Builder refPrecedingBuilder = Expression.WindowFunction.Bound.Preceding.newBuilder();
                        refPrecedingBuilder.setRef(refNode.toProtobuf());
                        builder.setPreceding(refPrecedingBuilder.build());
                        break;
                    }
                    Expression.WindowFunction.Bound.Following.Builder refFollowingBuilder = Expression.WindowFunction.Bound.Following.newBuilder();
                    refFollowingBuilder.setRef(refNode.toProtobuf());
                    builder.setFollowing(refFollowingBuilder.build());
                    break;
                }
                if (boundType.foldable()) {
                    Long offset = Long.valueOf(boundType.eval(null).toString());
                    if (offset < 0L) {
                        Expression.WindowFunction.Bound.Preceding.Builder offsetPrecedingBuilder = Expression.WindowFunction.Bound.Preceding.newBuilder();
                        offsetPrecedingBuilder.setOffset(0L - offset);
                        builder.setPreceding(offsetPrecedingBuilder.build());
                        break;
                    }
                    Expression.WindowFunction.Bound.Following.Builder offsetFollowingBuilder = Expression.WindowFunction.Bound.Following.newBuilder();
                    offsetFollowingBuilder.setOffset(offset);
                    builder.setFollowing(offsetFollowingBuilder.build());
                    break;
                }
                throw new UnsupportedOperationException("Unsupported Window Function Frame Bound Type: " + boundType);
            }
        }
        return builder;
    }

    private WindowType getWindowType(String type) {
        WindowType windowType;
        switch (type) {
            case "ROWS": {
                windowType = WindowType.forNumber(0);
                break;
            }
            case "RANGE": {
                windowType = WindowType.forNumber(1);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Only support ROWS and RANGE Frame type.");
            }
        }
        return windowType;
    }

    public Expression.WindowFunction toProtobuf() {
        Expression.WindowFunction.Builder windowBuilder = Expression.WindowFunction.newBuilder();
        windowBuilder.setFunctionReference(this.functionId);
        if (this.ignoreNulls) {
            FunctionOption option = FunctionOption.newBuilder().setName("ignoreNulls").build();
            windowBuilder.addOptions(option);
        }
        for (ExpressionNode expressionNode : this.expressionNodes) {
            FunctionArgument.Builder functionArgument = FunctionArgument.newBuilder();
            functionArgument.setValue(expressionNode.toProtobuf());
            windowBuilder.addArguments(functionArgument.build());
        }
        windowBuilder.setOutputType(this.outputTypeNode.toProtobuf());
        windowBuilder.setColumnName(this.columnName);
        Expression.WindowFunction.Bound.Builder lowerBoundBuilder = Expression.WindowFunction.Bound.newBuilder();
        Expression.WindowFunction.Bound.Builder upperBoundBuilder = Expression.WindowFunction.Bound.newBuilder();
        windowBuilder.setLowerBound(this.setBound(lowerBoundBuilder, this.lowerBound).build());
        windowBuilder.setUpperBound(this.setBound(upperBoundBuilder, this.upperBound).build());
        windowBuilder.setWindowType(this.getWindowType(this.frameType));
        return windowBuilder.build();
    }
}

