/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gluten.substrait.expression;

import io.substrait.proto.AggregateFunction;
import io.substrait.proto.AggregationPhase;
import io.substrait.proto.FunctionArgument;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.gluten.substrait.expression.ExpressionNode;
import org.apache.gluten.substrait.type.TypeNode;

public class AggregateFunctionNode
implements Serializable {
    private final Long functionId;
    private final List<ExpressionNode> expressionNodes = new ArrayList<ExpressionNode>();
    private final String phase;
    private final TypeNode outputTypeNode;

    AggregateFunctionNode(Long functionId, List<ExpressionNode> expressionNodes, String phase, TypeNode outputTypeNode) {
        this.functionId = functionId;
        this.expressionNodes.addAll(expressionNodes);
        this.phase = phase;
        this.outputTypeNode = outputTypeNode;
    }

    public AggregateFunction toProtobuf() {
        AggregateFunction.Builder aggBuilder = AggregateFunction.newBuilder();
        aggBuilder.setFunctionReference(this.functionId.intValue());
        if (this.phase == null) {
            aggBuilder.setPhase(AggregationPhase.AGGREGATION_PHASE_UNSPECIFIED);
        } else {
            switch (this.phase) {
                case "PARTIAL": {
                    aggBuilder.setPhase(AggregationPhase.AGGREGATION_PHASE_INITIAL_TO_INTERMEDIATE);
                    break;
                }
                case "PARTIAL_MERGE": {
                    aggBuilder.setPhase(AggregationPhase.AGGREGATION_PHASE_INTERMEDIATE_TO_INTERMEDIATE);
                    break;
                }
                case "COMPLETE": {
                    aggBuilder.setPhase(AggregationPhase.AGGREGATION_PHASE_INITIAL_TO_RESULT);
                    break;
                }
                case "FINAL": {
                    aggBuilder.setPhase(AggregationPhase.AGGREGATION_PHASE_INTERMEDIATE_TO_RESULT);
                    break;
                }
                default: {
                    aggBuilder.setPhase(AggregationPhase.AGGREGATION_PHASE_INITIAL_TO_RESULT);
                }
            }
        }
        for (ExpressionNode expressionNode : this.expressionNodes) {
            FunctionArgument.Builder functionArgument = FunctionArgument.newBuilder();
            functionArgument.setValue(expressionNode.toProtobuf());
            aggBuilder.addArguments(functionArgument.build());
        }
        aggBuilder.setOutputType(this.outputTypeNode.toProtobuf());
        return aggBuilder.build();
    }
}

