/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.metrics;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.jmx.JmxReporter;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.kylin.common.KapConfig;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.metrics.MetricsInfluxdbReporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricsController {
    private static final Logger logger = LoggerFactory.getLogger(MetricsController.class);
    private static final AtomicBoolean reporterStarted = new AtomicBoolean(false);
    private static volatile MetricRegistry defaultMetricRegistry = null;

    private MetricsController() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MetricRegistry getDefaultMetricRegistry() {
        if (defaultMetricRegistry != null) return defaultMetricRegistry;
        Class<MetricsController> clazz = MetricsController.class;
        synchronized (MetricsController.class) {
            if (defaultMetricRegistry != null) return defaultMetricRegistry;
            defaultMetricRegistry = new MetricRegistry();
            // ** MonitorExit[var0] (shouldn't be in output)
            return defaultMetricRegistry;
        }
    }

    public static void init(KapConfig verifiableProps) {
        MetricsInfluxdbReporter influxDbReporter = MetricsInfluxdbReporter.getInstance();
        influxDbReporter.init(verifiableProps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startReporters(KapConfig verifiableProps) {
        if (KylinConfig.getInstanceFromEnv().isDevOrUT()) {
            return;
        }
        AtomicBoolean atomicBoolean = reporterStarted;
        synchronized (atomicBoolean) {
            if (!reporterStarted.get()) {
                try {
                    MetricsInfluxdbReporter influxDbReporter = MetricsInfluxdbReporter.getInstance();
                    influxDbReporter.start(verifiableProps);
                    JmxReporter jmxReporter = JmxReporter.forRegistry((MetricRegistry)MetricsController.getDefaultMetricRegistry()).build();
                    jmxReporter.start();
                    reporterStarted.set(true);
                    logger.info("kylin.metrics reporters started");
                }
                catch (Exception e) {
                    logger.error("kylin.metrics reporters start failed", (Throwable)e);
                }
            }
        }
    }
}

