/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.loader.utils;

import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URL;
import java.net.URLStreamHandlerFactory;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.fs.FsUrlStreamHandlerFactory;
import org.apache.hadoop.fs.Path;
import org.apache.kylin.loader.AddToClassPathAction;
import org.apache.kylin.loader.ParserClassLoader;
import org.apache.kylin.loader.ParserClassLoaderState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ReflectionUtils;

public class ClassLoaderUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ClassLoaderUtils.class);

    private ClassLoaderUtils() {
    }

    public static boolean judgeIntersection(Set<String> set1, Collection<String> collection) {
        HashSet<String> setCopy = new HashSet<String>(set1);
        setCopy.retainAll(collection);
        return !setCopy.isEmpty();
    }

    public static URL urlFromPathString(String path) {
        URL resultUrl = null;
        try {
            if (StringUtils.indexOf((CharSequence)path, (CharSequence)"file:/") == 0) {
                resultUrl = new URL(path);
            } else if (StringUtils.indexOf((CharSequence)path, (CharSequence)"hdfs:/") == 0) {
                ClassLoaderUtils.registerFactory(new FsUrlStreamHandlerFactory());
                resultUrl = new Path(path).toUri().toURL();
            }
        }
        catch (Exception e) {
            log.error("Bad URL {}, ignoring path", (Object)path, (Object)e);
            throw new IllegalArgumentException("Bad URL [" + path + "], ignoring path");
        }
        if (resultUrl == null) {
            throw new IllegalArgumentException("URL [" + path + "] not supported, currently only hdfs and file is supported");
        }
        return resultUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void registerFactory(FsUrlStreamHandlerFactory fsUrlStreamHandlerFactory) {
        log.info("registerFactory : {}", (Object)fsUrlStreamHandlerFactory.getClass().getName());
        Field factoryField = ReflectionUtils.findField(URL.class, (String)"factory");
        ReflectionUtils.makeAccessible((Field)Objects.requireNonNull(factoryField));
        Field lockField = ReflectionUtils.findField(URL.class, (String)"streamHandlerLock");
        ReflectionUtils.makeAccessible((Field)Objects.requireNonNull(lockField));
        Object object = lockField.get(null);
        synchronized (object) {
            URLStreamHandlerFactory originalUrlStreamHandlerFactory = (URLStreamHandlerFactory)factoryField.get(null);
            ReflectionUtils.setField((Field)factoryField, null, null);
            URL.setURLStreamHandlerFactory(protocol -> {
                if ("hdfs".equals(protocol)) {
                    return fsUrlStreamHandlerFactory.createURLStreamHandler(protocol);
                }
                return originalUrlStreamHandlerFactory.createURLStreamHandler(protocol);
            });
        }
    }

    public static void closeClassLoader(ClassLoader loader) throws IOException {
        if (loader instanceof Closeable) {
            ((Closeable)((Object)loader)).close();
            return;
        }
        log.warn("Ignoring attempt to close class loader ({}) -- not instance of ParserClassLoader.", (Object)(loader == null ? "mull" : loader.getClass().getSimpleName()));
    }

    public static void removeFromClassPath(String project, String[] pathsToRemove, ClassLoader classLoader) throws IOException {
        if (!(classLoader instanceof ParserClassLoader)) {
            log.warn("Ignoring attempt to manipulate {}; probably means we have closed more Parser loaders than opened.", (Object)(classLoader == null ? "null" : classLoader.getClass().getSimpleName()));
            return;
        }
        ParserClassLoader loader = (ParserClassLoader)classLoader;
        ArrayList<URL> newPaths = new ArrayList<URL>(Arrays.asList(loader.getURLs()));
        Arrays.stream(pathsToRemove).forEach(path -> newPaths.remove(ClassLoaderUtils.urlFromPathString(path)));
        ClassLoaderUtils.closeClassLoader(loader);
        AddToClassPathAction action = new AddToClassPathAction(Thread.currentThread().getContextClassLoader(), newPaths.stream().map(URL::toString).collect(Collectors.toSet()));
        ParserClassLoader parserClassLoader = AccessController.doPrivileged(action);
        ParserClassLoaderState.getInstance(project).setClassLoader(parserClassLoader);
    }
}

