/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.util;

import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutorServiceUtil {
    private static final Logger logger = LoggerFactory.getLogger(ExecutorServiceUtil.class);

    public static void shutdownGracefully(ExecutorService threadPool, int timeoutSeconds) {
        threadPool.shutdown();
        try {
            if (!threadPool.awaitTermination(timeoutSeconds, TimeUnit.SECONDS)) {
                ExecutorServiceUtil.forceShutdown(threadPool);
            }
        }
        catch (InterruptedException ex) {
            logger.info("Interrupted while shutting down");
            ExecutorServiceUtil.forceShutdown(threadPool);
            Thread.currentThread().interrupt();
        }
    }

    public static void forceShutdown(ExecutorService threadPool) {
        if (threadPool != null) {
            List<Runnable> jobs = threadPool.shutdownNow();
            logger.info("Shutdown now thread pool [{}], drain [{}] runnable jobs.", (Object)System.identityHashCode(threadPool), (Object)jobs.size());
            int futureTaskCount = 0;
            for (Runnable job : jobs) {
                if (!(job instanceof Future)) continue;
                ++futureTaskCount;
                Future task = (Future)((Object)job);
                logger.info("Cancel future task [{}].", (Object)System.identityHashCode(task));
                task.cancel(true);
            }
            logger.info("Thread poll cancel [{}] future jobs.", (Object)futureTaskCount);
        }
    }
}

