/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.util;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.kylin.guava30.shaded.common.collect.Sets;

public class CollectionUtil {
    public static <T> T findElement(Collection<T> collection, Predicate<T> predicate) {
        if (collection != null && predicate != null) {
            for (T item : collection) {
                if (!predicate.test(item)) continue;
                return item;
            }
        }
        return null;
    }

    public static <T> Optional<T> find(Collection<T> collection, Predicate<T> predicate) {
        if (collection != null && predicate != null) {
            for (T item : collection) {
                if (!predicate.test(item)) continue;
                return Optional.of(item);
            }
        }
        return Optional.empty();
    }

    public static <T, V> void distinct(Collection<T> collection, Function<T, V> distinctBy) {
        HashSet values = new HashSet();
        collection.removeIf(el -> !values.add(distinctBy.apply(el)));
    }

    public static List<Integer> intersection(List<Integer> list1, List<Integer> list2) {
        return Sets.intersection((Set)Sets.newHashSet(list1), (Set)Sets.newHashSet(list2)).stream().sorted().collect(Collectors.toList());
    }

    public static List<Integer> difference(List<Integer> list1, List<Integer> list2) {
        return Sets.difference((Set)Sets.newHashSet(list1), (Set)Sets.newHashSet(list2)).stream().sorted().collect(Collectors.toList());
    }
}

