/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.util;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.NoSuchElementException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import sun.misc.Unsafe;

public class Bytes {
    private static final String UTF8_ENCODING = "UTF-8";
    private static final Charset UTF8_CHARSET = StandardCharsets.UTF_8;
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private static final Log LOG = LogFactory.getLog(Bytes.class);
    public static final int SIZEOF_BOOLEAN = 1;
    public static final int SIZEOF_BYTE = 1;
    public static final int SIZEOF_CHAR = 2;
    public static final int SIZEOF_DOUBLE = 8;
    public static final int SIZEOF_FLOAT = 4;
    public static final int SIZEOF_INT = 4;
    public static final int SIZEOF_LONG = 8;
    public static final int SIZEOF_SHORT = 2;
    public static final int ESTIMATED_HEAP_TAX = 16;
    private static final SecureRandom RNG = new SecureRandom();

    public static int len(byte[] b) {
        return b == null ? 0 : b.length;
    }

    public static int putBytes(byte[] tgtBytes, int tgtOffset, byte[] srcBytes, int srcOffset, int srcLength) {
        System.arraycopy(srcBytes, srcOffset, tgtBytes, tgtOffset, srcLength);
        return tgtOffset + srcLength;
    }

    public static int putByte(byte[] bytes, int offset, byte b) {
        bytes[offset] = b;
        return offset + 1;
    }

    public static int putByteBuffer(byte[] bytes, int offset, ByteBuffer buf) {
        int len = buf.remaining();
        buf.get(bytes, offset, len);
        return offset + len;
    }

    public static byte[] toBytes(ByteBuffer buf) {
        ByteBuffer dup = buf.duplicate();
        dup.position(0);
        return Bytes.readBytes(dup);
    }

    private static byte[] readBytes(ByteBuffer buf) {
        byte[] result = new byte[buf.remaining()];
        buf.get(result);
        return result;
    }

    public static String toString(byte[] b) {
        if (b == null) {
            return null;
        }
        return Bytes.toString(b, 0, b.length);
    }

    public static String toString(byte[] b1, String sep, byte[] b2) {
        return Bytes.toString(b1, 0, b1.length) + sep + Bytes.toString(b2, 0, b2.length);
    }

    public static String toString(byte[] b, int off, int len) {
        if (b == null) {
            return null;
        }
        if (len == 0) {
            return "";
        }
        return new String(b, off, len, UTF8_CHARSET);
    }

    public static String toStringBinary(byte[] b) {
        if (b == null) {
            return "null";
        }
        return Bytes.toStringBinary(b, 0, b.length);
    }

    public static String toStringBinary(ByteBuffer buf) {
        if (buf == null) {
            return "null";
        }
        if (buf.hasArray()) {
            return Bytes.toStringBinary(buf.array(), buf.arrayOffset(), buf.limit());
        }
        return Bytes.toStringBinary(Bytes.toBytes(buf));
    }

    public static String toStringBinary(byte[] b, int off, int len) {
        StringBuilder result = new StringBuilder();
        if (off >= b.length) {
            return result.toString();
        }
        if (off + len > b.length) {
            len = b.length - off;
        }
        for (int i = off; i < off + len; ++i) {
            int ch = b[i] & 0xFF;
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 90 || ch >= 97 && ch <= 122 || " `~!@#$%^&*()-_=+[]{}|;:'\",.<>/?".indexOf(ch) >= 0) {
                result.append((char)ch);
                continue;
            }
            result.append(String.format(Locale.ROOT, "\\x%02X", ch));
        }
        return result.toString();
    }

    private static boolean isHexDigit(char c) {
        return c >= 'A' && c <= 'F' || c >= '0' && c <= '9';
    }

    public static byte toBinaryFromHex(byte ch) {
        if (ch >= 65 && ch <= 70) {
            return (byte)(10 + (byte)(ch - 65));
        }
        return (byte)(ch - 48);
    }

    public static byte[] toBytesBinary(String in) {
        byte[] b = new byte[in.length()];
        int size = 0;
        for (int i = 0; i < in.length(); ++i) {
            char ch = in.charAt(i);
            if (ch == '\\' && in.length() > i + 1 && in.charAt(i + 1) == 'x') {
                char hd1 = in.charAt(i + 2);
                char hd2 = in.charAt(i + 3);
                if (!Bytes.isHexDigit(hd1) || !Bytes.isHexDigit(hd2)) continue;
                byte d = (byte)((Bytes.toBinaryFromHex((byte)hd1) << 4) + (Bytes.toBinaryFromHex((byte)hd2) & 0xFF) & 0xFF);
                b[size++] = d;
                i += 3;
                continue;
            }
            b[size++] = (byte)ch;
        }
        byte[] b2 = new byte[size];
        System.arraycopy(b, 0, b2, 0, size);
        return b2;
    }

    public static byte[] toBytes(String s) {
        return s.getBytes(UTF8_CHARSET);
    }

    public static byte[] toBytes(boolean b) {
        return new byte[]{b ? (byte)-1 : 0};
    }

    public static boolean toBoolean(byte[] b) {
        if (b.length != 1) {
            throw new IllegalArgumentException("Array has wrong size: " + b.length);
        }
        return b[0] != 0;
    }

    public static byte[] toBytes(long val) {
        byte[] b = new byte[8];
        for (int i = 7; i > 0; --i) {
            b[i] = (byte)val;
            val >>>= 8;
        }
        b[0] = (byte)val;
        return b;
    }

    public static long toLong(byte[] bytes) {
        return Bytes.toLong(bytes, 0, 8);
    }

    public static long toLong(byte[] bytes, int offset) {
        return Bytes.toLong(bytes, offset, 8);
    }

    public static long toLong(byte[] bytes, int offset, int length) {
        if (length != 8 || offset + length > bytes.length) {
            throw Bytes.explainWrongLengthOrOffset(bytes, offset, length, 8);
        }
        if (LexicographicalComparerHolder.UnsafeComparer.isAvailable()) {
            return Bytes.toLongUnsafe(bytes, offset);
        }
        long l = 0L;
        for (int i = offset; i < offset + length; ++i) {
            l <<= 8;
            l ^= (long)(bytes[i] & 0xFF);
        }
        return l;
    }

    private static IllegalArgumentException explainWrongLengthOrOffset(byte[] bytes, int offset, int length, int expectedLength) {
        String reason = length != expectedLength ? "Wrong length: " + length + ", expected " + expectedLength : "offset (" + offset + ") + length (" + length + ") exceed the capacity of the array: " + bytes.length;
        return new IllegalArgumentException(reason);
    }

    public static int putLong(byte[] bytes, int offset, long val) {
        if (bytes.length - offset < 8) {
            throw new IllegalArgumentException("Not enough room to put a long at offset " + offset + " in a " + bytes.length + " byte array");
        }
        if (LexicographicalComparerHolder.UnsafeComparer.isAvailable()) {
            return Bytes.putLongUnsafe(bytes, offset, val);
        }
        for (int i = offset + 7; i > offset; --i) {
            bytes[i] = (byte)val;
            val >>>= 8;
        }
        bytes[offset] = (byte)val;
        return offset + 8;
    }

    public static int putLongUnsafe(byte[] bytes, int offset, long val) {
        if (LexicographicalComparerHolder.UnsafeComparer.littleEndian) {
            val = Long.reverseBytes(val);
        }
        LexicographicalComparerHolder.UnsafeComparer.theUnsafe.putLong(bytes, (long)offset + (long)LexicographicalComparerHolder.UnsafeComparer.BYTE_ARRAY_BASE_OFFSET, val);
        return offset + 8;
    }

    public static float toFloat(byte[] bytes) {
        return Bytes.toFloat(bytes, 0);
    }

    public static float toFloat(byte[] bytes, int offset) {
        return Float.intBitsToFloat(Bytes.toInt(bytes, offset, 4));
    }

    public static int putFloat(byte[] bytes, int offset, float f) {
        return Bytes.putInt(bytes, offset, Float.floatToRawIntBits(f));
    }

    public static byte[] toBytes(float f) {
        return Bytes.toBytes(Float.floatToRawIntBits(f));
    }

    public static double toDouble(byte[] bytes) {
        return Bytes.toDouble(bytes, 0);
    }

    public static double toDouble(byte[] bytes, int offset) {
        return Double.longBitsToDouble(Bytes.toLong(bytes, offset, 8));
    }

    public static int putDouble(byte[] bytes, int offset, double d) {
        return Bytes.putLong(bytes, offset, Double.doubleToLongBits(d));
    }

    public static byte[] toBytes(double d) {
        return Bytes.toBytes(Double.doubleToRawLongBits(d));
    }

    public static byte[] toBytes(int val) {
        byte[] b = new byte[4];
        for (int i = 3; i > 0; --i) {
            b[i] = (byte)val;
            val >>>= 8;
        }
        b[0] = (byte)val;
        return b;
    }

    public static int toInt(byte[] bytes) {
        return Bytes.toInt(bytes, 0, 4);
    }

    public static int toInt(byte[] bytes, int offset) {
        return Bytes.toInt(bytes, offset, 4);
    }

    public static int toInt(byte[] bytes, int offset, int length) {
        if (length != 4 || offset + length > bytes.length) {
            throw Bytes.explainWrongLengthOrOffset(bytes, offset, length, 4);
        }
        if (LexicographicalComparerHolder.UnsafeComparer.isAvailable()) {
            return Bytes.toIntUnsafe(bytes, offset);
        }
        int n = 0;
        for (int i = offset; i < offset + length; ++i) {
            n <<= 8;
            n ^= bytes[i] & 0xFF;
        }
        return n;
    }

    public static int toIntUnsafe(byte[] bytes, int offset) {
        if (LexicographicalComparerHolder.UnsafeComparer.littleEndian) {
            return Integer.reverseBytes(LexicographicalComparerHolder.UnsafeComparer.theUnsafe.getInt(bytes, (long)offset + (long)LexicographicalComparerHolder.UnsafeComparer.BYTE_ARRAY_BASE_OFFSET));
        }
        return LexicographicalComparerHolder.UnsafeComparer.theUnsafe.getInt(bytes, (long)offset + (long)LexicographicalComparerHolder.UnsafeComparer.BYTE_ARRAY_BASE_OFFSET);
    }

    public static short toShortUnsafe(byte[] bytes, int offset) {
        if (LexicographicalComparerHolder.UnsafeComparer.littleEndian) {
            return Short.reverseBytes(LexicographicalComparerHolder.UnsafeComparer.theUnsafe.getShort(bytes, (long)offset + (long)LexicographicalComparerHolder.UnsafeComparer.BYTE_ARRAY_BASE_OFFSET));
        }
        return LexicographicalComparerHolder.UnsafeComparer.theUnsafe.getShort(bytes, (long)offset + (long)LexicographicalComparerHolder.UnsafeComparer.BYTE_ARRAY_BASE_OFFSET);
    }

    public static long toLongUnsafe(byte[] bytes, int offset) {
        if (LexicographicalComparerHolder.UnsafeComparer.littleEndian) {
            return Long.reverseBytes(LexicographicalComparerHolder.UnsafeComparer.theUnsafe.getLong(bytes, (long)offset + (long)LexicographicalComparerHolder.UnsafeComparer.BYTE_ARRAY_BASE_OFFSET));
        }
        return LexicographicalComparerHolder.UnsafeComparer.theUnsafe.getLong(bytes, (long)offset + (long)LexicographicalComparerHolder.UnsafeComparer.BYTE_ARRAY_BASE_OFFSET);
    }

    public static int readAsInt(byte[] bytes, int offset, int length) {
        if (offset + length > bytes.length) {
            throw new IllegalArgumentException("offset (" + offset + ") + length (" + length + ") exceed the capacity of the array: " + bytes.length);
        }
        int n = 0;
        for (int i = offset; i < offset + length; ++i) {
            n <<= 8;
            n ^= bytes[i] & 0xFF;
        }
        return n;
    }

    public static int putInt(byte[] bytes, int offset, int val) {
        if (bytes.length - offset < 4) {
            throw new IllegalArgumentException("Not enough room to put an int at offset " + offset + " in a " + bytes.length + " byte array");
        }
        if (LexicographicalComparerHolder.UnsafeComparer.isAvailable()) {
            return Bytes.putIntUnsafe(bytes, offset, val);
        }
        for (int i = offset + 3; i > offset; --i) {
            bytes[i] = (byte)val;
            val >>>= 8;
        }
        bytes[offset] = (byte)val;
        return offset + 4;
    }

    public static int putIntUnsafe(byte[] bytes, int offset, int val) {
        if (LexicographicalComparerHolder.UnsafeComparer.littleEndian) {
            val = Integer.reverseBytes(val);
        }
        LexicographicalComparerHolder.UnsafeComparer.theUnsafe.putInt(bytes, (long)offset + (long)LexicographicalComparerHolder.UnsafeComparer.BYTE_ARRAY_BASE_OFFSET, val);
        return offset + 4;
    }

    public static byte[] toBytes(short val) {
        byte[] b = new byte[2];
        b[1] = (byte)val;
        val = (short)(val >> 8);
        b[0] = (byte)val;
        return b;
    }

    public static short toShort(byte[] bytes) {
        return Bytes.toShort(bytes, 0, 2);
    }

    public static short toShort(byte[] bytes, int offset) {
        return Bytes.toShort(bytes, offset, 2);
    }

    public static short toShort(byte[] bytes, int offset, int length) {
        if (length != 2 || offset + length > bytes.length) {
            throw Bytes.explainWrongLengthOrOffset(bytes, offset, length, 2);
        }
        if (LexicographicalComparerHolder.UnsafeComparer.isAvailable()) {
            return Bytes.toShortUnsafe(bytes, offset);
        }
        short n = 0;
        n = (short)(n ^ bytes[offset] & 0xFF);
        n = (short)(n << 8);
        n = (short)(n ^ bytes[offset + 1] & 0xFF);
        return n;
    }

    public static byte[] getBytes(ByteBuffer buf) {
        return Bytes.readBytes(buf.duplicate());
    }

    public static int putShort(byte[] bytes, int offset, short val) {
        if (bytes.length - offset < 2) {
            throw new IllegalArgumentException("Not enough room to put a short at offset " + offset + " in a " + bytes.length + " byte array");
        }
        if (LexicographicalComparerHolder.UnsafeComparer.isAvailable()) {
            return Bytes.putShortUnsafe(bytes, offset, val);
        }
        bytes[offset + 1] = (byte)val;
        val = (short)(val >> 8);
        bytes[offset] = (byte)val;
        return offset + 2;
    }

    public static int putShortUnsafe(byte[] bytes, int offset, short val) {
        if (LexicographicalComparerHolder.UnsafeComparer.littleEndian) {
            val = Short.reverseBytes(val);
        }
        LexicographicalComparerHolder.UnsafeComparer.theUnsafe.putShort(bytes, (long)offset + (long)LexicographicalComparerHolder.UnsafeComparer.BYTE_ARRAY_BASE_OFFSET, val);
        return offset + 2;
    }

    public static int putAsShort(byte[] bytes, int offset, int val) {
        if (bytes.length - offset < 2) {
            throw new IllegalArgumentException("Not enough room to put a short at offset " + offset + " in a " + bytes.length + " byte array");
        }
        bytes[offset + 1] = (byte)val;
        bytes[offset] = (byte)(val >>= 8);
        return offset + 2;
    }

    public static byte[] toBytes(BigDecimal val) {
        byte[] valueBytes = val.unscaledValue().toByteArray();
        byte[] result = new byte[valueBytes.length + 4];
        int offset = Bytes.putInt(result, 0, val.scale());
        Bytes.putBytes(result, offset, valueBytes, 0, valueBytes.length);
        return result;
    }

    public static BigDecimal toBigDecimal(byte[] bytes) {
        return Bytes.toBigDecimal(bytes, 0, bytes.length);
    }

    public static BigDecimal toBigDecimal(byte[] bytes, int offset, int length) {
        if (bytes == null || length < 5 || offset + length > bytes.length) {
            return null;
        }
        int scale = Bytes.toInt(bytes, offset);
        byte[] tcBytes = new byte[length - 4];
        System.arraycopy(bytes, offset + 4, tcBytes, 0, length - 4);
        return new BigDecimal(new BigInteger(tcBytes), scale);
    }

    public static int putBigDecimal(byte[] bytes, int offset, BigDecimal val) {
        if (bytes == null) {
            return offset;
        }
        byte[] valueBytes = val.unscaledValue().toByteArray();
        byte[] result = new byte[valueBytes.length + 4];
        offset = Bytes.putInt(result, offset, val.scale());
        return Bytes.putBytes(result, offset, valueBytes, 0, valueBytes.length);
    }

    public static int compareTo(byte[] left, byte[] right) {
        return LexicographicalComparerHolder.BEST_COMPARER.compareTo(left, 0, left.length, right, 0, right.length);
    }

    public static int compareTo(byte[] buffer1, int offset1, int length1, byte[] buffer2, int offset2, int length2) {
        return LexicographicalComparerHolder.BEST_COMPARER.compareTo(buffer1, offset1, length1, buffer2, offset2, length2);
    }

    static Comparer<byte[]> lexicographicalComparerJavaImpl() {
        return LexicographicalComparerHolder.PureJavaComparer.INSTANCE;
    }

    public static boolean equals(byte[] left, byte[] right) {
        if (left == right) {
            return true;
        }
        if (left == null || right == null) {
            return false;
        }
        if (left.length != right.length) {
            return false;
        }
        if (left.length == 0) {
            return true;
        }
        if (left[left.length - 1] != right[right.length - 1]) {
            return false;
        }
        return Bytes.compareTo(left, right) == 0;
    }

    public static boolean equals(byte[] left, int leftOffset, int leftLen, byte[] right, int rightOffset, int rightLen) {
        if (left == right && leftOffset == rightOffset && leftLen == rightLen) {
            return true;
        }
        if (leftLen != rightLen) {
            return false;
        }
        if (leftLen == 0) {
            return true;
        }
        if (left[leftOffset + leftLen - 1] != right[rightOffset + rightLen - 1]) {
            return false;
        }
        return LexicographicalComparerHolder.BEST_COMPARER.compareTo(left, leftOffset, leftLen, right, rightOffset, rightLen) == 0;
    }

    public static boolean equals(byte[] a, ByteBuffer buf) {
        if (a == null) {
            return buf == null;
        }
        if (buf == null) {
            return false;
        }
        if (a.length != buf.remaining()) {
            return false;
        }
        ByteBuffer b = buf.duplicate();
        for (byte anA : a) {
            if (anA == b.get()) continue;
            return false;
        }
        return true;
    }

    public static boolean startsWith(byte[] bytes, byte[] prefix) {
        return bytes != null && prefix != null && bytes.length >= prefix.length && LexicographicalComparerHolder.BEST_COMPARER.compareTo(bytes, 0, prefix.length, prefix, 0, prefix.length) == 0;
    }

    public static int hashCode(byte[] b) {
        return Bytes.hashCode(b, b.length);
    }

    public static int hashCode(byte[] b, int length) {
        return Bytes.hashBytes(b, 0, length);
    }

    public static int hashBytes(byte[] bytes, int offset, int length) {
        int hash = 1;
        for (int i = offset; i < offset + length; ++i) {
            hash = 31 * hash + bytes[i];
        }
        return hash;
    }

    public static Integer mapKey(byte[] b) {
        return Bytes.hashCode(b);
    }

    public static Integer mapKey(byte[] b, int length) {
        return Bytes.hashCode(b, length);
    }

    public static byte[] add(byte[] a, byte[] b) {
        return Bytes.add(a, b, EMPTY_BYTE_ARRAY);
    }

    public static byte[] add(byte[] a, byte[] b, byte[] c) {
        byte[] result = new byte[a.length + b.length + c.length];
        System.arraycopy(a, 0, result, 0, a.length);
        System.arraycopy(b, 0, result, a.length, b.length);
        System.arraycopy(c, 0, result, a.length + b.length, c.length);
        return result;
    }

    public static byte[] head(byte[] a, int length) {
        if (a.length < length) {
            return null;
        }
        byte[] result = new byte[length];
        System.arraycopy(a, 0, result, 0, length);
        return result;
    }

    public static byte[] tail(byte[] a, int length) {
        if (a.length < length) {
            return null;
        }
        byte[] result = new byte[length];
        System.arraycopy(a, a.length - length, result, 0, length);
        return result;
    }

    public static byte[] padHead(byte[] a, int length) {
        byte[] padding = new byte[length];
        for (int i = 0; i < length; ++i) {
            padding[i] = 0;
        }
        return Bytes.add(padding, a);
    }

    public static byte[] padTail(byte[] a, int length) {
        byte[] padding = new byte[length];
        for (int i = 0; i < length; ++i) {
            padding[i] = 0;
        }
        return Bytes.add(a, padding);
    }

    public static byte[][] split(byte[] a, byte[] b, int num) {
        return Bytes.split(a, b, false, num);
    }

    public static byte[][] split(byte[] a, byte[] b, boolean inclusive, int num) {
        byte[][] ret = new byte[num + 2][];
        int i = 0;
        Iterable<byte[]> iter = Bytes.iterateOnSplits(a, b, inclusive, num);
        if (iter == null) {
            return null;
        }
        for (byte[] elem : iter) {
            ret[i++] = elem;
        }
        return ret;
    }

    public static Iterable<byte[]> iterateOnSplits(byte[] a, byte[] b, int num) {
        return Bytes.iterateOnSplits(a, b, false, num);
    }

    public static Iterable<byte[]> iterateOnSplits(final byte[] a, final byte[] b, boolean inclusive, final int num) {
        BigInteger intervalBI;
        BigInteger splitsBI;
        byte[] bPadded;
        byte[] aPadded;
        if (a.length < b.length) {
            aPadded = Bytes.padTail(a, b.length - a.length);
            bPadded = b;
        } else if (b.length < a.length) {
            aPadded = a;
            bPadded = Bytes.padTail(b, a.length - b.length);
        } else {
            aPadded = a;
            bPadded = b;
        }
        if (Bytes.compareTo(aPadded, bPadded) >= 0) {
            throw new IllegalArgumentException("b <= a");
        }
        if (num <= 0) {
            throw new IllegalArgumentException("num cannot be <= 0");
        }
        byte[] prependHeader = new byte[]{1, 0};
        final BigInteger startBI = new BigInteger(Bytes.add(prependHeader, aPadded));
        BigInteger stopBI = new BigInteger(Bytes.add(prependHeader, bPadded));
        BigInteger diffBI = stopBI.subtract(startBI);
        if (inclusive) {
            diffBI = diffBI.add(BigInteger.ONE);
        }
        if (diffBI.compareTo(splitsBI = BigInteger.valueOf((long)num + 1L)) < 0) {
            return null;
        }
        try {
            intervalBI = diffBI.divide(splitsBI);
        }
        catch (Exception e) {
            LOG.error((Object)"Exception caught during division", (Throwable)e);
            return null;
        }
        final Iterator<byte[]> iterator = new Iterator<byte[]>(){
            private int i = -1;

            @Override
            public boolean hasNext() {
                return this.i < num + 1;
            }

            @Override
            public byte[] next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                ++this.i;
                if (this.i == 0) {
                    return a;
                }
                if (this.i == num + 1) {
                    return b;
                }
                BigInteger curBI = startBI.add(intervalBI.multiply(BigInteger.valueOf(this.i)));
                byte[] padded = curBI.toByteArray();
                padded = padded[1] == 0 ? Bytes.tail(padded, padded.length - 2) : Bytes.tail(padded, padded.length - 1);
                return padded;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
        return new Iterable<byte[]>(){

            @Override
            public Iterator<byte[]> iterator() {
                return iterator;
            }
        };
    }

    public static int hashCode(byte[] bytes, int offset, int length) {
        int hash = 1;
        for (int i = offset; i < offset + length; ++i) {
            hash = 31 * hash + bytes[i];
        }
        return hash;
    }

    public static byte[][] toByteArrays(String[] t) {
        byte[][] result = new byte[t.length][];
        for (int i = 0; i < t.length; ++i) {
            result[i] = Bytes.toBytes(t[i]);
        }
        return result;
    }

    public static byte[][] toByteArrays(String column) {
        return Bytes.toByteArrays(Bytes.toBytes(column));
    }

    public static byte[][] toByteArrays(byte[] column) {
        byte[][] result = new byte[][]{column};
        return result;
    }

    public static byte[] incrementBytes(byte[] value, long amount) {
        byte[] val = value;
        if (val.length < 8) {
            byte[] newvalue = val[0] < 0 ? new byte[]{-1, -1, -1, -1, -1, -1, -1, -1} : new byte[8];
            System.arraycopy(val, 0, newvalue, newvalue.length - val.length, val.length);
            val = newvalue;
        } else if (val.length > 8) {
            throw new IllegalArgumentException("Increment Bytes - value too big: " + val.length);
        }
        if (amount == 0L) {
            return val;
        }
        if (val[0] < 0) {
            return Bytes.binaryIncrementNeg(val, amount);
        }
        return Bytes.binaryIncrementPos(val, amount);
    }

    private static byte[] binaryIncrementPos(byte[] value, long amount) {
        long amo = amount;
        int sign = 1;
        if (amount < 0L) {
            amo = -amount;
            sign = -1;
        }
        for (int i = 0; i < value.length; ++i) {
            int cur = (int)amo % 256 * sign;
            amo >>= 8;
            int val = value[value.length - i - 1] & 0xFF;
            int total = val + cur;
            if (total > 255) {
                amo += (long)sign;
                total %= 256;
            } else if (total < 0) {
                amo -= (long)sign;
            }
            value[value.length - i - 1] = (byte)total;
            if (amo != 0L) continue;
            return value;
        }
        return value;
    }

    private static byte[] binaryIncrementNeg(byte[] value, long amount) {
        long amo = amount;
        int sign = 1;
        if (amount < 0L) {
            amo = -amount;
            sign = -1;
        }
        for (int i = 0; i < value.length; ++i) {
            int cur = (int)amo % 256 * sign;
            amo >>= 8;
            int val = (~value[value.length - i - 1] & 0xFF) + 1;
            int total = cur - val;
            if (total >= 0) {
                amo += (long)sign;
            } else if (total < -256) {
                amo -= (long)sign;
                total %= 256;
            }
            value[value.length - i - 1] = (byte)total;
            if (amo != 0L) continue;
            return value;
        }
        return value;
    }

    public static void writeStringFixedSize(DataOutput out, String s, int size) throws IOException {
        byte[] b = Bytes.toBytes(s);
        if (b.length > size) {
            throw new IOException("Trying to write " + b.length + " bytes (" + Bytes.toStringBinary(b) + ") into a field of length " + size);
        }
        out.writeBytes(s);
        for (int i = 0; i < size - s.length(); ++i) {
            out.writeByte(0);
        }
    }

    public static String readStringFixedSize(DataInput in, int size) throws IOException {
        int n;
        byte[] b = new byte[size];
        in.readFully(b);
        for (n = b.length; n > 0 && b[n - 1] == 0; --n) {
        }
        return Bytes.toString(b, 0, n);
    }

    public static byte[] copy(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        byte[] result = new byte[bytes.length];
        System.arraycopy(bytes, 0, result, 0, bytes.length);
        return result;
    }

    public static byte[] copy(byte[] bytes, int offset, int length) {
        if (bytes == null) {
            return null;
        }
        byte[] result = new byte[length];
        System.arraycopy(bytes, offset, result, 0, length);
        return result;
    }

    public static int unsignedBinarySearch(byte[] a, int fromIndex, int toIndex, byte key) {
        int unsignedKey = key & 0xFF;
        int low = fromIndex;
        int high = toIndex - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            int midVal = a[mid] & 0xFF;
            if (midVal < unsignedKey) {
                low = mid + 1;
                continue;
            }
            if (midVal > unsignedKey) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public static byte[] unsignedCopyAndIncrement(byte[] input) {
        byte[] copy = Bytes.copy(input);
        if (copy == null) {
            throw new IllegalArgumentException("cannot increment null array");
        }
        for (int i = copy.length - 1; i >= 0; --i) {
            if (copy[i] != -1) {
                int n = i;
                copy[n] = (byte)(copy[n] + 1);
                return copy;
            }
            copy[i] = 0;
        }
        byte[] out = new byte[copy.length + 1];
        out[0] = 1;
        System.arraycopy(copy, 0, out, 1, copy.length);
        return out;
    }

    public static boolean equals(List<byte[]> a, List<byte[]> b) {
        if (a == null) {
            return b == null;
        }
        if (b == null) {
            return false;
        }
        if (a.size() != b.size()) {
            return false;
        }
        for (int i = 0; i < a.size(); ++i) {
            if (Bytes.equals(a.get(i), b.get(i))) continue;
            return false;
        }
        return true;
    }

    public static int indexOf(byte[] array, byte target) {
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != target) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(byte[] array, byte[] target) {
        Preconditions.checkNotNull((Object)array, (Object)"array");
        Preconditions.checkNotNull((Object)target, (Object)"target");
        if (target.length == 0) {
            return 0;
        }
        block0: for (int i = 0; i < array.length - target.length + 1; ++i) {
            for (int j = 0; j < target.length; ++j) {
                if (array[i + j] != target[j]) continue block0;
            }
            return i;
        }
        return -1;
    }

    public static boolean contains(byte[] array, byte target) {
        return Bytes.indexOf(array, target) > -1;
    }

    public static boolean contains(byte[] array, byte[] target) {
        return Bytes.indexOf(array, target) > -1;
    }

    public static void zero(byte[] b) {
        Bytes.zero(b, 0, b.length);
    }

    public static void zero(byte[] b, int offset, int length) {
        Preconditions.checkPositionIndex((int)offset, (int)b.length, (String)"offset");
        Preconditions.checkArgument((length > 0 ? 1 : 0) != 0, (Object)"length must be greater than 0");
        Preconditions.checkPositionIndex((int)(offset + length), (int)b.length, (String)"offset + length");
        Arrays.fill(b, offset, offset + length, (byte)0);
    }

    public static void random(byte[] b) {
        RNG.nextBytes(b);
    }

    public static void random(byte[] b, int offset, int length) {
        Preconditions.checkPositionIndex((int)offset, (int)b.length, (String)"offset");
        Preconditions.checkArgument((length > 0 ? 1 : 0) != 0, (Object)"length must be greater than 0");
        Preconditions.checkPositionIndex((int)(offset + length), (int)b.length, (String)"offset + length");
        byte[] buf = new byte[length];
        RNG.nextBytes(buf);
        System.arraycopy(buf, 0, b, offset, length);
    }

    public static byte[] createMaxByteArray(int maxByteCount) {
        byte[] maxByteArray = new byte[maxByteCount];
        for (int i = 0; i < maxByteArray.length; ++i) {
            maxByteArray[i] = -1;
        }
        return maxByteArray;
    }

    public static byte[] multiple(byte[] srcBytes, int multiNum) {
        if (multiNum <= 0) {
            return new byte[0];
        }
        byte[] result = new byte[srcBytes.length * multiNum];
        for (int i = 0; i < multiNum; ++i) {
            System.arraycopy(srcBytes, 0, result, i * srcBytes.length, srcBytes.length);
        }
        return result;
    }

    public static String toHex(byte[] b) {
        Preconditions.checkArgument((b.length > 0 ? 1 : 0) != 0, (Object)"length must be greater than 0");
        return String.format(Locale.ROOT, "%x", new BigInteger(1, b));
    }

    public static byte[] fromHex(String hex) {
        Preconditions.checkArgument((hex.length() > 0 ? 1 : 0) != 0, (Object)"length must be greater than 0");
        Preconditions.checkArgument((hex.length() % 2 == 0 ? 1 : 0) != 0, (Object)"length must be a multiple of 2");
        hex = hex.toUpperCase(Locale.ROOT);
        byte[] b = new byte[hex.length() / 2];
        for (int i = 0; i < b.length; ++i) {
            b[i] = (byte)((Bytes.toBinaryFromHex((byte)hex.charAt(2 * i)) << 4) + (Bytes.toBinaryFromHex((byte)hex.charAt(2 * i + 1)) & 0xFF));
        }
        return b;
    }

    static class LexicographicalComparerHolder {
        static final String UNSAFE_COMPARER_NAME = LexicographicalComparerHolder.class.getName() + "$UnsafeComparer";
        static final Comparer<byte[]> BEST_COMPARER = LexicographicalComparerHolder.getBestComparer();

        LexicographicalComparerHolder() {
        }

        static Comparer<byte[]> getBestComparer() {
            try {
                Class<?> theClass = Class.forName(UNSAFE_COMPARER_NAME);
                Comparer comparer = (Comparer)theClass.getEnumConstants()[0];
                return comparer;
            }
            catch (Throwable t) {
                return Bytes.lexicographicalComparerJavaImpl();
            }
        }

        static enum UnsafeComparer implements Comparer<byte[]>
        {
            INSTANCE;

            static final Unsafe theUnsafe;
            static final int BYTE_ARRAY_BASE_OFFSET;
            static final boolean littleEndian;

            static boolean lessThanUnsignedLong(long x1, long x2) {
                return x1 + Long.MIN_VALUE < x2 + Long.MIN_VALUE;
            }

            static boolean lessThanUnsignedInt(int x1, int x2) {
                return ((long)x1 & 0xFFFFFFFFL) < ((long)x2 & 0xFFFFFFFFL);
            }

            static boolean lessThanUnsignedShort(short x1, short x2) {
                return (x1 & 0xFFFF) < (x2 & 0xFFFF);
            }

            public static boolean isAvailable() {
                return theUnsafe != null;
            }

            @Override
            public int compareTo(byte[] buffer1, int offset1, int length1, byte[] buffer2, int offset2, int length2) {
                int b;
                int a;
                if (buffer1 == buffer2 && offset1 == offset2 && length1 == length2) {
                    return 0;
                }
                int minLength = Math.min(length1, length2);
                int minWords = minLength / 8;
                long offset1Adj = (long)offset1 + (long)BYTE_ARRAY_BASE_OFFSET;
                long offset2Adj = (long)offset2 + (long)BYTE_ARRAY_BASE_OFFSET;
                for (int i = 0; i < minWords * 8; i += 8) {
                    long lw = theUnsafe.getLong(buffer1, offset1Adj + (long)i);
                    long rw = theUnsafe.getLong(buffer2, offset2Adj + (long)i);
                    long diff = lw ^ rw;
                    if (littleEndian) {
                        lw = Long.reverseBytes(lw);
                        rw = Long.reverseBytes(rw);
                    }
                    if (diff == 0L) continue;
                    return UnsafeComparer.lessThanUnsignedLong(lw, rw) ? -1 : 1;
                }
                int offset = minWords * 8;
                if (minLength - offset >= 4) {
                    int il = theUnsafe.getInt(buffer1, offset1Adj + (long)offset);
                    int ir = theUnsafe.getInt(buffer2, offset2Adj + (long)offset);
                    if (littleEndian) {
                        il = Integer.reverseBytes(il);
                        ir = Integer.reverseBytes(ir);
                    }
                    if (il != ir) {
                        return UnsafeComparer.lessThanUnsignedInt(il, ir) ? -1 : 1;
                    }
                    offset += 4;
                }
                if (minLength - offset >= 2) {
                    short sl = theUnsafe.getShort(buffer1, offset1Adj + (long)offset);
                    short sr = theUnsafe.getShort(buffer2, offset2Adj + (long)offset);
                    if (littleEndian) {
                        sl = Short.reverseBytes(sl);
                        sr = Short.reverseBytes(sr);
                    }
                    if (sl != sr) {
                        return UnsafeComparer.lessThanUnsignedShort(sl, sr) ? -1 : 1;
                    }
                    offset += 2;
                }
                if (minLength - offset == 1 && (a = buffer1[offset1 + offset] & 0xFF) != (b = buffer2[offset2 + offset] & 0xFF)) {
                    return a - b;
                }
                return length1 - length2;
            }

            static {
                theUnsafe = (Unsafe)AccessController.doPrivileged(() -> {
                    try {
                        Field f = Unsafe.class.getDeclaredField("theUnsafe");
                        f.setAccessible(true);
                        return f.get(null);
                    }
                    catch (IllegalAccessException | NoSuchFieldException e) {
                        throw new Error();
                    }
                });
                BYTE_ARRAY_BASE_OFFSET = theUnsafe.arrayBaseOffset(byte[].class);
                if (theUnsafe.arrayIndexScale(byte[].class) != 1) {
                    throw new AssertionError();
                }
                littleEndian = ByteOrder.nativeOrder().equals(ByteOrder.LITTLE_ENDIAN);
            }
        }

        static enum PureJavaComparer implements Comparer<byte[]>
        {
            INSTANCE;


            @Override
            public int compareTo(byte[] buffer1, int offset1, int length1, byte[] buffer2, int offset2, int length2) {
                if (buffer1 == buffer2 && offset1 == offset2 && length1 == length2) {
                    return 0;
                }
                int end1 = offset1 + length1;
                int end2 = offset2 + length2;
                int i = offset1;
                for (int j = offset2; i < end1 && j < end2; ++i, ++j) {
                    int a = buffer1[i] & 0xFF;
                    int b = buffer2[j] & 0xFF;
                    if (a == b) continue;
                    return a - b;
                }
                return length1 - length2;
            }
        }
    }

    static interface Comparer<T> {
        public int compareTo(T var1, int var2, int var3, T var4, int var5, int var6);
    }
}

