/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common;

import com.alibaba.cloud.nacos.NacosConfigProperties;
import io.kyligence.config.core.conf.ExternalConfigProperties;
import io.kyligence.config.core.loader.IExternalConfigLoader;
import io.kyligence.config.external.loader.NacosExternalConfigLoader;
import java.nio.file.Paths;
import java.util.List;
import lombok.Generated;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.KylinConfigBase;
import org.apache.kylin.common.KylinExternalConfigLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.env.YamlPropertySourceLoader;
import org.springframework.core.env.Environment;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.core.io.FileUrlResource;
import org.springframework.core.io.Resource;

public final class ShellKylinExternalConfigLoaderFactory {
    private static final long serialVersionUID = 8140984602630371871L;
    private static final Logger logger = LoggerFactory.getLogger(ShellKylinExternalConfigLoaderFactory.class);

    public static IExternalConfigLoader getConfigLoader() {
        if (KylinConfig.useLegacyConfig()) {
            return new KylinExternalConfigLoader(KylinConfig.getSitePropertiesFile());
        }
        IExternalConfigLoader configLoader = null;
        try {
            if (Paths.get(KylinConfigBase.getKylinHome(), "conf", "config.yaml").toFile().exists()) {
                Environment environment = ShellKylinExternalConfigLoaderFactory.getEnvironment();
                ExternalConfigProperties externalConfigProperties = (ExternalConfigProperties)Binder.get((Environment)environment).bind("kylin.external.config", ExternalConfigProperties.class).get();
                NacosConfigProperties nacosConfigProperties = (NacosConfigProperties)Binder.get((Environment)environment).bind("spring.cloud.nacos.config", NacosConfigProperties.class).get();
                List infos = externalConfigProperties.getInfos();
                configLoader = infos.stream().filter(info -> info.getTarget().equals(KylinConfig.class.getName())).map(info -> new NacosExternalConfigLoader(info.getProperties(), nacosConfigProperties, environment)).findAny().orElse(null);
            }
        }
        catch (Exception e) {
            logger.warn("Can not load external config from config.yaml, use file external config loader", (Throwable)e);
        }
        if (configLoader != null) {
            return configLoader;
        }
        return new KylinExternalConfigLoader(KylinConfig.getSitePropertiesFile());
    }

    private static Environment getEnvironment() {
        StandardEnvironment environment = new StandardEnvironment();
        try {
            YamlPropertySourceLoader loader = new YamlPropertySourceLoader();
            List propertySources = loader.load("config-application-yaml", (Resource)new FileUrlResource(Paths.get(KylinConfigBase.getKylinHome(), "conf", "config.yaml").toFile().getAbsolutePath()));
            propertySources.forEach(propertySource -> environment.getPropertySources().addLast(propertySource));
        }
        catch (Exception e) {
            logger.warn("Can not load config.yaml", (Throwable)e);
        }
        return environment;
    }

    @Generated
    private ShellKylinExternalConfigLoaderFactory() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

