/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.kafka.util;

import java.nio.ByteBuffer;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.serialization.ByteBufferDeserializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.streaming.jobs.StreamingJobUtils;

public class KafkaUtils {
    private static final Pair<Boolean, String> kafkaJaasTextPair = new Pair((Object)false, null);
    private static Consumer<String, ByteBuffer> mockup;
    private static final String BOOTSTRAP_SERVER = "bootstrap.servers";
    private static final String KEY_DESERIALIZER = "key.deserializer";
    private static final String VALUE_DESERIALIZER = "value.deserializer";
    private static final String GROUP_ID = "group.id";
    private static final String ENABLE_AUTO_COMMIT = "enable.auto.commit";

    private KafkaUtils() {
        throw new IllegalStateException("Utility class");
    }

    public static AdminClient getKafkaAdminClient(String brokers, String groupId) {
        return KafkaUtils.getKafkaAdminClient(brokers, groupId, new Properties());
    }

    public static AdminClient getKafkaAdminClient(String brokers, String groupId, Properties properties) {
        Properties props = KafkaUtils.getAdminClientProperties(brokers, groupId, properties);
        return AdminClient.create((Properties)props);
    }

    public static Consumer<String, ByteBuffer> getKafkaConsumer(String brokers, String groupId) {
        return KafkaUtils.getKafkaConsumer(brokers, groupId, new Properties());
    }

    public static Consumer<String, ByteBuffer> getKafkaConsumer(String brokers, String groupId, Properties properties) {
        Properties props = KafkaUtils.getConsumerProperties(brokers, groupId, properties);
        if (mockup != null) {
            return mockup;
        }
        return new KafkaConsumer(props);
    }

    public static Properties getAdminClientProperties(String brokers, String consumerGroup, Properties properties) {
        Properties props = new Properties();
        KafkaUtils.setSaslJaasConf(props);
        props.put(BOOTSTRAP_SERVER, brokers);
        props.put(GROUP_ID, consumerGroup);
        if (MapUtils.isNotEmpty((Map)properties)) {
            props.putAll((Map<?, ?>)properties);
        }
        return props;
    }

    public static Properties getConsumerProperties(String brokers, String consumerGroup, Properties properties) {
        Properties props = new Properties();
        KafkaUtils.setSaslJaasConf(props);
        props.put(BOOTSTRAP_SERVER, brokers);
        props.put(KEY_DESERIALIZER, StringDeserializer.class.getName());
        props.put(VALUE_DESERIALIZER, ByteBufferDeserializer.class.getName());
        props.put(GROUP_ID, consumerGroup);
        props.put(ENABLE_AUTO_COMMIT, "false");
        if (MapUtils.isNotEmpty((Map)properties)) {
            props.putAll((Map<?, ?>)properties);
        }
        return props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setSaslJaasConf(Properties props) {
        props.putAll((Map<?, ?>)KylinConfig.getInstanceFromEnv().getStreamingKafkaConfigOverride());
        Pair<Boolean, String> pair = kafkaJaasTextPair;
        synchronized (pair) {
            if (Boolean.FALSE.equals(kafkaJaasTextPair.getFirst())) {
                kafkaJaasTextPair.setSecond((Object)StreamingJobUtils.extractKafkaJaasConf(true));
                kafkaJaasTextPair.setFirst((Object)true);
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)((CharSequence)kafkaJaasTextPair.getSecond()))) {
            props.put("sasl.jaas.config", kafkaJaasTextPair.getSecond());
        }
    }
}

