/*
 * Decompiled with CFR 0.152.
 */
package jodd.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import jodd.io.IOUtil;
import jodd.util.ClassLoaderStrategy;
import jodd.util.ClassUtil;
import jodd.util.ResourcesUtil;

public class ClassLoaderUtil {
    public static ClassLoaderStrategy classLoaderStrategy = new ClassLoaderStrategy.DefaultClassLoaderStrategy();
    private static final String[] MANIFESTS = new String[]{"Manifest.mf", "manifest.mf", "MANIFEST.MF"};

    public static ClassLoader getDefaultClassLoader() {
        ClassLoader cl = ClassLoaderUtil.getContextClassLoader();
        if (cl == null) {
            Class callerClass = ClassUtil.getCallerClass(2);
            cl = callerClass.getClassLoader();
        }
        return cl;
    }

    public static ClassLoader getContextClassLoader() {
        if (System.getSecurityManager() == null) {
            return Thread.currentThread().getContextClassLoader();
        }
        return AccessController.doPrivileged(() -> Thread.currentThread().getContextClassLoader());
    }

    public static ClassLoader getSystemClassLoader() {
        if (System.getSecurityManager() == null) {
            return ClassLoader.getSystemClassLoader();
        }
        return AccessController.doPrivileged(ClassLoader::getSystemClassLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static Manifest getClasspathItemManifest(File classpathItem) {
        Manifest manifest;
        block10: {
            block11: {
                manifest = null;
                if (!classpathItem.isFile()) break block11;
                FileInputStream fis = null;
                try {
                    fis = new FileInputStream(classpathItem);
                    JarFile jar = new JarFile(classpathItem);
                    manifest = jar.getManifest();
                }
                catch (IOException jar) {
                    IOUtil.close(fis);
                }
                catch (Throwable throwable) {
                    IOUtil.close(fis);
                    throw throwable;
                }
                IOUtil.close(fis);
                break block10;
            }
            File metaDir = new File(classpathItem, "META-INF");
            File manifestFile = null;
            if (metaDir.isDirectory()) {
                for (String m : MANIFESTS) {
                    File mFile = new File(metaDir, m);
                    if (!mFile.isFile()) continue;
                    manifestFile = mFile;
                    break;
                }
            }
            if (manifestFile != null) {
                FileInputStream fis = null;
                try {
                    fis = new FileInputStream(manifestFile);
                    manifest = new Manifest(fis);
                }
                catch (IOException iOException) {
                    IOUtil.close(fis);
                    catch (Throwable throwable) {
                        IOUtil.close(fis);
                        throw throwable;
                    }
                }
                IOUtil.close(fis);
            }
        }
        return manifest;
    }

    public static String getClasspathItemBaseDir(File classpathItem) {
        String base = classpathItem.isFile() ? classpathItem.getParent() : classpathItem.toString();
        return base;
    }

    public static InputStream getClassAsStream(Class clazz) throws IOException {
        return ResourcesUtil.getResourceAsStream(ClassUtil.convertClassNameToFileName(clazz), clazz.getClassLoader());
    }

    public static InputStream getClassAsStream(String className) throws IOException {
        return ResourcesUtil.getResourceAsStream(ClassUtil.convertClassNameToFileName(className));
    }

    public static InputStream getClassAsStream(String className, ClassLoader classLoader) throws IOException {
        return ResourcesUtil.getResourceAsStream(ClassUtil.convertClassNameToFileName(className), classLoader);
    }

    public static Class loadClass(String className) throws ClassNotFoundException {
        return classLoaderStrategy.loadClass(className, null);
    }

    public static Class loadClass(String className, ClassLoader classLoader) throws ClassNotFoundException {
        return classLoaderStrategy.loadClass(className, classLoader);
    }

    public static String classLocation(Class clazz) {
        return clazz.getProtectionDomain().getCodeSource().getLocation().getPath();
    }
}

