/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.engine.view;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.calcite.jdbc.CalcitePrepare;
import org.apache.calcite.schema.Function;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.Table;
import org.apache.calcite.schema.TranslatableTable;
import org.apache.calcite.schema.impl.AbstractSchema;
import org.apache.calcite.schema.impl.ViewTableMacro;
import org.apache.calcite.sql.parser.SqlParseException;
import org.apache.kylin.common.exception.ErrorCodeSupplier;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.QueryErrorCode;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.query.engine.view.ModelViewGenerator;
import org.apache.kylin.query.engine.view.ViewAnalyzer;

public class ViewSchema
extends AbstractSchema {
    private final String schemaName;
    private final ViewAnalyzer analyzer;

    public ViewSchema(String schemaName, ViewAnalyzer analyzer) {
        this.schemaName = schemaName;
        this.analyzer = analyzer;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    protected Map<String, Table> getTableMap() {
        return new HashMap<String, Table>();
    }

    public void addModel(SchemaPlus schemaPlus, NDataModel model) {
        schemaPlus.add(model.getAlias(), (Function)this.createViewMacro(model));
    }

    private LazyParsedViewTableMacro createViewMacro(NDataModel model) {
        String viewSQL = new ModelViewGenerator(model).generateViewSQL();
        ArrayList schemaPath = Lists.newArrayList((Object[])new String[]{this.schemaName});
        ArrayList viewPath = Lists.newArrayList((Object[])new String[]{this.schemaName, model.getAlias()});
        return new LazyParsedViewTableMacro(() -> this.analyzeView(viewSQL), viewSQL, schemaPath, viewPath);
    }

    public CalcitePrepare.AnalyzeViewResult analyzeView(String sql) {
        try {
            return this.analyzer.analyzeView(sql);
        }
        catch (SqlParseException e) {
            throw new KylinException((ErrorCodeSupplier)QueryErrorCode.FAILED_PARSE_ERROR, (Throwable)e);
        }
    }

    public static class LazyParsedViewTableMacro
    extends ViewTableMacro {
        private static boolean modifiable = false;
        private CalcitePrepare.AnalyzeViewResult parsed;
        private final Supplier<CalcitePrepare.AnalyzeViewResult> parseFunction;

        public LazyParsedViewTableMacro(Supplier<CalcitePrepare.AnalyzeViewResult> parseFunction, String viewSql, List<String> schemaPath, List<String> viewPath) {
            super(null, viewSql, schemaPath, viewPath, Boolean.valueOf(modifiable));
            this.parseFunction = parseFunction;
        }

        public TranslatableTable apply(List<? extends Object> arguments) {
            return this.viewTable(this.getParsed(), this.viewSql, this.schemaPath, this.viewPath);
        }

        private CalcitePrepare.AnalyzeViewResult getParsed() {
            if (this.parsed == null) {
                this.parsed = this.parseFunction.get();
            }
            return this.parsed;
        }
    }
}

