/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gluten.vectorized;

import java.io.Serializable;
import java.util.Iterator;
import org.apache.gluten.vectorized.CHNativeBlock;
import org.apache.gluten.vectorized.IteratorWrapper;
import org.apache.spark.sql.vectorized.ColumnarBatch;

public class BlockSplitIterator
implements Iterator<ColumnarBatch>,
AutoCloseable {
    private long instance = 0L;

    public BlockSplitIterator(Iterator<Long> in, IteratorOptions options) {
        this.instance = this.nativeCreate(new IteratorWrapper(in), options.getName(), options.getExpr(), options.getRequiredFields(), options.getPartitionNum(), options.getBufferSize(), options.getHashAlgorithm());
    }

    private native long nativeCreate(IteratorWrapper var1, String var2, String var3, String var4, int var5, int var6, String var7);

    private native void nativeClose(long var1);

    private native boolean nativeHasNext(long var1);

    @Override
    public boolean hasNext() {
        return this.nativeHasNext(this.instance);
    }

    private native long nativeNext(long var1);

    @Override
    public ColumnarBatch next() {
        CHNativeBlock block = new CHNativeBlock(this.nativeNext(this.instance));
        return block.toColumnarBatch();
    }

    private native int nativeNextPartitionId(long var1);

    public int nextPartitionId() {
        return this.nativeNextPartitionId(this.instance);
    }

    @Override
    public void close() throws Exception {
        this.nativeClose(this.instance);
    }

    public static class IteratorOptions
    implements Serializable {
        private static final long serialVersionUID = -1L;
        private int partitionNum;
        private String name;
        private int bufferSize;
        private String expr;
        private String requiredFields;
        private String hashAlgorithm;

        public int getPartitionNum() {
            return this.partitionNum;
        }

        public void setPartitionNum(int partitionNum) {
            this.partitionNum = partitionNum;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public int getBufferSize() {
            return this.bufferSize;
        }

        public void setBufferSize(int bufferSize) {
            this.bufferSize = bufferSize;
        }

        public String getExpr() {
            return this.expr;
        }

        public void setExpr(String expr) {
            this.expr = expr;
        }

        public String getRequiredFields() {
            return this.requiredFields;
        }

        public void setRequiredFields(String requiredFields) {
            this.requiredFields = requiredFields;
        }

        public String getHashAlgorithm() {
            return this.hashAlgorithm;
        }

        public void setHashAlgorithm(String hashAlgorithm) {
            this.hashAlgorithm = hashAlgorithm;
        }
    }
}

