/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.sdk.datasource.adaptor;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.sql.rowset.CachedRowSet;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.guava30.shaded.common.base.Joiner;
import org.apache.kylin.sdk.datasource.adaptor.AbstractJdbcAdaptor;
import org.apache.kylin.sdk.datasource.adaptor.AdaptorConfig;

public class DefaultAdaptor
extends AbstractJdbcAdaptor {
    private static final Joiner JOINER = Joiner.on((String)"_");
    private static final String TABLE_SCHEM = "TABLE_SCHEM";
    private static final String TABLE_NAME = "TABLE_NAME";
    private static final String DROP_TABLE_SQL = "DROP TABLE IF EXISTS ";

    protected DefaultAdaptor() {
    }

    public DefaultAdaptor(AdaptorConfig config) throws Exception {
        super(config);
    }

    @Override
    public int toKylinTypeId(String type, int typeId) {
        return typeId;
    }

    @Override
    public String toKylinTypeName(int sourceTypeId) {
        String result = "any";
        switch (sourceTypeId) {
            case 1: {
                result = "char";
                break;
            }
            case -9: 
            case -1: 
            case 12: {
                result = "varchar";
                break;
            }
            case 2: 
            case 3: {
                result = "decimal";
                break;
            }
            case -7: 
            case 16: {
                result = "boolean";
                break;
            }
            case -6: {
                result = "tinyint";
                break;
            }
            case 5: {
                result = "smallint";
                break;
            }
            case 4: {
                result = "integer";
                break;
            }
            case -5: {
                result = "bigint";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                result = "double";
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                result = "byte";
                break;
            }
            case 91: {
                result = "date";
                break;
            }
            case 92: {
                result = "time";
                break;
            }
            case 93: {
                result = "timestamp";
                break;
            }
        }
        return result;
    }

    @Override
    public String toSourceTypeName(String kylinTypeName) {
        return kylinTypeName;
    }

    @Override
    public String fixSql(String sql) {
        return sql;
    }

    @Override
    public String fixIdentifierCaseSensitive(String identifier) {
        try {
            List<String> databases = this.listDatabasesWithCache();
            for (String string : databases) {
                if (!identifier.equalsIgnoreCase(string)) continue;
                return string;
            }
            List<String> tables = this.listTables();
            for (String table : tables) {
                if (!identifier.equalsIgnoreCase(table)) continue;
                return table;
            }
            List<String> list = this.listColumns();
            for (String column : list) {
                if (!identifier.equalsIgnoreCase(column)) continue;
                return column;
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        return identifier;
    }

    @Override
    public List<String> listDatabases() throws SQLException {
        LinkedList<String> ret = new LinkedList<String>();
        try (Connection con = this.getConnection();
             ResultSet rs = con.getMetaData().getSchemas();){
            while (rs.next()) {
                String schema = rs.getString(TABLE_SCHEM);
                if (!StringUtils.isNotBlank((CharSequence)schema)) continue;
                ret.add(schema);
            }
        }
        return ret;
    }

    @Override
    public List<String> listTables(String schema) throws SQLException {
        ArrayList<String> ret = new ArrayList<String>();
        try (Connection conn = this.getConnection();
             ResultSet rs = conn.getMetaData().getTables(null, schema, null, null);){
            while (rs.next()) {
                String name = rs.getString(TABLE_NAME);
                if (!StringUtils.isNotBlank((CharSequence)name)) continue;
                ret.add(name);
            }
        }
        return ret;
    }

    public List<String> listTables() throws SQLException {
        ArrayList<String> ret;
        block30: {
            ret = new ArrayList<String>();
            if (this.TABLES_CACHE != null) {
                if (this.TABLES_CACHE.size() == 0L) {
                    try (Connection conn = this.getConnection();
                         ResultSet rs = conn.getMetaData().getTables(null, null, null, null);){
                        while (rs.next()) {
                            String name = rs.getString(TABLE_NAME);
                            String database = rs.getString(TABLE_SCHEM) != null ? rs.getString(TABLE_SCHEM) : rs.getString("TABLE_CAT");
                            String cacheKey = JOINER.join((Object)this.config.datasourceId, (Object)this.config.url, new Object[]{"tables", database});
                            ArrayList<String> cachedTables = (ArrayList<String>)this.TABLES_CACHE.getIfPresent((Object)cacheKey);
                            if (cachedTables == null) {
                                cachedTables = new ArrayList<String>();
                                this.TABLES_CACHE.put((Object)cacheKey, cachedTables);
                                logger.debug("Add table cache for database {}", (Object)database);
                            }
                            if (!cachedTables.contains(name)) {
                                cachedTables.add(name);
                            }
                            ret.add(name);
                        }
                        break block30;
                    }
                }
                for (Map.Entry entry : this.TABLES_CACHE.asMap().entrySet()) {
                    ret.addAll((Collection)entry.getValue());
                }
            }
        }
        return ret;
    }

    @Override
    public List<String> listColumns(String database, String tableName) throws SQLException {
        ArrayList<String> ret = new ArrayList<String>();
        CachedRowSet columnsRs = this.getTableColumns(database, tableName);
        while (columnsRs.next()) {
            String name = columnsRs.getString("COLUMN_NAME");
            if (!StringUtils.isNotBlank((CharSequence)name)) continue;
            ret.add(name);
        }
        return ret;
    }

    /*
     * Exception decompiling
     */
    @Override
    public CachedRowSet getTable(String schema, String table) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public CachedRowSet getTableColumns(String schema, String table) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public List<String> listColumns() throws SQLException {
        ArrayList<String> ret;
        block31: {
            ret = new ArrayList<String>();
            if (this.COLUMNS_CACHE == null) break block31;
            if (this.COLUMNS_CACHE.size() == 0L) {
                CachedRowSet columnsRs = null;
                try (Connection conn = this.getConnection();
                     ResultSet rs = conn.getMetaData().getColumns(null, null, null, null);){
                    columnsRs = this.cacheResultSet(rs);
                }
                while (columnsRs.next()) {
                    String database = columnsRs.getString(TABLE_SCHEM) != null ? columnsRs.getString(TABLE_SCHEM) : columnsRs.getString("TABLE_CAT");
                    String table = columnsRs.getString(TABLE_NAME);
                    String column_name = columnsRs.getString("COLUMN_NAME");
                    String cacheKey = JOINER.join((Object)this.config.datasourceId, (Object)this.config.url, new Object[]{database, table, "columns"});
                    ArrayList<String> cachedColumns = (ArrayList<String>)this.COLUMNS_CACHE.getIfPresent((Object)cacheKey);
                    if (cachedColumns == null) {
                        cachedColumns = new ArrayList<String>();
                        this.COLUMNS_CACHE.put((Object)cacheKey, cachedColumns);
                        logger.debug("Add column cache for {}.{}", (Object)database, (Object)table);
                    }
                    if (!cachedColumns.contains(column_name)) {
                        cachedColumns.add(column_name);
                    }
                    ret.add(column_name);
                }
            } else {
                for (Map.Entry entry : this.COLUMNS_CACHE.asMap().entrySet()) {
                    ret.addAll((Collection)entry.getValue());
                }
            }
        }
        return ret;
    }

    @Override
    public String[] buildSqlToCreateSchema(String schemaName) {
        return new String[]{String.format(Locale.ROOT, "CREATE schema IF NOT EXISTS %s", schemaName)};
    }

    @Override
    public String[] buildSqlToLoadDataFromLocal(String tableName, String tableFileDir) {
        return new String[]{String.format(Locale.ROOT, "LOAD DATA INFILE '%s/%s.csv' INTO %s FIELDS TERMINATED BY ',';", tableFileDir, tableName, tableName)};
    }

    @Override
    public String[] buildSqlToCreateTable(String tableIdentity, LinkedHashMap<String, String> columnInfo) {
        String dropsql = DROP_TABLE_SQL + tableIdentity;
        String dropsql2 = "DROP VIEW IF EXISTS " + tableIdentity;
        StringBuilder ddl = new StringBuilder();
        ddl.append("CREATE TABLE ").append(tableIdentity).append("\n");
        ddl.append("(\n");
        for (Map.Entry<String, String> col : columnInfo.entrySet()) {
            ddl.append(col.getKey()).append(" ").append(this.toSourceTypeName(col.getValue())).append(",\n");
        }
        ddl.deleteCharAt(ddl.length() - 2);
        ddl.append(")");
        return new String[]{dropsql, dropsql2, ddl.toString()};
    }

    @Override
    public String[] buildSqlToCreateView(String viewName, String sql) {
        String dropView = "DROP VIEW IF EXISTS " + viewName;
        String dropTable = DROP_TABLE_SQL + viewName;
        String createSql = "CREATE VIEW " + viewName + " AS " + sql;
        return new String[]{dropView, dropTable, createSql};
    }
}

