/*
 * Decompiled with CFR 0.152.
 */
package alluxio.wire;

import alluxio.shaded.client.com.google.common.base.MoreObjects;
import java.io.Serializable;

public class JournalDiskInfo
implements Serializable {
    private static final long serialVersionUID = 12938071234234123L;
    private final String mDiskPath;
    private final String mDiskType;
    private final long mUsedBytes;
    private final long mTotalAllocatedBytes;
    private final long mAvailableBytes;
    private final double mPercentAvailable;
    private final String mMountPath;

    public JournalDiskInfo(String diskPath, String diskType, long totalAllocatedBytes, long usedBytes, long availableBytes, String mountPath) {
        this.mDiskPath = diskPath;
        this.mDiskType = diskType;
        this.mTotalAllocatedBytes = totalAllocatedBytes * 1024L;
        this.mUsedBytes = usedBytes * 1024L;
        this.mAvailableBytes = availableBytes * 1024L;
        this.mMountPath = mountPath;
        this.mPercentAvailable = 100.0 * ((double)this.mAvailableBytes / (double)(this.mAvailableBytes + this.mUsedBytes));
    }

    public String getDiskPath() {
        return this.mDiskPath;
    }

    public String getDiskPathWithSchema() {
        if (this.mDiskType.contains("nfs")) {
            return "nfs://" + this.mDiskPath;
        }
        return this.mDiskPath;
    }

    public long getUsedBytes() {
        return this.mUsedBytes;
    }

    public long getTotalAllocatedBytes() {
        return this.mTotalAllocatedBytes;
    }

    public long getAvailableBytes() {
        return this.mAvailableBytes;
    }

    public String getMountPath() {
        return this.mMountPath;
    }

    public double getPercentAvailable() {
        return this.mPercentAvailable;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("diskPath", this.mDiskPath).add("totalAllocatedBytes", this.mTotalAllocatedBytes).add("usedBytes", this.mUsedBytes).add("availableBytes", this.mAvailableBytes).add("percentAvailable", this.mPercentAvailable).add("mountPath", this.mMountPath).toString();
    }
}

