/*
 * Decompiled with CFR 0.152.
 */
package alluxio.wire;

import alluxio.AlluxioURI;
import alluxio.exception.AlluxioException;
import alluxio.grpc.BackupPStatus;
import alluxio.grpc.BackupState;
import alluxio.shaded.client.com.google.common.base.MoreObjects;
import alluxio.shaded.client.com.google.protobuf.ByteString;
import alluxio.shaded.client.org.apache.commons.lang3.SerializationUtils;
import java.util.UUID;

public class BackupStatus {
    private UUID mBackupId;
    private BackupState mState;
    private String mBackupHost;
    private AlluxioURI mBackupUri;
    private long mEntryCount;
    private AlluxioException mError;

    public BackupStatus(BackupState state) {
        this.mBackupId = UUID.randomUUID();
        this.mState = state;
    }

    public BackupStatus(UUID backupId, BackupState state) {
        this.mBackupId = backupId;
        this.mState = state;
    }

    public BackupStatus(BackupStatus status) {
        this.mBackupId = status.mBackupId;
        this.mState = status.mState;
        this.mBackupHost = status.mBackupHost;
        this.mBackupUri = status.mBackupUri;
        this.mEntryCount = status.mEntryCount;
        this.mError = status.mError;
    }

    public static BackupStatus fromProto(BackupPStatus pStatus) {
        BackupStatus status = new BackupStatus(pStatus.getBackupState());
        status.setBackupId(UUID.fromString(pStatus.getBackupId()));
        if (pStatus.hasBackupHost()) {
            status.setHostname(pStatus.getBackupHost());
        }
        if (pStatus.hasBackupUri()) {
            status.setBackupUri(new AlluxioURI(pStatus.getBackupUri()));
        }
        if (pStatus.hasBackupError()) {
            status.setError((AlluxioException)SerializationUtils.deserialize(pStatus.getBackupError().toByteArray()));
        }
        status.setEntryCount(pStatus.getEntryCount());
        return status;
    }

    public UUID getBackupId() {
        return this.mBackupId;
    }

    public void setBackupId(UUID backupUuid) {
        this.mBackupId = backupUuid;
    }

    public long getEntryCount() {
        return this.mEntryCount;
    }

    public BackupStatus setEntryCount(long entryCount) {
        this.mEntryCount = entryCount;
        return this;
    }

    public boolean isFinished() {
        return this.isCompleted() || this.isFailed();
    }

    public boolean isCompleted() {
        return this.mState == BackupState.Completed;
    }

    public boolean isFailed() {
        return this.mState == BackupState.Failed;
    }

    public BackupState getState() {
        return this.mState;
    }

    public BackupStatus setState(BackupState state) {
        this.mState = state;
        return this;
    }

    public AlluxioException getError() {
        return this.mError;
    }

    public BackupStatus setError(AlluxioException error) {
        this.mError = error;
        this.mState = BackupState.Failed;
        return this;
    }

    public String getHostname() {
        return this.mBackupHost;
    }

    public BackupStatus setHostname(String hostName) {
        this.mBackupHost = hostName;
        return this;
    }

    public AlluxioURI getBackupUri() {
        return this.mBackupUri;
    }

    public BackupStatus setBackupUri(AlluxioURI backupUri) {
        this.mBackupUri = backupUri;
        return this;
    }

    public BackupPStatus toProto() {
        BackupPStatus.Builder builder = BackupPStatus.newBuilder().setBackupId(this.mBackupId.toString()).setBackupState(this.mState).setEntryCount(this.mEntryCount);
        if (this.mBackupHost != null) {
            builder.setBackupHost(this.mBackupHost);
        }
        if (this.mError != null) {
            builder.setBackupError(ByteString.copyFrom(SerializationUtils.serialize(this.mError)));
        }
        if (this.mBackupUri != null) {
            builder.setBackupUri(this.mBackupUri.toString());
        }
        return builder.build();
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).omitNullValues().add("BackupId", this.mBackupId).add("BackupState", this.mState.name()).add("BackupHost", this.mBackupHost).add("BackupURI", this.mBackupUri).add("EntryCount", this.mEntryCount).add("Error", this.mError).toString();
    }
}

