/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shaded.client.org.apache.zookeeper.server;

import alluxio.shaded.client.org.apache.jute.BinaryInputArchive;
import alluxio.shaded.client.org.apache.zookeeper.Version;
import alluxio.shaded.client.org.apache.zookeeper.jmx.ZKMBeanInfo;
import alluxio.shaded.client.org.apache.zookeeper.server.ServerStats;
import alluxio.shaded.client.org.apache.zookeeper.server.ZooKeeperServer;
import alluxio.shaded.client.org.apache.zookeeper.server.ZooKeeperServerMXBean;
import java.util.Date;

public class ZooKeeperServerBean
implements ZooKeeperServerMXBean,
ZKMBeanInfo {
    private final Date startTime = new Date();
    private final String name;
    protected final ZooKeeperServer zks;

    public ZooKeeperServerBean(ZooKeeperServer zks) {
        this.zks = zks;
        this.name = "StandaloneServer_port" + zks.getClientPort();
    }

    @Override
    public String getClientPort() {
        return Integer.toString(this.zks.getClientPort());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isHidden() {
        return false;
    }

    @Override
    public String getStartTime() {
        return this.startTime.toString();
    }

    @Override
    public String getVersion() {
        return Version.getFullVersion();
    }

    @Override
    public long getAvgRequestLatency() {
        return this.zks.serverStats().getAvgLatency();
    }

    @Override
    public long getMaxRequestLatency() {
        return this.zks.serverStats().getMaxLatency();
    }

    @Override
    public long getMinRequestLatency() {
        return this.zks.serverStats().getMinLatency();
    }

    @Override
    public long getOutstandingRequests() {
        return this.zks.serverStats().getOutstandingRequests();
    }

    @Override
    public int getTickTime() {
        return this.zks.getTickTime();
    }

    @Override
    public void setTickTime(int tickTime) {
        this.zks.setTickTime(tickTime);
    }

    @Override
    public int getMaxClientCnxnsPerHost() {
        return this.zks.getMaxClientCnxnsPerHost();
    }

    @Override
    public void setMaxClientCnxnsPerHost(int max) {
        if (this.zks.serverCnxnFactory != null) {
            this.zks.serverCnxnFactory.setMaxClientCnxnsPerHost(max);
        }
        if (this.zks.secureServerCnxnFactory != null) {
            this.zks.secureServerCnxnFactory.setMaxClientCnxnsPerHost(max);
        }
    }

    @Override
    public int getMinSessionTimeout() {
        return this.zks.getMinSessionTimeout();
    }

    @Override
    public void setMinSessionTimeout(int min2) {
        this.zks.setMinSessionTimeout(min2);
    }

    @Override
    public int getMaxSessionTimeout() {
        return this.zks.getMaxSessionTimeout();
    }

    @Override
    public void setMaxSessionTimeout(int max) {
        this.zks.setMaxSessionTimeout(max);
    }

    @Override
    public long getDataDirSize() {
        return this.zks.getDataDirSize();
    }

    @Override
    public long getLogDirSize() {
        return this.zks.getLogDirSize();
    }

    @Override
    public long getPacketsReceived() {
        return this.zks.serverStats().getPacketsReceived();
    }

    @Override
    public long getPacketsSent() {
        return this.zks.serverStats().getPacketsSent();
    }

    @Override
    public long getFsyncThresholdExceedCount() {
        return this.zks.serverStats().getFsyncThresholdExceedCount();
    }

    @Override
    public void resetLatency() {
        this.zks.serverStats().resetLatency();
    }

    @Override
    public void resetMaxLatency() {
        this.zks.serverStats().resetMaxLatency();
    }

    @Override
    public void resetFsyncThresholdExceedCount() {
        this.zks.serverStats().resetFsyncThresholdExceedCount();
    }

    @Override
    public void resetStatistics() {
        ServerStats serverStats = this.zks.serverStats();
        serverStats.resetRequestCounters();
        serverStats.resetLatency();
        serverStats.resetFsyncThresholdExceedCount();
    }

    @Override
    public long getNumAliveConnections() {
        return this.zks.getNumAliveConnections();
    }

    @Override
    public String getSecureClientPort() {
        if (this.zks.secureServerCnxnFactory != null) {
            return Integer.toString(this.zks.secureServerCnxnFactory.getLocalPort());
        }
        return "";
    }

    @Override
    public String getSecureClientAddress() {
        if (this.zks.secureServerCnxnFactory != null) {
            return String.format("%s:%d", this.zks.secureServerCnxnFactory.getLocalAddress().getHostString(), this.zks.secureServerCnxnFactory.getLocalPort());
        }
        return "";
    }

    @Override
    public long getTxnLogElapsedSyncTime() {
        return this.zks.getTxnLogElapsedSyncTime();
    }

    @Override
    public int getJuteMaxBufferSize() {
        return BinaryInputArchive.maxBuffer;
    }

    @Override
    public int getLastClientResponseSize() {
        return this.zks.serverStats().getClientResponseStats().getLastBufferSize();
    }

    @Override
    public int getMinClientResponseSize() {
        return this.zks.serverStats().getClientResponseStats().getMinBufferSize();
    }

    @Override
    public int getMaxClientResponseSize() {
        return this.zks.serverStats().getClientResponseStats().getMaxBufferSize();
    }
}

