/*
 * Decompiled with CFR 0.152.
 */
package alluxio.security.authentication;

import alluxio.grpc.SaslMessage;
import alluxio.grpc.SaslMessageType;
import alluxio.security.authentication.SaslServerHandler;
import alluxio.shaded.client.com.google.protobuf.ByteString;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSaslServerHandler
implements SaslServerHandler {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractSaslServerHandler.class);
    protected SaslServer mSaslServer;

    @Override
    public SaslMessage handleMessage(SaslMessage message) throws SaslException {
        switch (message.getMessageType()) {
            case CHALLENGE: {
                byte[] saslResponse = this.mSaslServer.evaluateResponse(message.getMessage().toByteArray());
                SaslMessage.Builder response = SaslMessage.newBuilder();
                if (this.mSaslServer.isComplete()) {
                    response.setMessageType(SaslMessageType.SUCCESS);
                } else {
                    response.setMessageType(SaslMessageType.CHALLENGE);
                }
                if (saslResponse != null) {
                    response.setMessage(ByteString.copyFrom(saslResponse));
                }
                return response.build();
            }
        }
        throw new SaslException("Server can't process Sasl message type:" + message.getMessageType().name());
    }

    @Override
    public void close() {
        if (this.mSaslServer != null) {
            try {
                this.mSaslServer.dispose();
            }
            catch (SaslException exc) {
                LOG.debug("Failed to close SaslServer.", (Throwable)exc);
            }
        }
    }
}

