/*
 * Decompiled with CFR 0.152.
 */
package alluxio.metrics.sink;

import alluxio.metrics.MetricsSystem;
import alluxio.metrics.sink.Sink;
import alluxio.shaded.client.com.codahale.metrics.CsvReporter;
import alluxio.shaded.client.com.codahale.metrics.MetricRegistry;
import alluxio.shaded.client.javax.annotation.concurrent.ThreadSafe;
import java.io.File;
import java.util.Locale;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class CsvSink
implements Sink {
    private static final Logger LOG = LoggerFactory.getLogger(CsvSink.class);
    private static final int CSV_DEFAULT_PERIOD = 10;
    private static final String CSV_DEFAULT_UNIT = "SECONDS";
    private static final String CSV_DEFAULT_DIR = "/tmp/";
    private static final String CSV_KEY_PERIOD = "period";
    private static final String CSV_KEY_UNIT = "unit";
    private static final String CSV_KEY_DIR = "directory";
    private CsvReporter mReporter;
    private Properties mProperties;
    private final File mDir;

    public CsvSink(Properties properties, MetricRegistry registry) {
        this.mProperties = properties;
        this.mDir = new File(this.getPollDir());
        this.createPollDir(this.mDir);
        this.mReporter = CsvReporter.forRegistry(registry).formatFor(Locale.US).convertDurationsTo(TimeUnit.MILLISECONDS).convertRatesTo(TimeUnit.SECONDS).build(this.mDir);
        MetricsSystem.checkMinimalPollingPeriod(this.getPollUnit(), this.getPollPeriod());
    }

    @Override
    public void start() {
        this.mReporter.start(this.getPollPeriod(), this.getPollUnit());
    }

    @Override
    public void stop() {
        this.mReporter.stop();
    }

    @Override
    public void report() {
        this.mReporter.report();
    }

    private String getPollDir() {
        String pollDir = this.mProperties.getProperty(CSV_KEY_DIR);
        return pollDir != null ? pollDir : CSV_DEFAULT_DIR;
    }

    private int getPollPeriod() {
        String period = this.mProperties.getProperty(CSV_KEY_PERIOD);
        return period != null ? Integer.parseInt(period) : 10;
    }

    private TimeUnit getPollUnit() {
        String unit = this.mProperties.getProperty(CSV_KEY_UNIT);
        if (unit == null) {
            unit = CSV_DEFAULT_UNIT;
        }
        return TimeUnit.valueOf(unit.toUpperCase());
    }

    private void createPollDir(File dir) {
        if (!dir.exists()) {
            try {
                dir.mkdirs();
            }
            catch (SecurityException e) {
                LOG.warn("Fail to create directory {} for CSV sink, {}", (Object)dir, (Object)e.toString());
            }
        }
    }
}

