/*
 * Decompiled with CFR 0.152.
 */
package alluxio.grpc;

import alluxio.shaded.client.com.google.common.io.Closer;
import alluxio.shaded.client.io.grpc.BindableService;
import alluxio.shaded.client.io.grpc.ServerServiceDefinition;
import java.io.Closeable;

public class GrpcService {
    private final ServerServiceDefinition mServiceDefinition;
    private boolean mAuthenticated = true;
    private Closer mCloser = Closer.create();

    public GrpcService(BindableService bindableService) {
        this.mServiceDefinition = bindableService.bindService();
    }

    public GrpcService(ServerServiceDefinition serviceDefinition) {
        this.mServiceDefinition = serviceDefinition;
    }

    public GrpcService disableAuthentication() {
        this.mAuthenticated = false;
        return this;
    }

    public GrpcService withCloseable(Closeable closeable) {
        this.mCloser.register(closeable);
        return this;
    }

    public Closer getCloser() {
        return this.mCloser;
    }

    public boolean isAuthenticated() {
        return this.mAuthenticated;
    }

    public ServerServiceDefinition getServiceDefinition() {
        return this.mServiceDefinition;
    }
}

