/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.file;

import alluxio.AlluxioURI;
import alluxio.client.file.FileSystem;
import alluxio.conf.PropertyKey;
import alluxio.exception.AlluxioException;
import alluxio.exception.FileDoesNotExistException;
import alluxio.grpc.ScheduleAsyncPersistencePOptions;
import alluxio.shaded.client.com.google.common.base.Throwables;
import alluxio.shaded.client.javax.annotation.concurrent.ThreadSafe;
import alluxio.util.CommonUtils;
import alluxio.util.WaitForOptions;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class FileSystemUtils {
    private static final Logger LOG = LoggerFactory.getLogger(FileSystemUtils.class);

    private FileSystemUtils() {
    }

    public static boolean waitCompleted(FileSystem fs, AlluxioURI uri) throws IOException, AlluxioException, InterruptedException {
        return FileSystemUtils.waitCompleted(fs, uri, -1L, TimeUnit.MILLISECONDS);
    }

    public static boolean waitCompleted(FileSystem fs, AlluxioURI uri, long timeout, TimeUnit tunit) throws IOException, AlluxioException, InterruptedException {
        long deadline = System.currentTimeMillis() + tunit.toMillis(timeout);
        long fileWaitCompletedPollMs = fs.getConf().getMs(PropertyKey.USER_FILE_WAITCOMPLETED_POLL_MS);
        boolean completed = false;
        long timeleft = deadline - System.currentTimeMillis();
        while (!(completed || timeout > 0L && timeleft <= 0L)) {
            if (!fs.exists(uri)) {
                LOG.debug("The file {} being waited upon does not exist yet. Waiting for it to be created.", (Object)uri);
            } else {
                completed = fs.getStatus(uri).isCompleted();
            }
            if (timeout == 0L) {
                return completed;
            }
            if (completed) continue;
            long toSleep = timeout < 0L || timeleft > fileWaitCompletedPollMs ? fileWaitCompletedPollMs : timeleft;
            CommonUtils.sleepMs(LOG, toSleep);
            timeleft = deadline - System.currentTimeMillis();
        }
        return completed;
    }

    public static void persistAndWait(FileSystem fs, AlluxioURI uri, long persistenceWaitTime) throws FileDoesNotExistException, IOException, AlluxioException, TimeoutException, InterruptedException {
        FileSystemUtils.persistAndWait(fs, uri, persistenceWaitTime, -1);
    }

    public static void persistAndWait(FileSystem fs, AlluxioURI uri, long persistenceWaitTime, int timeoutMs) throws FileDoesNotExistException, IOException, AlluxioException, TimeoutException, InterruptedException {
        LOG.debug("Start to persist {}", (Object)uri.getPath());
        fs.persist(uri, ScheduleAsyncPersistencePOptions.newBuilder().setPersistenceWaitTime(persistenceWaitTime).build());
        LOG.debug("Waiting for persist result for path {}, with persistence wait time {} and time out {}", new Object[]{uri.getPath(), persistenceWaitTime, timeoutMs});
        CommonUtils.waitForResult(String.format("%s to be persisted", uri), () -> {
            try {
                LOG.debug("Polling file system master for the status of {}", (Object)uri);
                return fs.getStatus(uri);
            }
            catch (Exception e) {
                LOG.debug("Exception when attempting to getStatus while waiting for persistence {}", (Object)e.toString());
                Throwables.throwIfUnchecked(e);
                throw new RuntimeException(e);
            }
        }, status -> status.isPersisted(), WaitForOptions.defaults().setTimeoutMs(timeoutMs).setInterval(100));
    }

    public static void waitForAlluxioPercentage(FileSystem fs, AlluxioURI uri, int expectedPercentage) throws TimeoutException, InterruptedException {
        CommonUtils.waitFor(uri.toString() + " is " + expectedPercentage + "% stored in Alluxio", () -> {
            try {
                return fs.getStatus(uri).getInAlluxioPercentage() == expectedPercentage;
            }
            catch (Exception e) {
                return false;
            }
        }, WaitForOptions.defaults().setTimeoutMs(30000));
    }
}

