/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.gluten;

import java.io.File;
import java.io.Serializable;
import java.time.ZoneId;
import org.apache.gluten.execution.FileSourceScanExecTransformer;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.QueryTest$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.SparkSessionExtensions;
import org.apache.spark.sql.catalyst.expressions.AttributeSet;
import org.apache.spark.sql.catalyst.plans.SQLHelper;
import org.apache.spark.sql.catalyst.util.package$;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.adaptive.AdaptiveSparkPlanHelper;
import org.apache.spark.sql.execution.datasource.KylinSourceStrategy$;
import org.apache.spark.sql.execution.datasource.LayoutFileSourceStrategy$;
import org.apache.spark.sql.execution.gluten.KylinFileSourceScanExecTransformer;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005ua\u0001B\u0005\u000b\u0001]AQA\u000b\u0001\u0005\u0002-BQA\f\u0001\u0005B=BQA\u000e\u0001\u0005B=BQa\u000e\u0001\u0005\naBQa\u0013\u0001\u0005\n1CQa\u001a\u0001\u0005\u0012=BQ\u0001\u001b\u0001\u0005\u0012%DQa\u001f\u0001\u0005\u0002q\u00141c\u00127vi\u0016tg)\u001b7f'\u000e\fgnU;ji\u0016T!a\u0003\u0007\u0002\r\u001ddW\u000f^3o\u0015\tia\"A\u0005fq\u0016\u001cW\u000f^5p]*\u0011q\u0002E\u0001\u0004gFd'BA\t\u0013\u0003\u0015\u0019\b/\u0019:l\u0015\t\u0019B#\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002+\u0005\u0019qN]4\u0004\u0001M!\u0001\u0001\u0007\u000f%!\tI\"$D\u0001\u0011\u0013\tY\u0002CA\u0007Ta\u0006\u00148NR;o'VLG/\u001a\t\u0003;\tj\u0011A\b\u0006\u0003?\u0001\nQ\u0001\u001d7b]NT!!\t\b\u0002\u0011\r\fG/\u00197zgRL!a\t\u0010\u0003\u0013M\u000bF\nS3ma\u0016\u0014\bCA\u0013)\u001b\u00051#BA\u0014\r\u0003!\tG-\u00199uSZ,\u0017BA\u0015'\u0005]\tE-\u00199uSZ,7\u000b]1sWBc\u0017M\u001c%fYB,'/\u0001\u0004=S:LGO\u0010\u000b\u0002YA\u0011Q\u0006A\u0007\u0002\u0015\u0005Q!-\u001a4pe\u0016,\u0015m\u00195\u0015\u0003A\u0002\"!\r\u001b\u000e\u0003IR\u0011aM\u0001\u0006g\u000e\fG.Y\u0005\u0003kI\u0012A!\u00168ji\u0006I\u0011M\u001a;fe\u0016\u000b7\r[\u0001\u000fGJ,\u0017\r^3TS6\u0004H.\u001a#G)\r\u0001\u0014H\u0010\u0005\u0006#\u0011\u0001\rA\u000f\t\u0003wqj\u0011AD\u0005\u0003{9\u0011Ab\u00159be.\u001cVm]:j_:DQa\u0010\u0003A\u0002\u0001\u000bq\u0001^3na\u0012K'\u000f\u0005\u0002B\u0011:\u0011!I\u0012\t\u0003\u0007Jj\u0011\u0001\u0012\u0006\u0003\u000bZ\ta\u0001\u0010:p_Rt\u0014BA$3\u0003\u0019\u0001&/\u001a3fM&\u0011\u0011J\u0013\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\u001d\u0013\u0014AJ4fi:\u000bG/\u001b<f\r&dWmU8ve\u000e,7kY1o\u000bb,7\r\u0016:b]N4wN]7feR\u0011QJ\u0016\t\u0004c9\u0003\u0016BA(3\u0005\u0019y\u0005\u000f^5p]B\u0011\u0011\u000bV\u0007\u0002%*\u0011Qb\u0015\u0006\u0003\u0017II!!\u0016*\u0003;\u0019KG.Z*pkJ\u001cWmU2b]\u0016CXm\u0019+sC:\u001chm\u001c:nKJDQaV\u0003A\u0002a\u000b!\u0001\u001a4\u0011\u0005e#gB\u0001.c\u001d\tY\u0016M\u0004\u0002]A:\u0011Ql\u0018\b\u0003\u0007zK\u0011!F\u0005\u0003'QI!!\u0005\n\n\u0005=\u0001\u0012BA2\u000f\u0003\u001d\u0001\u0018mY6bO\u0016L!!\u001a4\u0003\u0013\u0011\u000bG/\u0019$sC6,'BA2\u000f\u0003E\u0019G.Z1s'B\f'o[*fgNLwN\\\u0001\fG\",7m[!og^,'\u000fF\u00021U:DaaV\u0004\u0005\u0002\u0004Y\u0007cA\u0019m1&\u0011QN\r\u0002\ty\tLh.Y7f}!)qn\u0002a\u0001a\u0006qQ\r\u001f9fGR,G-\u00118to\u0016\u0014\bcA9vq:\u0011!\u000f\u001e\b\u0003\u0007NL\u0011aM\u0005\u0003GJJ!A^<\u0003\u0007M+\u0017O\u0003\u0002deA\u00111(_\u0005\u0003u:\u00111AU8x\u0003]\t7o]3si\u0016k\u0007\u000f^=NSN\u001c\u0018N\\4J]B,H\u000f\u0006\u00021{\")a\u0010\u0003a\u0001\u007f\u0006)\u0011/^3ssB\"\u0011\u0011AA\u0006!\u0015Y\u00141AA\u0004\u0013\r\t)A\u0004\u0002\b\t\u0006$\u0018m]3u!\u0011\tI!a\u0003\r\u0001\u0011Y\u0011QB?\u0002\u0002\u0003\u0005)\u0011AA\b\u0005\ryF%M\t\u0005\u0003#\t9\u0002E\u00022\u0003'I1!!\u00063\u0005\u001dqu\u000e\u001e5j]\u001e\u00042!MA\r\u0013\r\tYB\r\u0002\u0004\u0003:L\b")
public class GlutenFileScanSuite
extends SparkFunSuite
implements SQLHelper,
AdaptiveSparkPlanHelper {
    private String sparkHome;
    private volatile boolean bitmap$0;

    public Option<SparkPlan> find(SparkPlan p, Function1<SparkPlan, Object> f) {
        return AdaptiveSparkPlanHelper.find$((AdaptiveSparkPlanHelper)this, (SparkPlan)p, f);
    }

    public void foreach(SparkPlan p, Function1<SparkPlan, BoxedUnit> f) {
        AdaptiveSparkPlanHelper.foreach$((AdaptiveSparkPlanHelper)this, (SparkPlan)p, f);
    }

    public void foreachUp(SparkPlan p, Function1<SparkPlan, BoxedUnit> f) {
        AdaptiveSparkPlanHelper.foreachUp$((AdaptiveSparkPlanHelper)this, (SparkPlan)p, f);
    }

    public <A> Seq<A> mapPlans(SparkPlan p, Function1<SparkPlan, A> f) {
        return AdaptiveSparkPlanHelper.mapPlans$((AdaptiveSparkPlanHelper)this, (SparkPlan)p, f);
    }

    public <A> Seq<A> flatMap(SparkPlan p, Function1<SparkPlan, TraversableOnce<A>> f) {
        return AdaptiveSparkPlanHelper.flatMap$((AdaptiveSparkPlanHelper)this, (SparkPlan)p, f);
    }

    public <B> Seq<B> collect(SparkPlan p, PartialFunction<SparkPlan, B> pf) {
        return AdaptiveSparkPlanHelper.collect$((AdaptiveSparkPlanHelper)this, (SparkPlan)p, pf);
    }

    public Seq<SparkPlan> collectLeaves(SparkPlan p) {
        return AdaptiveSparkPlanHelper.collectLeaves$((AdaptiveSparkPlanHelper)this, (SparkPlan)p);
    }

    public <B> Option<B> collectFirst(SparkPlan p, PartialFunction<SparkPlan, B> pf) {
        return AdaptiveSparkPlanHelper.collectFirst$((AdaptiveSparkPlanHelper)this, (SparkPlan)p, pf);
    }

    public <B> Seq<B> collectWithSubqueries(SparkPlan p, PartialFunction<SparkPlan, B> f) {
        return AdaptiveSparkPlanHelper.collectWithSubqueries$((AdaptiveSparkPlanHelper)this, (SparkPlan)p, f);
    }

    public Seq<SparkPlan> subqueriesAll(SparkPlan p) {
        return AdaptiveSparkPlanHelper.subqueriesAll$((AdaptiveSparkPlanHelper)this, (SparkPlan)p);
    }

    public SparkPlan stripAQEPlan(SparkPlan p) {
        return AdaptiveSparkPlanHelper.stripAQEPlan$((AdaptiveSparkPlanHelper)this, (SparkPlan)p);
    }

    public void withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<BoxedUnit> f) {
        SQLHelper.withSQLConf$((SQLHelper)this, pairs, f);
    }

    public void withTempPath(Function1<File, BoxedUnit> f) {
        SQLHelper.withTempPath$((SQLHelper)this, f);
    }

    public <T> void testSpecialDatetimeValues(Function1<ZoneId, T> test) {
        SQLHelper.testSpecialDatetimeValues$((SQLHelper)this, test);
    }

    private String sparkHome$lzycompute() {
        GlutenFileScanSuite glutenFileScanSuite = this;
        synchronized (glutenFileScanSuite) {
            if (!this.bitmap$0) {
                this.sparkHome = SQLHelper.sparkHome$((SQLHelper)this);
                this.bitmap$0 = true;
            }
        }
        return this.sparkHome;
    }

    public String sparkHome() {
        return !this.bitmap$0 ? this.sparkHome$lzycompute() : this.sparkHome;
    }

    public void beforeEach() {
        this.clearSparkSession();
    }

    public void afterEach() {
        this.clearSparkSession();
    }

    private void createSimpleDF(SparkSession spark, String tempDir) {
        spark.range(100L).selectExpr((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id % 2 as a", "id % 3 as b", "id as c"})).write().parquet(tempDir);
    }

    private Option<FileSourceScanExecTransformer> getNativeFileSourceScanExecTransformer(Dataset<Row> df) {
        return this.collectFirst(df.queryExecution().executedPlan(), (PartialFunction)new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends SparkPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof KylinFileSourceScanExecTransformer) {
                    KylinFileSourceScanExecTransformer kylinFileSourceScanExecTransformer;
                    object = kylinFileSourceScanExecTransformer = (KylinFileSourceScanExecTransformer)A1;
                } else if (A1 instanceof FileSourceScanExecTransformer) {
                    FileSourceScanExecTransformer fileSourceScanExecTransformer = (FileSourceScanExecTransformer)A1;
                    object = fileSourceScanExecTransformer;
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(SparkPlan x1) {
                SparkPlan sparkPlan = x1;
                boolean bl = sparkPlan instanceof KylinFileSourceScanExecTransformer ? true : sparkPlan instanceof FileSourceScanExecTransformer;
                return bl;
            }
        });
    }

    public void clearSparkSession() {
        SparkSession$.MODULE$.setActiveSession(null);
        SparkSession$.MODULE$.setDefaultSession(null);
        SparkSession$.MODULE$.cleanupAnyExistingSession();
    }

    public void checkAnswer(Function0<Dataset<Row>> df, Seq<Row> expectedAnswer) {
        Dataset dataset;
        try {
            dataset = (Dataset)df.apply();
        }
        catch (AnalysisException ae) {
            if (ae.plan().isDefined()) {
                throw this.fail(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(110).append("\n               |Failed to analyze query: ").append((Object)ae).append("\n               |").append(ae.plan().get()).append("\n               |\n               |").append(package$.MODULE$.stackTraceToString((Throwable)ae)).append("\n               |").toString())).stripMargin(), new Position("GlutenFileScanSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 105));
            }
            throw ae;
        }
        Dataset analyzedDF = dataset;
        this.assertEmptyMissingInput(analyzedDF);
        QueryTest$.MODULE$.checkAnswer(analyzedDF, expectedAnswer, true);
    }

    public void assertEmptyMissingInput(Dataset<?> query) {
        AttributeSet $org_scalatest_assert_macro_left = query.queryExecution().analyzed().missingInput();
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringBuilder(46).append("The analyzed logical plan has missing inputs:\n").append(query.queryExecution().analyzed()).toString(), Prettifier$.MODULE$.default(), new Position("GlutenFileScanSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 123));
        AttributeSet $org_scalatest_assert_macro_left2 = query.queryExecution().optimizedPlan().missingInput();
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left2, "isEmpty", $org_scalatest_assert_macro_left2.isEmpty(), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)new StringBuilder(47).append("The optimized logical plan has missing inputs:\n").append(query.queryExecution().optimizedPlan()).toString(), Prettifier$.MODULE$.default(), new Position("GlutenFileScanSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 125));
        AttributeSet $org_scalatest_assert_macro_left3 = query.queryExecution().executedPlan().missingInput();
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left3, "isEmpty", $org_scalatest_assert_macro_left3.isEmpty(), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)new StringBuilder(38).append("The physical plan has missing inputs:\n").append(query.queryExecution().executedPlan()).toString(), Prettifier$.MODULE$.default(), new Position("GlutenFileScanSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 127));
    }

    public static final /* synthetic */ void $anonfun$new$3(SparkSessionExtensions ext) {
        ext.injectPlannerStrategy((Function1 & Serializable & scala.Serializable)x$1 -> KylinSourceStrategy$.MODULE$);
        ext.injectPlannerStrategy((Function1 & Serializable & scala.Serializable)x$2 -> LayoutFileSourceStrategy$.MODULE$);
    }

    public static final /* synthetic */ void $anonfun$new$2(GlutenFileScanSuite $this, File path) {
        Option<FileSourceScanExecTransformer> f;
        SparkSession$.MODULE$.cleanupAnyExistingSession();
        String tempDir = path.getCanonicalPath();
        SparkSession spark = SparkSession$.MODULE$.builder().master("local[3]").config("spark.sql.shuffle.partitions", "3").config("spark.sql.adaptive.enabled", "true").config("spark.plugins", "org.apache.gluten.GlutenPlugin").config("spark.shuffle.manager", "org.apache.spark.shuffle.sort.ColumnarShuffleManager").config("spark.io.compression.codec", "LZ4").config("spark.gluten.sql.columnar.libpath", "/usr/local/clickhouse/lib/libch.so").config("spark.gluten.sql.enable.native.validation", "false").config("spark.memory.offHeap.enabled", "true").config("spark.memory.offHeap.size", "2G").config("spark.gluten.sql.columnar.extended.columnar.pre.rules", "org.apache.spark.sql.execution.gluten.ConvertKylinFileSourceToGlutenRule").config("spark.gluten.sql.columnar.extended.columnar.post.rules", "").withExtensions((Function1 & Serializable & scala.Serializable)ext -> {
            GlutenFileScanSuite.$anonfun$new$3(ext);
            return BoxedUnit.UNIT;
        }).getOrCreate();
        $this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"spark.gluten.enabled", (Object)"false")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.createSimpleDF(spark, tempDir));
        Dataset df = spark.read().parquet(tempDir).where("a = 0").groupBy("b", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).agg(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"c"), (Object)"sum"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        Row[] res = (Row[])df.collect();
        Object[] $org_scalatest_assert_macro_left = Predef$.MODULE$.refArrayOps((Object[])res);
        int $org_scalatest_assert_macro_right = 3;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)new ArrayOps.ofRef($org_scalatest_assert_macro_left), "size", (Object)BoxesRunTime.boxToInteger((int)new ArrayOps.ofRef($org_scalatest_assert_macro_left).size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("GlutenFileScanSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 73));
        Option<FileSourceScanExecTransformer> $org_scalatest_assert_macro_left2 = f = $this.getNativeFileSourceScanExecTransformer((Dataset<Row>)df);
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.unaryMacroBool($org_scalatest_assert_macro_left2, "isEmpty", $org_scalatest_assert_macro_left2.isEmpty(), Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("GlutenFileScanSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 75));
        FileSourceScanExecTransformer $org_scalatest_assert_macro_left3 = (FileSourceScanExecTransformer)f.get();
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left3, "isInstanceOf", "org.apache.gluten.execution.FileSourceScanExecTransformer", $org_scalatest_assert_macro_left3 instanceof FileSourceScanExecTransformer, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("GlutenFileScanSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 76));
        spark.sparkContext().stop();
    }

    public GlutenFileScanSuite() {
        SQLHelper.$init$((SQLHelper)this);
        AdaptiveSparkPlanHelper.$init$((AdaptiveSparkPlanHelper)this);
        this.ignore("Test with Gluten", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)path -> {
            GlutenFileScanSuite.$anonfun$new$2(this, path);
            return BoxedUnit.UNIT;
        }), new Position("GlutenFileScanSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 40));
    }
}

