/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasource;

import java.util.Arrays;
import java.util.Collection;
import org.apache.kylin.common.KapConfig;
import org.apache.kylin.common.util.NLocalFileMetadataTestCase;
import org.apache.kylin.junit.annotation.MetadataInfo;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.execution.datasource.ResetShufflePartition;
import org.apache.spark.sql.internal.SQLConf;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
@MetadataInfo
public class ResetFilesMaxPartitionBytesParameterizedTest
extends NLocalFileMetadataTestCase {
    protected static final Logger logger = LoggerFactory.getLogger(ResetFilesMaxPartitionBytesParameterizedTest.class);
    private ResetShufflePartition resetShufflePartition = new ResetShufflePartition(){

        public void org$apache$spark$internal$Logging$$log__$eq(Logger msg) {
        }

        public Logger org$apache$spark$internal$Logging$$log_() {
            return logger;
        }
    };
    private final String resetMaxPartitionBytes;
    private final Long totalRowCount;
    private final Long sourceBytes;
    private final String parquetRowCountThresholdSize;
    private final String filesThresholdBytes;
    private final String parquetRowCountPerMb;
    private final Boolean expected;

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        return Arrays.asList({"false", 0L, 0L, "0", "0", "0", Boolean.FALSE}, {"true", 0L, 1L, "0", "0", "0", Boolean.FALSE}, {"true", 1L, 10L, "0", "20", "0", Boolean.FALSE}, {"true", 1L, 10L, "0", "20", "0", Boolean.FALSE}, {"true", 2L, 0x100000L, "3", String.valueOf(0x100400), "2", Boolean.FALSE}, {"true", 2L, 0x100000L, "3", String.valueOf(0x100400), "1", Boolean.TRUE});
    }

    @Before
    public void setup() {
        this.createTestMetadata(new String[0]);
    }

    @After
    public void destroy() {
        this.cleanupTestMetadata();
    }

    public ResetFilesMaxPartitionBytesParameterizedTest(String resetMaxPartitionBytes, Long totalRowCount, Long sourceBytes, String parquetRowCountThresholdSize, String filesThresholdBytes, String parquetRowCountPerMb, Boolean expected) {
        this.resetMaxPartitionBytes = resetMaxPartitionBytes;
        this.totalRowCount = totalRowCount;
        this.sourceBytes = sourceBytes;
        this.parquetRowCountThresholdSize = parquetRowCountThresholdSize;
        this.filesThresholdBytes = filesThresholdBytes;
        this.parquetRowCountPerMb = parquetRowCountPerMb;
        this.expected = expected;
    }

    @Test
    public void testNeedSetFilesMaxPartitionBytes() {
        this.overwriteSystemProp("kylin.storage.columnar.reset-max-partition-bytes", this.resetMaxPartitionBytes);
        this.overwriteSystemProp("kylin.storage.columnar.parquet-row-count-threshold-size", this.parquetRowCountThresholdSize);
        this.overwriteSystemProp("kylin.storage.columnar.files-threshold-bytes", this.filesThresholdBytes);
        this.overwriteSystemProp("kylin.storage.columnar.parquet-row-count-per-mb", this.parquetRowCountPerMb);
        this.overwriteSystemProp("kylin.storage.columnar.files.max-partition-bytes", "1");
        KapConfig kapConfig = KapConfig.getInstanceFromEnv();
        Assert.assertEquals((Object)this.expected, (Object)this.resetShufflePartition.needSetFilesMaxPartitionBytes(this.totalRowCount.longValue(), this.sourceBytes.longValue(), kapConfig));
        SparkSession sparkSession = SparkSession.builder().master("local[1]").getOrCreate();
        this.resetShufflePartition.setFilesMaxPartitionBytes(this.sourceBytes.longValue(), this.totalRowCount.longValue(), sparkSession);
        if (this.expected.booleanValue()) {
            Assert.assertEquals((Object)1L, (Object)sparkSession.sessionState().conf().getConf(SQLConf.FILES_MAX_PARTITION_BYTES()));
        } else {
            Assert.assertEquals((Object)0x8000000L, (Object)sparkSession.sessionState().conf().getConf(SQLConf.FILES_MAX_PARTITION_BYTES()));
        }
    }
}

