/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql.util.springbatch;

import java.util.HashMap;
import java.util.Map;
import org.mybatis.dynamic.sql.select.SelectModel;
import org.mybatis.dynamic.sql.select.render.SelectStatementProvider;
import org.mybatis.dynamic.sql.util.springbatch.SpringBatchUtility;

public class SpringBatchPagingReaderSelectModel {
    private final SelectModel selectModel;

    public SpringBatchPagingReaderSelectModel(SelectModel selectModel) {
        this.selectModel = selectModel;
    }

    public SelectStatementProvider render() {
        SelectStatementProvider selectStatement = this.selectModel.render(SpringBatchUtility.SPRING_BATCH_READER_RENDERING_STRATEGY);
        return new LimitAndOffsetDecorator(selectStatement);
    }

    public static class LimitAndOffsetDecorator
    implements SelectStatementProvider {
        private final Map<String, Object> parameters = new HashMap<String, Object>();
        private final String selectStatement;

        public LimitAndOffsetDecorator(SelectStatementProvider delegate) {
            this.parameters.putAll(delegate.getParameters());
            this.selectStatement = delegate.getSelectStatement() + " LIMIT #{_pagesize} OFFSET #{_skiprows}";
        }

        @Override
        public Map<String, Object> getParameters() {
            return this.parameters;
        }

        @Override
        public String getSelectStatement() {
            return this.selectStatement;
        }
    }
}

