/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql.util;

import java.util.Objects;
import java.util.function.Supplier;
import org.mybatis.dynamic.sql.SqlColumn;
import org.mybatis.dynamic.sql.util.AbstractColumnMapping;
import org.mybatis.dynamic.sql.util.ColumnMappingVisitor;

public class ValueMapping<T>
extends AbstractColumnMapping {
    private final Supplier<T> valueSupplier;
    private final SqlColumn<T> localColumn;

    private ValueMapping(SqlColumn<T> column, Supplier<T> valueSupplier) {
        super(column);
        this.valueSupplier = Objects.requireNonNull(valueSupplier);
        this.localColumn = Objects.requireNonNull(column);
    }

    public Object value() {
        return this.localColumn.convertParameterType(this.valueSupplier.get());
    }

    @Override
    public <R> R accept(ColumnMappingVisitor<R> visitor) {
        return visitor.visit(this);
    }

    public static <T> ValueMapping<T> of(SqlColumn<T> column, Supplier<T> valueSupplier) {
        return new ValueMapping<T>(column, valueSupplier);
    }
}

