/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql.insert.render;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.mybatis.dynamic.sql.insert.render.FieldAndValueAndParameters;

public class FieldAndValueCollector {
    final List<FieldAndValueAndParameters> fieldsAndValues = new ArrayList<FieldAndValueAndParameters>();

    public void add(FieldAndValueAndParameters fieldAndValueAndParameters) {
        this.fieldsAndValues.add(fieldAndValueAndParameters);
    }

    public FieldAndValueCollector merge(FieldAndValueCollector other) {
        this.fieldsAndValues.addAll(other.fieldsAndValues);
        return this;
    }

    public boolean isEmpty() {
        return this.fieldsAndValues.isEmpty();
    }

    public String columnsPhrase() {
        return this.fieldsAndValues.stream().map(FieldAndValueAndParameters::fieldName).collect(Collectors.joining(", ", "(", ")"));
    }

    public String valuesPhrase() {
        return this.fieldsAndValues.stream().map(FieldAndValueAndParameters::valuePhrase).collect(Collectors.joining(", ", "values (", ")"));
    }

    public String multiRowInsertValuesPhrase(int rowCount) {
        return IntStream.range(0, rowCount).mapToObj(this::toSingleRowOfValues).collect(Collectors.joining(", ", "values ", ""));
    }

    private String toSingleRowOfValues(int row) {
        return this.fieldsAndValues.stream().map(FieldAndValueAndParameters::valuePhrase).map(s -> String.format(s, row)).collect(Collectors.joining(", ", "(", ")"));
    }

    public Map<String, Object> parameters() {
        return this.fieldsAndValues.stream().map(FieldAndValueAndParameters::parameters).collect(HashMap::new, HashMap::putAll, HashMap::putAll);
    }

    public static Collector<FieldAndValueAndParameters, FieldAndValueCollector, FieldAndValueCollector> collect() {
        return Collector.of(FieldAndValueCollector::new, FieldAndValueCollector::add, FieldAndValueCollector::merge, new Collector.Characteristics[0]);
    }
}

