/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import org.mybatis.dynamic.sql.SqlTable;

public abstract class AliasableSqlTable<T extends AliasableSqlTable<T>>
extends SqlTable {
    private String tableAlias;
    private final Supplier<T> constructor;

    protected AliasableSqlTable(String tableName, Supplier<T> constructor) {
        super(tableName);
        this.constructor = Objects.requireNonNull(constructor);
    }

    public T withAlias(String alias) {
        AliasableSqlTable newTable = (AliasableSqlTable)this.constructor.get();
        newTable.tableAlias = alias;
        newTable.nameSupplier = this.nameSupplier;
        return (T)newTable;
    }

    public T withName(String name) {
        Objects.requireNonNull(name);
        AliasableSqlTable newTable = (AliasableSqlTable)this.constructor.get();
        newTable.tableAlias = this.tableAlias;
        newTable.nameSupplier = () -> name;
        return (T)newTable;
    }

    @Override
    public Optional<String> tableAlias() {
        return Optional.ofNullable(this.tableAlias);
    }
}

