/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spi.service.contexts;

import com.fasterxml.classmate.ResolvedType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.http.HttpMethod;
import org.springframework.web.bind.annotation.RequestMethod;
import springfox.documentation.PathProvider;
import springfox.documentation.RequestHandler;
import springfox.documentation.annotations.Incubating;
import springfox.documentation.schema.AlternateTypeRule;
import springfox.documentation.service.ApiDescription;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.ApiListingReference;
import springfox.documentation.service.Operation;
import springfox.documentation.service.Parameter;
import springfox.documentation.service.RequestParameter;
import springfox.documentation.service.Response;
import springfox.documentation.service.ResponseMessage;
import springfox.documentation.service.SecurityScheme;
import springfox.documentation.service.Server;
import springfox.documentation.service.Tag;
import springfox.documentation.service.VendorExtension;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.schema.AlternateTypeProvider;
import springfox.documentation.spi.schema.GenericTypeNamingStrategy;
import springfox.documentation.spi.service.contexts.ApiSelector;
import springfox.documentation.spi.service.contexts.SecurityContext;

public class DocumentationContext {
    private final DocumentationType documentationType;
    private final List<RequestHandler> handlerMappings;
    private final ApiInfo apiInfo;
    private final String groupName;
    private final ApiSelector apiSelector;
    private final AlternateTypeProvider alternateTypeProvider;
    private final Set<Class> ignorableParameterTypes;
    private final Map<RequestMethod, List<ResponseMessage>> globalResponseMessages;
    private final Map<HttpMethod, List<Response>> globalResponses = new HashMap<HttpMethod, List<Response>>();
    private final List<Parameter> globalOperationParameters;
    private final List<Server> servers = new ArrayList<Server>();
    private final List<RequestParameter> globalParameters = new ArrayList<RequestParameter>();
    private final PathProvider pathProvider;
    private final List<SecurityContext> securityContexts;
    private final List<SecurityScheme> securitySchemes;
    private final Comparator<ApiListingReference> listingReferenceOrdering;
    private final Comparator<ApiDescription> apiDescriptionOrdering;
    private final Comparator<Operation> operationOrdering;
    private final GenericTypeNamingStrategy genericsNamingStrategy;
    private final Optional<String> pathMapping;
    private final Set<ResolvedType> additionalModels;
    private final Set<Tag> tags;
    private final Set<String> produces;
    private final Set<String> consumes;
    private final String host;
    private final Set<String> protocols;
    private final boolean isUriTemplatesEnabled;
    private final List<VendorExtension> vendorExtensions;

    public DocumentationContext(DocumentationType documentationType, List<RequestHandler> handlerMappings, ApiInfo apiInfo, String groupName, ApiSelector apiSelector, Set<Class> ignorableParameterTypes, Map<RequestMethod, List<ResponseMessage>> globalResponseMessages, List<Parameter> globalOperationParameter, List<RequestParameter> globalRequestParameters, Map<HttpMethod, List<Response>> globalResponses, PathProvider pathProvider, List<SecurityContext> securityContexts, List<SecurityScheme> securitySchemes, List<AlternateTypeRule> alternateTypeRules, Comparator<ApiListingReference> listingReferenceOrdering, Comparator<ApiDescription> apiDescriptionOrdering, Comparator<Operation> operationOrdering, Set<String> produces, Set<String> consumes, String host, Set<String> protocols, GenericTypeNamingStrategy genericsNamingStrategy, Optional<String> pathMapping, boolean isUriTemplatesEnabled, Set<ResolvedType> additionalModels, Set<Tag> tags, List<VendorExtension> vendorExtensions, List<Server> servers) {
        this.documentationType = documentationType;
        this.handlerMappings = handlerMappings;
        this.apiInfo = apiInfo;
        this.groupName = groupName;
        this.apiSelector = apiSelector;
        this.ignorableParameterTypes = ignorableParameterTypes;
        this.globalResponseMessages = globalResponseMessages;
        this.globalOperationParameters = globalOperationParameter;
        this.servers.addAll(servers);
        this.globalParameters.addAll(globalRequestParameters);
        this.pathProvider = pathProvider;
        this.securityContexts = securityContexts;
        this.securitySchemes = securitySchemes;
        this.listingReferenceOrdering = listingReferenceOrdering;
        this.apiDescriptionOrdering = apiDescriptionOrdering;
        this.operationOrdering = operationOrdering;
        this.produces = produces;
        this.consumes = consumes;
        this.host = host;
        this.protocols = protocols;
        this.genericsNamingStrategy = genericsNamingStrategy;
        this.pathMapping = pathMapping;
        this.isUriTemplatesEnabled = isUriTemplatesEnabled;
        this.additionalModels = additionalModels;
        this.tags = tags;
        this.alternateTypeProvider = new AlternateTypeProvider(alternateTypeRules);
        this.vendorExtensions = vendorExtensions;
        this.globalResponses.putAll(globalResponses);
    }

    public DocumentationType getDocumentationType() {
        return this.documentationType;
    }

    public List<RequestHandler> getRequestHandlers() {
        return this.handlerMappings;
    }

    public ApiInfo getApiInfo() {
        return this.apiInfo;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public ApiSelector getApiSelector() {
        return this.apiSelector;
    }

    public Set<Class> getIgnorableParameterTypes() {
        return new HashSet<Class>(this.ignorableParameterTypes);
    }

    public Map<RequestMethod, List<ResponseMessage>> getGlobalResponseMessages() {
        return this.globalResponseMessages;
    }

    @Deprecated
    public List<Parameter> getGlobalRequestParameters() {
        return this.globalOperationParameters;
    }

    public PathProvider getPathProvider() {
        return this.pathProvider;
    }

    public List<SecurityContext> getSecurityContexts() {
        return this.securityContexts;
    }

    public List<SecurityScheme> getSecuritySchemes() {
        return this.securitySchemes.stream().filter(Objects::nonNull).collect(Collectors.toList());
    }

    public Comparator<ApiListingReference> getListingReferenceOrdering() {
        return this.listingReferenceOrdering;
    }

    public Comparator<ApiDescription> getApiDescriptionOrdering() {
        return this.apiDescriptionOrdering;
    }

    public AlternateTypeProvider getAlternateTypeProvider() {
        return this.alternateTypeProvider;
    }

    public Comparator<Operation> operationOrdering() {
        return this.operationOrdering;
    }

    public Set<String> getProduces() {
        return this.produces;
    }

    public Set<String> getConsumes() {
        return this.consumes;
    }

    public String getHost() {
        return this.host;
    }

    public Set<String> getProtocols() {
        return this.protocols;
    }

    public GenericTypeNamingStrategy getGenericsNamingStrategy() {
        return this.genericsNamingStrategy;
    }

    public Optional<String> getPathMapping() {
        return this.pathMapping;
    }

    @Incubating(value="2.1.0")
    public boolean isUriTemplatesEnabled() {
        return this.isUriTemplatesEnabled;
    }

    public Set<ResolvedType> getAdditionalModels() {
        return this.additionalModels;
    }

    public Set<Tag> getTags() {
        return this.tags;
    }

    public List<VendorExtension> getVendorExtentions() {
        return this.vendorExtensions;
    }

    public Collection<RequestParameter> getGlobalParameters() {
        return this.globalParameters;
    }

    public Collection<Response> globalResponsesFor(HttpMethod method) {
        return this.globalResponses.getOrDefault(method, new ArrayList());
    }

    public Collection<Server> getServers() {
        return this.servers;
    }
}

