/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.oas.mappers;

import io.swagger.v3.oas.models.media.ObjectSchema;
import io.swagger.v3.oas.models.media.Schema;
import java.util.Objects;
import java.util.stream.Collectors;
import org.mapstruct.factory.Mappers;
import org.springframework.core.convert.converter.Converter;
import springfox.documentation.oas.mappers.SchemaMapper;
import springfox.documentation.schema.CompoundModelSpecification;
import springfox.documentation.service.ModelNamesRegistry;

public class CompoundSpecificationToSchemaConverter
implements Converter<CompoundModelSpecification, Schema<?>> {
    private final ModelNamesRegistry modelNamesRegistry;

    public CompoundSpecificationToSchemaConverter(ModelNamesRegistry modelNamesRegistry) {
        this.modelNamesRegistry = modelNamesRegistry;
    }

    public Schema<?> convert(CompoundModelSpecification source) {
        ObjectSchema schema = new ObjectSchema();
        schema.properties(source.getProperties().stream().map(p -> {
            Schema property = Mappers.getMapper(SchemaMapper.class).mapFrom(p.getType(), this.modelNamesRegistry);
            if (property != null) {
                return property.name(p.getName());
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toMap(Schema::getName, s -> s)));
        return schema;
    }
}

