/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.service;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.QueryContext;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.code.ErrorCodeProducer;
import org.apache.kylin.common.exception.code.ErrorCodeServer;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.query.util.QueryParams;
import org.apache.kylin.query.util.QueryUtil;
import org.apache.kylin.rec.query.validator.SQLValidateResult;
import org.apache.kylin.rec.query.validator.SqlSyntaxValidator;
import org.apache.kylin.rest.response.ImportSqlResponse;
import org.apache.kylin.rest.response.SQLParserResponse;
import org.apache.kylin.rest.response.SQLValidateResponse;
import org.apache.kylin.rest.service.BasicService;
import org.apache.kylin.rest.util.AclEvaluate;
import org.apache.kylin.rest.util.AclPermissionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;

@Component(value="favoriteRuleService")
public class FavoriteRuleService
extends BasicService {
    private static final Logger logger = LoggerFactory.getLogger(FavoriteRuleService.class);
    private static final String DEFAULT_SCHEMA = "DEFAULT";
    @Autowired
    private AclEvaluate aclEvaluate;

    public Map<String, SQLValidateResult> batchSqlValidate(List<String> sqls, String project) {
        KylinConfig projectConfig = NProjectManager.getProjectConfig((String)project);
        SqlSyntaxValidator sqlValidator = new SqlSyntaxValidator(project, projectConfig);
        return sqlValidator.batchValidate(sqls.toArray(new String[0]));
    }

    public SQLParserResponse importSqls(MultipartFile[] files, String project) {
        this.aclEvaluate.checkProjectWritePermission(project);
        ArrayList sqls = Lists.newArrayList();
        ArrayList wrongFormatFiles = Lists.newArrayList();
        QueryContext.AclInfo aclInfo = AclPermissionUtil.createAclInfo((String)project, (Set)this.getCurrentUserGroups());
        QueryContext context = QueryContext.current();
        context.setAclInfo(aclInfo);
        for (MultipartFile file : files) {
            String fileName = file.getOriginalFilename();
            if (!StringUtils.endsWithIgnoreCase((CharSequence)fileName, (CharSequence)".sql") && !StringUtils.endsWithIgnoreCase((CharSequence)fileName, (CharSequence)".txt")) {
                wrongFormatFiles.add(file.getOriginalFilename());
                continue;
            }
            try {
                sqls.addAll(this.transformFileToSqls(file, project));
            }
            catch (Error | Exception ex) {
                logger.error("[UNEXPECTED_THINGS_HAPPENED]Error caught when parsing file {} because {} ", (Object)file.getOriginalFilename(), (Object)ex);
                wrongFormatFiles.add(file.getOriginalFilename());
            }
        }
        SQLParserResponse result = new SQLParserResponse();
        KylinConfig kylinConfig = NProjectManager.getProjectConfig((String)project);
        if (sqls.size() > kylinConfig.getFavoriteImportSqlMaxSize()) {
            result.setSize(sqls.size());
            result.setWrongFormatFile(wrongFormatFiles);
            return result;
        }
        ArrayList sqlData = Lists.newArrayList();
        int capableSqlNum = 0;
        Map<String, SQLValidateResult> map = this.batchSqlValidate(sqls, project);
        int id = 0;
        for (Map.Entry<String, SQLValidateResult> entry : map.entrySet()) {
            String sql = entry.getKey();
            SQLValidateResult validateResult = entry.getValue();
            if (validateResult.isCapable()) {
                ++capableSqlNum;
            }
            ImportSqlResponse sqlResponse = new ImportSqlResponse(sql, validateResult.isCapable());
            sqlResponse.setId(id);
            sqlResponse.setSqlAdvices(validateResult.getSqlAdvices());
            sqlData.add(sqlResponse);
            ++id;
        }
        sqlData.sort((object1, object2) -> {
            boolean capable1 = object1.isCapable();
            boolean capable2 = object2.isCapable();
            if (capable1 && !capable2) {
                return 1;
            }
            if (capable2 && !capable1) {
                return -1;
            }
            return 0;
        });
        result.setData(sqlData);
        result.setSize(sqlData.size());
        result.setCapableSqlNum(capableSqlNum);
        result.setWrongFormatFile(wrongFormatFiles);
        return result;
    }

    List<String> transformFileToSqls(MultipartFile file, String project) throws IOException {
        ArrayList<String> sqls = new ArrayList<String>();
        String content = new String(file.getBytes(), StandardCharsets.UTF_8);
        if (content.isEmpty()) {
            return sqls;
        }
        List<String> sqlList = this.splitBySemicolon(content = QueryUtil.removeCommentInSql((String)content));
        if (sqlList.isEmpty()) {
            return sqls;
        }
        KylinConfig kylinConfig = NProjectManager.getProjectConfig((String)project);
        for (String sql : sqlList) {
            if (StringUtils.isBlank((CharSequence)sql) || sql.replace('\n', ' ').trim().length() == 0) continue;
            QueryParams queryParams = new QueryParams(kylinConfig, sql, project, 0, 0, DEFAULT_SCHEMA, false);
            queryParams.setAclInfo(QueryContext.current().getAclInfo());
            String correctedSql = QueryUtil.massageSqlAndExpandCC((QueryParams)queryParams);
            sqls.add(correctedSql);
        }
        return sqls;
    }

    private List<String> splitBySemicolon(String s) {
        ArrayList r = Lists.newArrayList();
        StringBuilder sb = new StringBuilder();
        boolean withinQuote = false;
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) == '\'') {
                boolean bl = withinQuote = !withinQuote;
            }
            if (s.charAt(i) == ';' && !withinQuote) {
                if (sb.length() == 0) continue;
                r.add(sb.toString());
                sb = new StringBuilder();
                continue;
            }
            sb.append(s.charAt(i));
        }
        if (sb.length() != 0) {
            r.add(sb.toString());
        }
        return r;
    }

    public SQLValidateResponse sqlValidate(String project, String sql) {
        this.aclEvaluate.checkProjectWritePermission(project);
        KylinConfig kylinConfig = NProjectManager.getProjectConfig((String)project);
        QueryParams queryParams = new QueryParams(kylinConfig, sql, project, 0, 0, DEFAULT_SCHEMA, false);
        queryParams.setAclInfo(AclPermissionUtil.createAclInfo((String)project, (Set)this.getCurrentUserGroups()));
        String correctedSql = QueryUtil.massageSql((QueryParams)queryParams);
        Map<String, SQLValidateResult> map = this.batchSqlValidate(Lists.newArrayList((Object[])new String[]{correctedSql}), project);
        SQLValidateResult result = map.get(correctedSql);
        if (result == null) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.INVALID_SQL_FORMAT, new Object[0]);
        }
        return new SQLValidateResponse(result.isCapable(), result.getSqlAdvices());
    }
}

