/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rec.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import lombok.Generated;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.metadata.cube.model.IndexEntity;
import org.apache.kylin.metadata.cube.model.IndexPlan;
import org.apache.kylin.metadata.cube.model.LayoutEntity;

public class EntityBuilder {
    private EntityBuilder() {
    }

    public static void checkDimensionsAndMeasures(List<Integer> dimIds, List<Integer> measureIds) {
        Preconditions.checkState((!dimIds.isEmpty() || !measureIds.isEmpty() ? 1 : 0) != 0, (Object)"Neither dimension nor measure could be proposed for indexEntity");
    }

    public static class IndexEntityBuilder {
        private final long id;
        private final IndexPlan indexPlan;
        private List<Integer> dimIds = Lists.newArrayList();
        private List<Integer> measureIds = Lists.newArrayList();
        private final List<LayoutEntity> layouts = Lists.newArrayList();

        public static long findAvailableIndexEntityId(IndexPlan indexPlan, Collection<IndexEntity> existedIndex, boolean isTableIndex) {
            long result = isTableIndex ? 20000000000L : 0L;
            ArrayList cuboidIds = Lists.newArrayList();
            for (IndexEntity indexEntity : existedIndex) {
                long indexEntityId = indexEntity.getId();
                if ((!isTableIndex || !IndexEntity.isTableIndex((long)indexEntityId)) && (isTableIndex || indexEntityId >= 20000000000L)) continue;
                cuboidIds.add(indexEntityId);
            }
            if (!cuboidIds.isEmpty()) {
                cuboidIds.sort(Long::compareTo);
                result = (Long)cuboidIds.get(cuboidIds.size() - 1) + 10000L;
            }
            return Math.max(result, isTableIndex ? indexPlan.getNextTableIndexId() : indexPlan.getNextAggregationIndexId());
        }

        public IndexEntityBuilder(long id, IndexPlan indexPlan) {
            this.id = id;
            this.indexPlan = indexPlan;
        }

        public IndexEntityBuilder dimIds(List<Integer> dimIds) {
            this.dimIds = dimIds;
            return this;
        }

        public IndexEntityBuilder measure(List<Integer> measureIds) {
            this.measureIds = measureIds;
            return this;
        }

        public IndexEntityBuilder addLayout(LayoutEntity layout) {
            this.layouts.add(layout);
            return this;
        }

        public IndexEntityBuilder addLayouts(List<LayoutEntity> layouts) {
            this.layouts.addAll(layouts);
            return this;
        }

        public IndexEntityBuilder setLayout(List<LayoutEntity> layouts) {
            this.layouts.clear();
            this.layouts.addAll(layouts);
            return this;
        }

        public IndexEntity build() {
            EntityBuilder.checkDimensionsAndMeasures(this.dimIds, this.measureIds);
            IndexEntity indexEntity = new IndexEntity();
            indexEntity.setId(this.id);
            indexEntity.setDimensions(this.dimIds);
            indexEntity.setMeasures((List)Lists.newArrayList(this.measureIds));
            indexEntity.setIndexPlan(this.indexPlan);
            indexEntity.setLayouts(this.layouts);
            return indexEntity;
        }

        @Generated
        public void setDimIds(List<Integer> dimIds) {
            this.dimIds = dimIds;
        }

        @Generated
        public void setMeasureIds(List<Integer> measureIds) {
            this.measureIds = measureIds;
        }
    }

    public static class LayoutEntityBuilder {
        private final long layoutId;
        private List<Integer> colOrderIds = Lists.newArrayList();
        private List<Integer> partitionCols = Lists.newArrayList();
        private List<Integer> shardByCols = Lists.newArrayList();
        private final IndexEntity index;
        private boolean isAuto;

        public LayoutEntityBuilder(long layoutId, IndexEntity index) {
            this.layoutId = layoutId;
            this.index = index;
        }

        public LayoutEntityBuilder colOrderIds(List<Integer> colOrderIds) {
            this.colOrderIds = colOrderIds;
            return this;
        }

        public LayoutEntityBuilder partitionCol(List<Integer> partitionCols) {
            this.partitionCols = partitionCols;
            return this;
        }

        public LayoutEntityBuilder shardByCol(List<Integer> shardByCols) {
            this.shardByCols = shardByCols;
            return this;
        }

        public LayoutEntityBuilder isAuto(boolean isAuto) {
            this.isAuto = isAuto;
            return this;
        }

        public LayoutEntity build() {
            LayoutEntity layout = new LayoutEntity();
            layout.setColOrder(this.colOrderIds);
            layout.setId(this.layoutId);
            layout.setIndex(this.index);
            layout.setAuto(this.isAuto);
            layout.setUpdateTime(System.currentTimeMillis());
            layout.setPartitionByColumns(this.partitionCols);
            layout.setShardByColumns(this.shardByCols);
            return layout;
        }
    }
}

