/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rec.runner;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.KylinConfigBase;
import org.apache.kylin.common.exception.KylinRuntimeException;
import org.apache.kylin.common.persistence.RawResource;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.persistence.metadata.MetadataStore;
import org.apache.kylin.common.persistence.transaction.UnitOfWorkParams;
import org.apache.kylin.common.util.ExecutableApplication;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.metadata.project.EnhancedUnitOfWork;
import org.apache.kylin.rec.runner.ForkBasedJobRunner;
import org.apache.kylin.rec.runner.InMemoryJobRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobRunnerFactory {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JobRunnerFactory.class);

    private JobRunnerFactory() {
    }

    public static AbstractJobRunner createRunner(KylinConfig config, String type, String project, List<String> resources) {
        switch (type) {
            case "fork": {
                return new ForkBasedJobRunner(config, project, resources);
            }
            case "in-memory": {
                return new InMemoryJobRunner(config, project, resources);
            }
        }
        throw new NotImplementedException("Runner type " + type + " not implement");
    }

    public static abstract class AbstractJobRunner {
        protected final KylinConfig kylinConfig;
        protected final String project;
        protected final List<String> originResources;
        protected String metaDumpUrl;
        protected String jobId;

        public void init(String jobId) {
            this.jobId = jobId;
            String jobTmpDir = this.getJobTmpDir();
            this.metaDumpUrl = jobTmpDir + "/meta";
        }

        public void start(ExecutableApplication app, Map<String, String> args) throws Exception {
            this.attachMetadataAndKylinProps(false);
            args.put("meta", this.metaDumpUrl);
            args.put("metaOutput", this.metaDumpUrl + "_output");
            this.doExecute(app, args);
        }

        public void cleanupEnv() {
            FileUtils.deleteQuietly((File)new File(this.getJobTmpDir()));
        }

        protected abstract void doExecute(ExecutableApplication var1, Map<String, String> var2) throws Exception;

        protected String formatArgs(Map<String, String> args) {
            return args.entrySet().stream().map(entry -> "--" + (String)entry.getKey() + "=" + (String)entry.getValue()).collect(Collectors.joining(" "));
        }

        public String getJobTmpDir() {
            return KylinConfigBase.getKylinHome() + "/tmp/" + this.jobId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void attachMetadataAndKylinProps(boolean kylinPropsOnly) throws IOException {
            if (StringUtils.isEmpty((CharSequence)this.metaDumpUrl)) {
                throw new KylinRuntimeException("Missing metaUrl");
            }
            File tmpDir = File.createTempFile("kylin_job_meta", "");
            try {
                FileUtils.forceDelete((File)tmpDir);
                Properties props = this.kylinConfig.exportToProperties();
                props.setProperty("kylin.query.queryhistory.url", this.kylinConfig.getQueryHistoryUrl().toString());
                props.setProperty("kylin.metadata.url", this.metaDumpUrl);
                ResourceStore.dumpKylinProps((File)tmpDir, (Properties)props);
                if (!kylinPropsOnly) {
                    Map dumpMap = (Map)EnhancedUnitOfWork.doInTransactionWithCheckAndRetry((UnitOfWorkParams)UnitOfWorkParams.builder().readonly(true).unitName(this.project).maxRetry(1).processor(() -> {
                        HashMap retMap = Maps.newHashMap();
                        for (String resPath : this.originResources) {
                            ResourceStore resourceStore = ResourceStore.getKylinMetaStore((KylinConfig)this.kylinConfig);
                            RawResource rawResource = resourceStore.getResource(resPath);
                            retMap.put(resPath, rawResource);
                        }
                        return retMap;
                    }).build());
                    if (Objects.isNull(dumpMap) || dumpMap.isEmpty()) {
                        return;
                    }
                    ResourceStore.dumpResourceMaps((File)tmpDir, (Map)dumpMap);
                }
                KylinConfig dstConfig = KylinConfig.createKylinConfig((Properties)props);
                MetadataStore.createMetadataStore((KylinConfig)dstConfig).uploadFromFile(tmpDir);
                log.debug("Copied metadata to the target metaUrl, delete the temp dir: {}", (Object)tmpDir);
            }
            finally {
                FileUtils.forceDelete((File)tmpDir);
            }
        }

        @Generated
        public AbstractJobRunner(KylinConfig kylinConfig, String project, List<String> originResources) {
            this.kylinConfig = kylinConfig;
            this.project = project;
            this.originResources = originResources;
        }
    }
}

