/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rec.index;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.kylin.metadata.cube.model.IndexEntity;
import org.apache.kylin.metadata.cube.model.IndexPlan;
import org.apache.kylin.metadata.cube.model.LayoutEntity;
import org.apache.kylin.metadata.cube.utils.IndexPlanReduceUtil;
import org.apache.kylin.metadata.recommendation.entity.LayoutRecItemV2;
import org.apache.kylin.rec.AbstractContext;
import org.apache.kylin.rec.common.AccelerateInfo;
import org.apache.kylin.rec.index.AbstractIndexProposer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class IndexReducer
extends AbstractIndexProposer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IndexReducer.class);

    IndexReducer(AbstractContext.ModelContext context) {
        super(context);
    }

    @Override
    public IndexPlan execute(IndexPlan indexPlan) {
        log.debug("Start to reduce redundant layouts...");
        List allProposedIndexes = indexPlan.getIndexes();
        List layoutsToHandle = indexPlan.getAllLayouts();
        if (!KylinConfig.getInstanceFromEnv().isIncludedStrategyConsiderTableIndex()) {
            layoutsToHandle.removeIf(layout -> IndexEntity.isTableIndex((long)layout.getId()));
        }
        HashMap redundantToReservedMap = Maps.newHashMap();
        redundantToReservedMap.putAll(IndexPlanReduceUtil.collectIncludedLayouts((List)layoutsToHandle, (boolean)false));
        redundantToReservedMap.forEach((redundant, reserved) -> {
            Optional<IndexEntity> indexEntityOptional = allProposedIndexes.stream().filter(index -> index.getId() == redundant.getIndexId()).findFirst();
            indexEntityOptional.ifPresent(entity -> entity.getLayouts().remove(redundant));
        });
        HashSet redundantRecord = Sets.newHashSet();
        redundantToReservedMap.forEach((key, value) -> redundantRecord.add(key.getId() + "->" + value.getId()));
        log.trace("In this round, IndexPlan({}) found redundant layout(s) is|are: {}", (Object)indexPlan.getUuid(), (Object)String.join((CharSequence)", ", redundantRecord));
        List<IndexEntity> allReservedIndexList = allProposedIndexes.stream().filter(indexEntity -> !indexEntity.getLayouts().isEmpty()).collect(Collectors.toList());
        log.debug("Proposed {} indexes, {} indexes will be reserved.", (Object)allProposedIndexes.size(), (Object)allReservedIndexList.size());
        allReservedIndexList.forEach(index -> index.getLayouts().forEach(layout -> layout.setInProposing(false)));
        indexPlan.setIndexes(allReservedIndexList);
        this.cleanRedundantLayoutRecommendations(redundantToReservedMap);
        Set layoutIds = indexPlan.getAllLayouts().stream().map(LayoutEntity::getId).collect(Collectors.toSet());
        this.context.setIndexRexItemMap(this.context.getIndexRexItemMap().entrySet().stream().filter(e -> layoutIds.contains(((LayoutRecItemV2)e.getValue()).getLayout().getId())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
        this.adjustAccelerationInfo(redundantToReservedMap);
        log.debug("End of reduce indexes and layouts!");
        return indexPlan;
    }

    private void cleanRedundantLayoutRecommendations(Map<LayoutEntity, LayoutEntity> redundantToReserveMap) {
        if (this.context.getProposeContext().skipCollectRecommendations()) {
            return;
        }
        redundantToReserveMap.forEach((redundant, reserved) -> this.context.getIndexRexItemMap().remove(redundant.genUniqueContent()));
    }

    private void adjustAccelerationInfo(Map<LayoutEntity, LayoutEntity> redundantToReservedMap) {
        Map<String, AccelerateInfo> accelerateInfoMap = this.context.getProposeContext().getAccelerateInfoMap();
        HashMap redundantMap = Maps.newHashMap();
        redundantToReservedMap.forEach((redundant, reserved) -> redundantMap.putIfAbsent(redundant.getId(), redundant));
        accelerateInfoMap.forEach((key, value) -> {
            if (value.getRelatedLayouts() == null) {
                return;
            }
            value.getRelatedLayouts().forEach(relatedLayout -> {
                LayoutEntity entity;
                if (redundantMap.containsKey(relatedLayout.getLayoutId()) && (entity = (LayoutEntity)redundantMap.get(relatedLayout.getLayoutId())).getIndex().getIndexPlan().getUuid().equalsIgnoreCase(relatedLayout.getModelId())) {
                    LayoutEntity reserved = (LayoutEntity)redundantToReservedMap.get(entity);
                    relatedLayout.setLayoutId(reserved.getId());
                    relatedLayout.setModelId(reserved.getIndex().getIndexPlan().getUuid());
                }
            });
            value.setRelatedLayouts(Sets.newHashSet(value.getRelatedLayouts()));
        });
    }
}

