/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rec;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.realization.NoRealizationFoundException;
import org.apache.kylin.rec.AbstractContext;
import org.apache.kylin.rec.AbstractProposer;
import org.apache.kylin.rec.common.AccelerateInfo;
import org.apache.kylin.rec.model.GreedyModelTreesBuilder;
import org.apache.kylin.rec.query.AbstractQueryRunner;
import org.apache.kylin.rec.query.LocalQueryRunner;
import org.apache.kylin.rec.query.QueryRunnerBuilder;
import org.apache.kylin.rec.query.SQLResult;
import org.apache.kylin.rec.query.advisor.SQLAdvice;
import org.apache.kylin.rec.query.advisor.SqlSyntaxAdvisor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLAnalysisProposer
extends AbstractProposer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SQLAnalysisProposer.class);
    private final String[] sqls;

    public SQLAnalysisProposer(AbstractContext proposeContext) {
        super(proposeContext);
        this.sqls = Objects.requireNonNull(proposeContext.getSqlArray());
    }

    @Override
    public void execute() {
        this.initAccelerationInfo(this.sqls);
        List<NDataModel> models = this.proposeContext.getOriginModels();
        try (LocalQueryRunner extractor = new QueryRunnerBuilder(this.project, this.getProposeContext().getSmartConfig().getKylinConfig(), this.sqls).of(models).build();){
            extractor.execute();
            this.logFailedQuery(extractor);
            List<AbstractContext.ModelContext> modelContexts = new GreedyModelTreesBuilder(KylinConfig.getInstanceFromEnv(), this.project, this.proposeContext).build(extractor.filterNonModelViewOlapContexts(), null).stream().filter(modelTree -> !modelTree.getOlapContexts().isEmpty()).map(this.proposeContext::createModelContext).collect(Collectors.toList());
            this.proposeContext.getModelViewOlapContextMap().putAll(extractor.filterModelViewOlapContexts());
            this.proposeContext.setModelContexts(modelContexts);
        }
        catch (InterruptedException e) {
            log.warn("Interrupted!!", (Throwable)e);
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            log.error("Failed to get query stats. ", (Throwable)e);
        }
    }

    private void initAccelerationInfo(String[] sqls) {
        Arrays.stream(sqls).forEach(sql -> {
            AccelerateInfo accelerateInfo = new AccelerateInfo();
            if (!this.proposeContext.getAccelerateInfoMap().containsKey(sql)) {
                this.proposeContext.getAccelerateInfoMap().put((String)sql, accelerateInfo);
            }
        });
    }

    private void logFailedQuery(AbstractQueryRunner extractor) {
        Map<String, SQLResult> queryResultMap = extractor.getQueryResults();
        SqlSyntaxAdvisor sqlAdvisor = new SqlSyntaxAdvisor();
        queryResultMap.forEach((sql, sqlResult) -> {
            if (sqlResult.getStatus() != SQLResult.Status.FAILED) {
                return;
            }
            AccelerateInfo accelerateInfo = this.proposeContext.getAccelerateInfoMap().get(sql);
            Preconditions.checkNotNull((Object)accelerateInfo);
            Throwable throwable = sqlResult.getException();
            if (!(throwable instanceof NoRealizationFoundException) && !(throwable.getCause() instanceof NoRealizationFoundException)) {
                if (StringUtils.contains((CharSequence)throwable.getMessage(), (CharSequence)"not found")) {
                    SQLAdvice sqlAdvices = sqlAdvisor.proposeWithMessage((SQLResult)sqlResult);
                    accelerateInfo.setPendingMsg(sqlAdvices.getIncapableReason());
                } else {
                    accelerateInfo.setFailedCause(AccelerateInfo.transformThrowable(throwable));
                }
            }
        });
    }

    @Override
    public String getIdentifierName() {
        return "SQLAnalysisProposer";
    }
}

