/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rec;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.ImmutableBitSet;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableList;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.kylin.metadata.cube.model.IndexEntity;
import org.apache.kylin.metadata.cube.model.IndexPlan;
import org.apache.kylin.metadata.cube.model.LayoutEntity;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.rec.AbstractContext;
import org.apache.kylin.rec.AbstractProposer;
import org.apache.kylin.rec.common.AccelerateInfo;
import org.apache.kylin.rec.index.IndexMaster;
import org.apache.kylin.rec.util.EntityBuilder;

public class IndexPlanShrinkProposer
extends AbstractProposer {
    public IndexPlanShrinkProposer(AbstractContext proposeContext) {
        super(proposeContext);
    }

    @Override
    public void execute() {
        if (this.proposeContext.getModelContexts() == null) {
            return;
        }
        ProjectInstance projectInstance = NProjectManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv()).getProject(this.proposeContext.getProject());
        for (AbstractContext.ModelContext modelCtx : this.proposeContext.getModelContexts()) {
            if (modelCtx.getTargetIndexPlan() == null) continue;
            this.mergeIndexPlan(modelCtx);
            IndexMaster indexMaster = new IndexMaster(modelCtx);
            IndexPlan indexPlan = projectInstance.isSemiAutoMode() ? indexMaster.reduceCuboids(modelCtx.getTargetIndexPlan()) : modelCtx.getTargetIndexPlan();
            modelCtx.setTargetIndexPlan(indexPlan);
        }
    }

    @Override
    public String getIdentifierName() {
        return "IndexPlanShrinkProposer";
    }

    private void mergeIndexPlan(AbstractContext.ModelContext modelContext) {
        IndexPlan indexPlan = modelContext.getTargetIndexPlan();
        if (indexPlan == null || CollectionUtils.isEmpty((Collection)indexPlan.getIndexes())) {
            return;
        }
        Map<ImmutableBitSet, List<IndexEntity>> dim2Indices = this.recognizeAggIndexGroupOfSameDims(indexPlan);
        List<IndexEntity> readyIndices = this.collectTableOrReadyIndices(indexPlan);
        HashMap<ImmutableBitSet, List<IndexEntity>> newDim2Index = this.mergeIndicesGroupOfSameDim(modelContext, dim2Indices, readyIndices);
        this.dropDuplicateLayouts(readyIndices, newDim2Index);
        this.mergeProposingIndexToExist(readyIndices, newDim2Index);
        this.updateLayoutRecItem(modelContext, readyIndices, newDim2Index);
        this.updateIndexPlan(indexPlan, readyIndices, newDim2Index);
    }

    private void updateIndexPlan(IndexPlan indexPlan, List<IndexEntity> existedTableIndicesOrReadyIndices, HashMap<ImmutableBitSet, List<IndexEntity>> newDim2Index) {
        indexPlan.getIndexes().clear();
        indexPlan.getIndexes().addAll(existedTableIndicesOrReadyIndices);
        indexPlan.getIndexes().addAll(newDim2Index.entrySet().stream().map(Map.Entry::getValue).flatMap(Collection::stream).collect(Collectors.toSet()));
    }

    private void updateLayoutRecItem(AbstractContext.ModelContext modelContext, List<IndexEntity> readyIndices, HashMap<ImmutableBitSet, List<IndexEntity>> newDim2Index) {
        newDim2Index.forEach((k, v) -> v.forEach(index -> {
            List layouts = index.getLayouts();
            layouts.forEach(layout -> {
                if (layout.isInProposing()) {
                    modelContext.gatherLayoutRecItem((LayoutEntity)layout);
                }
            });
        }));
        readyIndices.forEach(index -> {
            List layouts = index.getLayouts();
            layouts.forEach(layout -> {
                if (layout.isInProposing()) {
                    modelContext.gatherLayoutRecItem((LayoutEntity)layout);
                }
            });
        });
    }

    private HashMap<ImmutableBitSet, List<IndexEntity>> mergeIndicesGroupOfSameDim(AbstractContext.ModelContext modelContext, Map<ImmutableBitSet, List<IndexEntity>> sameDimIndicesGroup, List<IndexEntity> readyIndices) {
        IndexPlan indexPlan = modelContext.getTargetIndexPlan();
        HashMap<ImmutableBitSet, List<IndexEntity>> newDim2Index = new HashMap<ImmutableBitSet, List<IndexEntity>>();
        sameDimIndicesGroup.entrySet().stream().filter(indices -> CollectionUtils.isNotEmpty((Collection)((Collection)indices.getValue()))).forEach(indices -> {
            if (((List)indices.getValue()).size() == 1) {
                newDim2Index.put((ImmutableBitSet)indices.getKey(), (List<IndexEntity>)indices.getValue());
                return;
            }
            ArrayList existedIndices = Lists.newArrayList((Iterable)readyIndices);
            existedIndices.addAll(newDim2Index.entrySet().stream().map(Map.Entry::getValue).flatMap(Collection::stream).collect(Collectors.toSet()));
            long availableId = EntityBuilder.IndexEntityBuilder.findAvailableIndexEntityId(indexPlan, existedIndices, false);
            ArrayList reservedIndex = Lists.newArrayList();
            IndexEntity tempIndex = (IndexEntity)((List)indices.getValue()).get(0);
            for (IndexEntity indexEntity : ((List)indices.getValue()).subList(1, ((List)indices.getValue()).size())) {
                IndexEntity mergedIndex = this.mergeIndexEntity(tempIndex, indexEntity, availableId);
                if (CollectionUtils.isNotEmpty((Collection)tempIndex.getLayouts())) {
                    readyIndices.add(tempIndex);
                }
                if (CollectionUtils.isNotEmpty((Collection)indexEntity.getLayouts())) {
                    readyIndices.add(indexEntity);
                }
                tempIndex = mergedIndex;
            }
            if (CollectionUtils.isNotEmpty((Collection)tempIndex.getLayouts())) {
                reservedIndex.add(tempIndex);
            }
            newDim2Index.put((ImmutableBitSet)indices.getKey(), reservedIndex);
        });
        return newDim2Index;
    }

    private IndexEntity mergeIndexEntity(IndexEntity originIndex, IndexEntity toBeMergedIndex, long availableNextIndexId) {
        Preconditions.checkArgument((boolean)originIndex.getDimensionBitset().equals((Object)toBeMergedIndex.getDimensionBitset()), (Object)"the dimension of Merged IndexPlan MUST be SAME!");
        Pair<List<LayoutEntity>, List<LayoutEntity>> originPair = this.splitLayoutsToReadyAndNew(originIndex);
        Pair<List<LayoutEntity>, List<LayoutEntity>> mergedPair = this.splitLayoutsToReadyAndNew(toBeMergedIndex);
        originIndex.getLayouts().clear();
        toBeMergedIndex.getLayouts().clear();
        if (CollectionUtils.isNotEmpty((Collection)((Collection)originPair.getFirst()))) {
            originIndex.setLayouts((List)originPair.getFirst());
        }
        if (CollectionUtils.isNotEmpty((Collection)((Collection)mergedPair.getFirst()))) {
            toBeMergedIndex.setLayouts((List)mergedPair.getFirst());
        }
        TreeSet newMeasures = Sets.newTreeSet((Iterable)originIndex.getMeasures());
        newMeasures.addAll(toBeMergedIndex.getMeasures());
        IndexEntity mergedIndex = new EntityBuilder.IndexEntityBuilder(availableNextIndexId, originIndex.getIndexPlan()).dimIds(originIndex.getDimensions()).measure(Lists.newArrayList((Iterable)newMeasures)).build();
        ArrayList existedList = Lists.newArrayList((Iterable)((Iterable)originPair.getSecond()));
        existedList.addAll((Collection)mergedPair.getSecond());
        Map<String, LayoutEntity> dims2LayoutMap = this.mergeLayoutsOfSameColOrder(existedList);
        for (LayoutEntity layoutEntity : dims2LayoutMap.values()) {
            ArrayList<Integer> newLayoutColOrder = new ArrayList<Integer>((Collection<Integer>)layoutEntity.getDimsIds());
            newLayoutColOrder.addAll(mergedIndex.getMeasures());
            ArrayList existedLayout = Lists.newArrayList((Iterable)mergedIndex.getLayouts());
            LayoutEntity newLayout = new EntityBuilder.LayoutEntityBuilder(mergedIndex.searchNextAvailableLayoutId((List)existedLayout, mergedIndex.getId(), (int)mergedIndex.getNextLayoutOffset()), mergedIndex).isAuto(layoutEntity.isAuto()).colOrderIds(newLayoutColOrder).partitionCol(layoutEntity.getPartitionByColumns()).shardByCol(layoutEntity.getShardByColumns()).build();
            newLayout.setInProposing(true);
            mergedIndex.getLayouts().add(newLayout);
            this.updateAccelerationInfo(this.proposeContext.getAccelerateInfoMap(), layoutEntity.getIndex().getIndexPlan().getId(), layoutEntity, newLayout);
        }
        return mergedIndex;
    }

    private void mergeProposingIndexToExist(List<IndexEntity> readyIndices, HashMap<ImmutableBitSet, List<IndexEntity>> newDim2Index) {
        Map readyIndicesMap = readyIndices.stream().collect(Collectors.toMap(IndexEntity::createIndexIdentifier, Function.identity()));
        newDim2Index.forEach((integers, indexEntities) -> {
            Iterator it = indexEntities.iterator();
            while (it.hasNext()) {
                IndexEntity index = (IndexEntity)it.next();
                IndexEntity.IndexIdentifier indexIdentifier = index.createIndexIdentifier();
                if (!readyIndicesMap.containsKey(indexIdentifier)) continue;
                IndexEntity readyIndex = (IndexEntity)readyIndicesMap.get(indexIdentifier);
                index.getLayouts().forEach(layout -> {
                    layout.initalId(true);
                    readyIndex.addLayout(layout);
                });
                it.remove();
            }
        });
    }

    private void dropDuplicateLayouts(List<IndexEntity> readyIndices, HashMap<ImmutableBitSet, List<IndexEntity>> newDim2Index) {
        List existedLayout = readyIndices.stream().map(IndexEntity::getLayouts).flatMap(Collection::stream).collect(Collectors.toList());
        newDim2Index.forEach((integers, indexEntities) -> {
            Iterator it = indexEntities.iterator();
            while (it.hasNext()) {
                IndexEntity index = (IndexEntity)it.next();
                Iterator layoutIt = index.getLayouts().iterator();
                while (layoutIt.hasNext()) {
                    LayoutEntity layout = (LayoutEntity)layoutIt.next();
                    int id = existedLayout.indexOf(layout);
                    if (id < 0) continue;
                    this.updateAccelerationInfo(this.proposeContext.getAccelerateInfoMap(), layout.getIndex().getIndexPlan().getId(), layout, (LayoutEntity)existedLayout.get(id));
                    layoutIt.remove();
                }
                if (!CollectionUtils.isEmpty((Collection)index.getLayouts())) continue;
                it.remove();
            }
        });
    }

    private Map<ImmutableBitSet, List<IndexEntity>> recognizeAggIndexGroupOfSameDims(IndexPlan indexPlan) {
        HashMap<ImmutableBitSet, List<IndexEntity>> dim2Indices = new HashMap<ImmutableBitSet, List<IndexEntity>>();
        indexPlan.getIndexes().forEach(indexEntity -> {
            if (indexEntity.isTableIndex() || !this.containNewLayout((IndexEntity)indexEntity)) {
                return;
            }
            if (dim2Indices.get(indexEntity.getDimensionBitset()) == null) {
                ArrayList list = Lists.newArrayList();
                list.add(indexEntity);
                dim2Indices.put(indexEntity.getDimensionBitset(), list);
            } else {
                ((List)dim2Indices.get(indexEntity.getDimensionBitset())).add(indexEntity);
            }
        });
        return dim2Indices;
    }

    private List<IndexEntity> collectTableOrReadyIndices(IndexPlan indexPlan) {
        return indexPlan.getIndexes().stream().filter(indexEntity -> indexEntity.isTableIndex() || !this.containNewLayout((IndexEntity)indexEntity)).collect(Collectors.toList());
    }

    private Map<String, LayoutEntity> mergeLayoutsOfSameColOrder(List<LayoutEntity> layouts) {
        HashMap<String, LayoutEntity> dims2LayoutMap = new HashMap<String, LayoutEntity>();
        layouts.forEach(layoutEntity -> {
            String dimStr = this.getDimsStr((ImmutableList<Integer>)layoutEntity.getDimsIds(), layoutEntity.getShardByColumns());
            if (dims2LayoutMap.get(dimStr) == null) {
                dims2LayoutMap.put(dimStr, (LayoutEntity)layoutEntity);
            } else {
                this.updateAccelerationInfo(this.proposeContext.getAccelerateInfoMap(), layoutEntity.getIndex().getIndexPlan().getId(), (LayoutEntity)layoutEntity, (LayoutEntity)dims2LayoutMap.get(dimStr));
            }
        });
        return dims2LayoutMap;
    }

    private String getDimsStr(ImmutableList<Integer> dimIds, List<Integer> shardByIds) {
        int i;
        StringBuilder builder = new StringBuilder("dim:[");
        for (i = 0; i < dimIds.size(); ++i) {
            builder.append(dimIds.get(i));
            builder.append(i == dimIds.size() - 1 ? "" : ",");
        }
        builder.append("] shardBy:[");
        for (i = 0; i < shardByIds.size(); ++i) {
            builder.append(shardByIds.get(i));
            builder.append(i == dimIds.size() - 1 ? "" : ",");
        }
        builder.append("]");
        return builder.toString();
    }

    private Pair<List<LayoutEntity>, List<LayoutEntity>> splitLayoutsToReadyAndNew(IndexEntity indexEntity) {
        ArrayList readyLayouts = Lists.newArrayList();
        ArrayList newLayouts = Lists.newArrayList();
        for (LayoutEntity layout : indexEntity.getLayouts()) {
            if (layout.isInProposing()) {
                newLayouts.add(layout);
                continue;
            }
            readyLayouts.add(layout);
        }
        return Pair.newPair((Object)readyLayouts, (Object)newLayouts);
    }

    private boolean containNewLayout(IndexEntity index) {
        for (LayoutEntity layout : index.getLayouts()) {
            if (!layout.isInProposing()) continue;
            return true;
        }
        return false;
    }

    private void updateAccelerationInfo(Map<String, AccelerateInfo> accelerateInfo, String model, LayoutEntity originLayout, LayoutEntity newLayout) {
        accelerateInfo.entrySet().stream().filter(acc -> !((AccelerateInfo)acc.getValue()).isNotSucceed()).forEach(entry -> ((AccelerateInfo)entry.getValue()).getRelatedLayouts().stream().filter(qlr -> qlr.getModelId().equals(model) && qlr.getLayoutId() == originLayout.getId()).forEach(relation -> relation.setLayoutId(newLayout.getId())));
        accelerateInfo.entrySet().stream().filter(acc -> !((AccelerateInfo)acc.getValue()).isNotSucceed()).forEach(entry -> ((AccelerateInfo)entry.getValue()).setRelatedLayouts(Sets.newHashSet(((AccelerateInfo)entry.getValue()).getRelatedLayouts())));
    }
}

