/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rec;

import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableList;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.rec.AbstractContext;
import org.apache.kylin.rec.AbstractProposer;
import org.apache.kylin.rec.SmartMaster;
import org.apache.kylin.rec.common.AccelerateInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChainedProposer
extends AbstractProposer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ChainedProposer.class);
    private final ImmutableList<AbstractProposer> proposerList;

    public ChainedProposer(AbstractContext proposeContext, ImmutableList<AbstractProposer> proposerList) {
        super(proposeContext);
        this.proposerList = proposerList;
        assert (!proposerList.contains((Object)this));
    }

    @Override
    public void execute() {
        for (AbstractProposer proposer : this.proposerList) {
            long start = System.currentTimeMillis();
            log.info("Enter the step of `{}`", (Object)proposer.getIdentifierName());
            proposer.execute();
            Map<SmartMaster.AccStatusType, Integer> nums = this.getAccelerationNumMap();
            log.info("The step of `{}` completed successfully, takes {}ms. SUCCESS {}, PENDING {}, FAILED {}.", new Object[]{proposer.getIdentifierName(), System.currentTimeMillis() - start, nums.get((Object)SmartMaster.AccStatusType.SUCCESS), nums.get((Object)SmartMaster.AccStatusType.PENDING), nums.get((Object)SmartMaster.AccStatusType.FAILED)});
        }
    }

    private Map<SmartMaster.AccStatusType, Integer> getAccelerationNumMap() {
        HashMap result = Maps.newHashMap();
        result.putIfAbsent(SmartMaster.AccStatusType.SUCCESS, 0);
        result.putIfAbsent(SmartMaster.AccStatusType.PENDING, 0);
        result.putIfAbsent(SmartMaster.AccStatusType.FAILED, 0);
        Map<String, AccelerateInfo> accelerateInfoMap = this.proposeContext.getAccelerateInfoMap();
        for (Map.Entry<String, AccelerateInfo> entry : accelerateInfoMap.entrySet()) {
            if (entry.getValue().isPending()) {
                result.computeIfPresent(SmartMaster.AccStatusType.PENDING, (k, v) -> v + 1);
                continue;
            }
            if (entry.getValue().isFailed()) {
                result.computeIfPresent(SmartMaster.AccStatusType.FAILED, (k, v) -> v + 1);
                continue;
            }
            result.computeIfPresent(SmartMaster.AccStatusType.SUCCESS, (k, v) -> v + 1);
        }
        return result;
    }

    @Override
    public String getIdentifierName() {
        throw new NotImplementedException("No need to use the name of ChainProposer");
    }

    @Generated
    public ImmutableList<AbstractProposer> getProposerList() {
        return this.proposerList;
    }
}

