/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rec;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.parser.SqlParseException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.kylin.common.KapConfig;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.RandomUtil;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.kylin.metadata.cube.model.IndexPlan;
import org.apache.kylin.metadata.cube.model.LayoutEntity;
import org.apache.kylin.metadata.model.AntiFlatChecker;
import org.apache.kylin.metadata.model.ColExcludedChecker;
import org.apache.kylin.metadata.model.ComputedColumnDesc;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.NDataModelManager;
import org.apache.kylin.metadata.model.NTableMetadataManager;
import org.apache.kylin.metadata.model.TableRef;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.metadata.recommendation.candidate.RawRecItem;
import org.apache.kylin.metadata.recommendation.entity.CCRecItemV2;
import org.apache.kylin.metadata.recommendation.entity.DimensionRecItemV2;
import org.apache.kylin.metadata.recommendation.entity.LayoutRecItemV2;
import org.apache.kylin.metadata.recommendation.entity.MeasureRecItemV2;
import org.apache.kylin.query.IQueryTransformer;
import org.apache.kylin.query.engine.QueryExec;
import org.apache.kylin.query.relnode.OlapContext;
import org.apache.kylin.query.util.QueryUtil;
import org.apache.kylin.query.util.SqlNodeExtractor;
import org.apache.kylin.rec.AbstractSemiContext;
import org.apache.kylin.rec.ChainedProposer;
import org.apache.kylin.rec.ModelReuseContext;
import org.apache.kylin.rec.common.AccelerateInfo;
import org.apache.kylin.rec.common.SmartConfig;
import org.apache.kylin.rec.exception.PendingException;
import org.apache.kylin.rec.model.ModelTree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractContext {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractContext.class);
    private final SmartConfig smartConfig;
    private final String project;
    private final String[] sqlArray;
    private final ChainedProposer proposers;
    private final ExtraMetaInfo extraMeta = new ExtraMetaInfo();
    private final List<NDataModel> relatedModels = Lists.newArrayList();
    private final Set<String> relatedTables = Sets.newHashSet();
    private boolean isRestoredProposeContext;
    protected boolean canCreateNewModel;
    private List<ModelContext> modelContexts = Lists.newArrayList();
    private Map<String, AccelerateInfo> accelerateInfoMap = Maps.newHashMap();
    private final AtomicReference<Object> existingNonLayoutRecItemMap = new AtomicReference();
    private final Map<String, Collection<OlapContext>> modelViewOlapContextMap = Maps.newHashMap();
    private boolean skipEvaluateCC;
    protected boolean partialMatch;
    protected boolean partialMatchNonEqui;
    protected String modelName;

    protected AbstractContext(KylinConfig kylinConfig, String project, String[] sqlArray) {
        this.smartConfig = SmartConfig.wrap(kylinConfig);
        this.project = project;
        this.sqlArray = sqlArray;
        this.proposers = this.createProposers();
        this.partialMatch = false;
        this.partialMatchNonEqui = false;
        this.filterSqlRelatedModelsAndTables();
    }

    protected AbstractContext(KylinConfig kylinConfig, String project, String[] sqlArray, String modelName) {
        this(kylinConfig, project, sqlArray);
        this.modelName = modelName;
    }

    public ModelContext createModelContext(ModelTree modelTree) {
        return new ModelContext(this, modelTree);
    }

    public abstract IndexPlan getOriginIndexPlan(String var1);

    public abstract List<NDataModel> getOriginModels();

    public abstract void changeModelMainType(NDataModel var1);

    public abstract ChainedProposer createProposers();

    public abstract void saveMetadata();

    public abstract String getIdentifier();

    public KapConfig getKapConfig() {
        return this.getSmartConfig().getKapConfig();
    }

    private void filterSqlRelatedModelsAndTables() {
        HashSet models = Sets.newHashSet();
        HashSet tableIdentities = Sets.newHashSet();
        HashMap tableToModelsMap = Maps.newHashMap();
        HashMap modelViewToModelMap = Maps.newHashMap();
        this.getAllModels().forEach(model -> {
            if (model.isBroken()) {
                return;
            }
            modelViewToModelMap.put((model.getProject() + "." + model.getAlias()).toUpperCase(Locale.ROOT), model);
            for (TableRef tableRef : model.getAllTables()) {
                tableToModelsMap.putIfAbsent(tableRef.getTableIdentity(), Sets.newHashSet());
                ((Set)tableToModelsMap.get(tableRef.getTableIdentity())).add(model);
            }
        });
        Map<String, Set<String>> allTableMap = this.getProjectTableMap();
        if (!this.smartConfig.skipUselessMetadata() || this.isRestoredProposeContext) {
            tableToModelsMap.forEach((k, modelSet) -> this.getRelatedModels().addAll((Collection<NDataModel>)modelSet));
            allTableMap.forEach((k, tableSet) -> this.getRelatedTables().addAll((Collection<String>)tableSet));
            return;
        }
        Preconditions.checkNotNull((Object)this.sqlArray);
        for (String sql : this.sqlArray) {
            List<SqlIdentifier> sqlIdentifiers = this.extractSqlIdentifier(sql);
            Set<String> sqlRelatedTableIdentities = this.extractTable(sqlIdentifiers, allTableMap);
            Set<NDataModel> sqlRelatedViewModels = this.extractViewModel(sqlIdentifiers, modelViewToModelMap);
            models.addAll(sqlRelatedViewModels);
            tableIdentities.addAll(this.extractViewModelTable(sqlRelatedViewModels));
            tableIdentities.addAll(sqlRelatedTableIdentities);
            sqlRelatedTableIdentities.forEach(tableIdentity -> {
                Set rModels = tableToModelsMap.getOrDefault(tableIdentity, Sets.newHashSet());
                rModels.forEach(model -> {
                    Set allTables = model.getAllTables();
                    allTables.forEach(tableRef -> tableIdentities.add(tableRef.getTableIdentity()));
                });
                models.addAll(rModels);
            });
        }
        this.getRelatedModels().addAll(models);
        this.getRelatedTables().addAll(tableIdentities);
    }

    private Map<String, Set<String>> getProjectTableMap() {
        NTableMetadataManager tableMgr = NTableMetadataManager.getInstance((KylinConfig)this.smartConfig.getKylinConfig(), (String)this.project);
        List tableList = tableMgr.listAllTables();
        TreeMap tableNameMap = Maps.newTreeMap((Comparator)String.CASE_INSENSITIVE_ORDER);
        tableList.forEach(table -> {
            tableNameMap.putIfAbsent(table.getName(), Sets.newHashSet());
            tableNameMap.putIfAbsent(table.getIdentity(), Sets.newHashSet());
            ((Set)tableNameMap.get(table.getName())).add(table.getIdentity());
            ((Set)tableNameMap.get(table.getIdentity())).add(table.getIdentity());
        });
        return tableNameMap;
    }

    private Set<String> extractTable(List<SqlIdentifier> sqlIdentifiers, Map<String, Set<String>> tableNameMap) {
        return sqlIdentifiers.stream().map(id -> tableNameMap.getOrDefault(id.toString(), Sets.newHashSet())).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    private Set<NDataModel> extractViewModel(List<SqlIdentifier> sqlIdentifiers, Map<String, NDataModel> modelViewToModelMap) {
        return sqlIdentifiers.stream().filter(id -> modelViewToModelMap.containsKey(id.toString())).map(id -> (NDataModel)modelViewToModelMap.get(id.toString())).collect(Collectors.toSet());
    }

    private Set<String> extractViewModelTable(Set<NDataModel> sqlRelatedViewModels) {
        return sqlRelatedViewModels.stream().map(model -> model.getAllTables().stream().map(TableRef::getTableIdentity).collect(Collectors.toSet())).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    private List<SqlIdentifier> extractSqlIdentifier(String sql) {
        try {
            String normalizedSql = AbstractContext.normalizeForTableDetecting(this.project, sql);
            return SqlNodeExtractor.getAllSqlIdentifier((String)normalizedSql);
        }
        catch (SqlParseException e) {
            log.info("extract error, sql is: {}. Error message is: {}", (Object)sql, (Object)e.getMessage());
            AccelerateInfo accelerateInfo = new AccelerateInfo();
            accelerateInfo.setFailedCause(e);
            this.accelerateInfoMap.put(sql, accelerateInfo);
            return Lists.newArrayList();
        }
    }

    public static String normalizeForTableDetecting(String project, String sql) {
        KylinConfig kylinConfig = NProjectManager.getProjectConfig((String)project);
        String convertedSql = QueryUtil.appendLimitOffset((String)project, (String)sql, (int)0, (int)0);
        String defaultSchema = "DEFAULT";
        try {
            QueryExec queryExec = new QueryExec(project, kylinConfig);
            defaultSchema = queryExec.getDefaultSchemaName();
        }
        catch (Exception e) {
            log.error("Get project default schema failed: {}", (Object)e.getMessage());
        }
        String[] detectorTransformers = kylinConfig.getTableDetectorTransformers();
        List transformerList = QueryUtil.fetchTransformers((boolean)false, (String[])detectorTransformers);
        if (log.isDebugEnabled()) {
            log.debug("All used transformers of detecting used tables are: {}", (Object)transformerList.stream().map(clz -> clz.getClass().getCanonicalName()).collect(Collectors.joining(",")));
        }
        for (IQueryTransformer t : transformerList) {
            convertedSql = t.transform(convertedSql, project, defaultSchema);
        }
        return convertedSql;
    }

    protected List<NDataModel> getAllModels() {
        return NDataModelManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)this.getProject()).listAllModels();
    }

    public void recordException(ModelContext modelCtx, Exception e) {
        modelCtx.getModelTree().getOlapContexts().forEach(olapCtx -> {
            String sql = olapCtx.getSql();
            AccelerateInfo accelerateInfo = this.accelerateInfoMap.get(sql);
            Preconditions.checkNotNull((Object)accelerateInfo);
            accelerateInfo.setFailedCause(e);
        });
    }

    public boolean skipCollectRecommendations() {
        return !(this instanceof ModelReuseContext);
    }

    public void handleExceptionAfterModelSelect() {
    }

    public List<NDataModel> getProposedModels() {
        if (CollectionUtils.isEmpty(this.modelContexts)) {
            return Lists.newArrayList();
        }
        ArrayList models = Lists.newArrayList();
        for (ModelContext modelContext : this.modelContexts) {
            NDataModel model = modelContext.getTargetModel();
            if (model == null) continue;
            models.add(modelContext.getTargetModel());
        }
        return models;
    }

    public NDataModel getProposedModel(String modelId) {
        return this.getProposedModels().stream().filter(m -> Objects.equals(m.getId(), modelId)).findAny().orElse(null);
    }

    @Generated
    public SmartConfig getSmartConfig() {
        return this.smartConfig;
    }

    @Generated
    public String getProject() {
        return this.project;
    }

    @Generated
    public String[] getSqlArray() {
        return this.sqlArray;
    }

    @Generated
    public ChainedProposer getProposers() {
        return this.proposers;
    }

    @Generated
    public ExtraMetaInfo getExtraMeta() {
        return this.extraMeta;
    }

    @Generated
    public List<NDataModel> getRelatedModels() {
        return this.relatedModels;
    }

    @Generated
    public Set<String> getRelatedTables() {
        return this.relatedTables;
    }

    @Generated
    public boolean isRestoredProposeContext() {
        return this.isRestoredProposeContext;
    }

    @Generated
    public boolean isCanCreateNewModel() {
        return this.canCreateNewModel;
    }

    @Generated
    public List<ModelContext> getModelContexts() {
        return this.modelContexts;
    }

    @Generated
    public Map<String, AccelerateInfo> getAccelerateInfoMap() {
        return this.accelerateInfoMap;
    }

    @Generated
    public Map<String, Collection<OlapContext>> getModelViewOlapContextMap() {
        return this.modelViewOlapContextMap;
    }

    @Generated
    public boolean isSkipEvaluateCC() {
        return this.skipEvaluateCC;
    }

    @Generated
    public boolean isPartialMatch() {
        return this.partialMatch;
    }

    @Generated
    public boolean isPartialMatchNonEqui() {
        return this.partialMatchNonEqui;
    }

    @Generated
    public String getModelName() {
        return this.modelName;
    }

    @Generated
    public void setRestoredProposeContext(boolean isRestoredProposeContext) {
        this.isRestoredProposeContext = isRestoredProposeContext;
    }

    @Generated
    public void setCanCreateNewModel(boolean canCreateNewModel) {
        this.canCreateNewModel = canCreateNewModel;
    }

    @Generated
    public void setModelContexts(List<ModelContext> modelContexts) {
        this.modelContexts = modelContexts;
    }

    @Generated
    public void setAccelerateInfoMap(Map<String, AccelerateInfo> accelerateInfoMap) {
        this.accelerateInfoMap = accelerateInfoMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    public Map<String, RawRecItem> getExistingNonLayoutRecItemMap() {
        Object value = this.existingNonLayoutRecItemMap.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = this.existingNonLayoutRecItemMap;
            synchronized (atomicReference) {
                value = this.existingNonLayoutRecItemMap.get();
                if (value == null) {
                    HashMap actualValue = Maps.newHashMap();
                    value = actualValue == null ? this.existingNonLayoutRecItemMap : actualValue;
                    this.existingNonLayoutRecItemMap.set(value);
                }
            }
        }
        return (Map)(value == this.existingNonLayoutRecItemMap ? null : value);
    }

    @Generated
    public void setSkipEvaluateCC(boolean skipEvaluateCC) {
        this.skipEvaluateCC = skipEvaluateCC;
    }

    @Generated
    public void setModelName(String modelName) {
        this.modelName = modelName;
    }

    public static class ExtraMetaInfo {
        private String modelOptRule;
        private Set<String> allModels = Sets.newHashSet();
        private Set<String> onlineModelIds = Sets.newHashSet();

        @Generated
        public String getModelOptRule() {
            return this.modelOptRule;
        }

        @Generated
        public Set<String> getAllModels() {
            return this.allModels;
        }

        @Generated
        public Set<String> getOnlineModelIds() {
            return this.onlineModelIds;
        }

        @Generated
        public void setModelOptRule(String modelOptRule) {
            this.modelOptRule = modelOptRule;
        }

        @Generated
        public void setAllModels(Set<String> allModels) {
            this.allModels = allModels;
        }

        @Generated
        public void setOnlineModelIds(Set<String> onlineModelIds) {
            this.onlineModelIds = onlineModelIds;
        }
    }

    public static class ModelContext {
        private ModelTree modelTree;
        private NDataModel targetModel;
        private NDataModel originModel;
        private IndexPlan targetIndexPlan;
        private IndexPlan originIndexPlan;
        private Map<String, CCRecItemV2> ccRecItemMap = Maps.newHashMap();
        private Map<String, DimensionRecItemV2> dimensionRecItemMap = Maps.newHashMap();
        private Map<String, MeasureRecItemV2> measureRecItemMap = Maps.newHashMap();
        private Map<String, LayoutRecItemV2> indexRexItemMap = Maps.newHashMap();
        private boolean snapshotSelected;
        private final AbstractContext proposeContext;
        private final Map<String, ComputedColumnDesc> usedCC = Maps.newHashMap();
        private boolean needUpdateCC = false;
        private final AtomicReference<Object> uniqueContentToFlag = new AtomicReference();
        private AntiFlatChecker antiFlatChecker;
        private ColExcludedChecker excludedChecker;

        private Map<String, String> loadUniqueContentToFlag() {
            HashMap result = Maps.newHashMap();
            if (!(this.getProposeContext() instanceof AbstractSemiContext) || this.getTargetModel() == null) {
                return result;
            }
            String modelId = this.getTargetModel().getUuid();
            this.getProposeContext().getExistingNonLayoutRecItemMap().forEach((uniqueFlag, item) -> {
                if (item.getModelID().equalsIgnoreCase(modelId)) {
                    result.put(item.getRecEntity().getUniqueContent(), uniqueFlag);
                }
            });
            return result;
        }

        public ModelContext(AbstractContext proposeContext, ModelTree modelTree) {
            this.proposeContext = proposeContext;
            this.modelTree = modelTree;
        }

        public boolean isTargetModelMissing() {
            return this.targetModel == null;
        }

        public boolean isProposedIndexesEmpty() {
            return this.targetIndexPlan == null || CollectionUtils.isEmpty((Collection)this.targetIndexPlan.getIndexes());
        }

        public boolean skipSavingMetadata() {
            return this.isTargetModelMissing() || this.isProposedIndexesEmpty() || this.snapshotSelected;
        }

        public void gatherLayoutRecItem(LayoutEntity layout) {
            if (this.getProposeContext().skipCollectRecommendations()) {
                return;
            }
            LayoutRecItemV2 item = new LayoutRecItemV2();
            item.setLayout(layout);
            item.setCreateTime(System.currentTimeMillis());
            item.setAgg(layout.getId() < 20000000000L);
            item.setUuid(RandomUtil.randomUUIDStr());
            this.getIndexRexItemMap().put(layout.genUniqueContent(), item);
        }

        public Map<String, TblColRef> collectFkDimensionMap(OlapContext olap) {
            HashMap fKAsDimensionMap = Maps.newHashMap();
            Set allAntiFlattenLookups = this.antiFlatChecker.getAntiFlattenLookups();
            Set pkTableRefs = olap.getAllColumns().stream().filter(tblColRef -> this.excludedChecker.isExcludedCol(tblColRef)).map(TblColRef::getTableRef).collect(Collectors.toSet());
            boolean hasDerivedCols = this.excludedChecker.anyExcludedColMatch((Collection)olap.getAllColumns());
            olap.getJoins().forEach(join -> {
                for (int i = 0; i < join.getForeignKeyColumns().length; ++i) {
                    TblColRef fk = join.getForeignKeyColumns()[i];
                    TblColRef pk = join.getPrimaryKeyColumns()[i];
                    if (!allAntiFlattenLookups.contains(pk.getTableWithSchema()) && !hasDerivedCols) continue;
                    if (allAntiFlattenLookups.contains(fk.getTableWithSchema())) {
                        throw new PendingException("Unsupported foreign join key of anti flatten lookup table, stop the process of generate index. The foreign key is: " + fk.getIdentity());
                    }
                    if (this.excludedChecker.isExcludedCol(fk)) {
                        throw new PendingException("Unsupported foreign join key of excluded columns, stop the process of generate index. The foreign key is: " + fk.getIdentity());
                    }
                    if (!this.proposeContext.getSmartConfig().includeAllFks()) {
                        if (!pkTableRefs.contains(pk.getTableRef())) continue;
                        fKAsDimensionMap.put(fk.getCanonicalName(), fk);
                        continue;
                    }
                    fKAsDimensionMap.putIfAbsent(fk.getCanonicalName(), fk);
                }
            });
            log.debug("Collect some foreign keys as dimensions when proposing. {}", fKAsDimensionMap.keySet());
            return fKAsDimensionMap;
        }

        @Generated
        public ModelTree getModelTree() {
            return this.modelTree;
        }

        @Generated
        public NDataModel getTargetModel() {
            return this.targetModel;
        }

        @Generated
        public NDataModel getOriginModel() {
            return this.originModel;
        }

        @Generated
        public IndexPlan getTargetIndexPlan() {
            return this.targetIndexPlan;
        }

        @Generated
        public IndexPlan getOriginIndexPlan() {
            return this.originIndexPlan;
        }

        @Generated
        public Map<String, CCRecItemV2> getCcRecItemMap() {
            return this.ccRecItemMap;
        }

        @Generated
        public Map<String, DimensionRecItemV2> getDimensionRecItemMap() {
            return this.dimensionRecItemMap;
        }

        @Generated
        public Map<String, MeasureRecItemV2> getMeasureRecItemMap() {
            return this.measureRecItemMap;
        }

        @Generated
        public Map<String, LayoutRecItemV2> getIndexRexItemMap() {
            return this.indexRexItemMap;
        }

        @Generated
        public boolean isSnapshotSelected() {
            return this.snapshotSelected;
        }

        @Generated
        public AbstractContext getProposeContext() {
            return this.proposeContext;
        }

        @Generated
        public Map<String, ComputedColumnDesc> getUsedCC() {
            return this.usedCC;
        }

        @Generated
        public boolean isNeedUpdateCC() {
            return this.needUpdateCC;
        }

        @Generated
        public AntiFlatChecker getAntiFlatChecker() {
            return this.antiFlatChecker;
        }

        @Generated
        public ColExcludedChecker getExcludedChecker() {
            return this.excludedChecker;
        }

        @Generated
        public void setModelTree(ModelTree modelTree) {
            this.modelTree = modelTree;
        }

        @Generated
        public void setTargetModel(NDataModel targetModel) {
            this.targetModel = targetModel;
        }

        @Generated
        public void setOriginModel(NDataModel originModel) {
            this.originModel = originModel;
        }

        @Generated
        public void setTargetIndexPlan(IndexPlan targetIndexPlan) {
            this.targetIndexPlan = targetIndexPlan;
        }

        @Generated
        public void setOriginIndexPlan(IndexPlan originIndexPlan) {
            this.originIndexPlan = originIndexPlan;
        }

        @Generated
        public void setCcRecItemMap(Map<String, CCRecItemV2> ccRecItemMap) {
            this.ccRecItemMap = ccRecItemMap;
        }

        @Generated
        public void setDimensionRecItemMap(Map<String, DimensionRecItemV2> dimensionRecItemMap) {
            this.dimensionRecItemMap = dimensionRecItemMap;
        }

        @Generated
        public void setMeasureRecItemMap(Map<String, MeasureRecItemV2> measureRecItemMap) {
            this.measureRecItemMap = measureRecItemMap;
        }

        @Generated
        public void setIndexRexItemMap(Map<String, LayoutRecItemV2> indexRexItemMap) {
            this.indexRexItemMap = indexRexItemMap;
        }

        @Generated
        public void setSnapshotSelected(boolean snapshotSelected) {
            this.snapshotSelected = snapshotSelected;
        }

        @Generated
        public void setNeedUpdateCC(boolean needUpdateCC) {
            this.needUpdateCC = needUpdateCC;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Generated
        public Map<String, String> getUniqueContentToFlag() {
            Object value = this.uniqueContentToFlag.get();
            if (value == null) {
                AtomicReference<Object> atomicReference = this.uniqueContentToFlag;
                synchronized (atomicReference) {
                    value = this.uniqueContentToFlag.get();
                    if (value == null) {
                        Map<String, String> actualValue = this.loadUniqueContentToFlag();
                        value = actualValue == null ? this.uniqueContentToFlag : actualValue;
                        this.uniqueContentToFlag.set(value);
                    }
                }
            }
            return (Map)(value == this.uniqueContentToFlag ? null : value);
        }

        @Generated
        public void setAntiFlatChecker(AntiFlatChecker antiFlatChecker) {
            this.antiFlatChecker = antiFlatChecker;
        }

        @Generated
        public void setExcludedChecker(ColExcludedChecker excludedChecker) {
            this.excludedChecker = excludedChecker;
        }
    }
}

