/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.jdbc.config;

import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.integration.config.xml.AbstractConsumerEndpointParser;
import org.springframework.integration.config.xml.IntegrationNamespaceUtils;
import org.springframework.integration.jdbc.JdbcOutboundGateway;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class JdbcOutboundGatewayParser
extends AbstractConsumerEndpointParser {
    protected BeanDefinitionBuilder parseHandler(Element element, ParserContext parserContext) {
        String dataSourceRef = element.getAttribute("data-source");
        String jdbcOperationsRef = element.getAttribute("jdbc-operations");
        boolean refToDataSourceSet = StringUtils.hasText((String)dataSourceRef);
        boolean refToJdbcOperationsSet = StringUtils.hasText((String)jdbcOperationsRef);
        if (refToDataSourceSet && refToJdbcOperationsSet || !refToDataSourceSet && !refToJdbcOperationsSet) {
            parserContext.getReaderContext().error("Exactly one of the attributes data-source or simple-jdbc-operations should be set for the JDBC outbound-gateway", (Object)element);
        }
        String selectQuery = IntegrationNamespaceUtils.getTextFromAttributeOrNestedElement((Element)element, (String)"query", (ParserContext)parserContext);
        String updateQuery = IntegrationNamespaceUtils.getTextFromAttributeOrNestedElement((Element)element, (String)"update", (ParserContext)parserContext);
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(JdbcOutboundGateway.class);
        if (refToDataSourceSet) {
            builder.addConstructorArgReference(dataSourceRef);
        } else {
            builder.addConstructorArgReference(jdbcOperationsRef);
        }
        builder.addConstructorArgValue((Object)updateQuery);
        builder.addConstructorArgValue((Object)selectQuery);
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"reply-sql-parameter-source-factory");
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"request-sql-parameter-source-factory");
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"request-prepared-statement-setter");
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"row-mapper");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"max-rows");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"keys-generated");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"reply-timeout", (String)"sendTimeout");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"requires-reply");
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"reply-channel", (String)"outputChannel");
        return builder;
    }

    protected String getInputChannelAttributeName() {
        return "request-channel";
    }
}

