/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.junit.rule;

import org.apache.kylin.junit.rule.Repeat;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepeatRule
implements TestRule {
    private static final Logger logger = LoggerFactory.getLogger(RepeatRule.class);

    public Statement apply(Statement statement, Description description) {
        Statement result = statement;
        Repeat repeat = (Repeat)description.getAnnotation(Repeat.class);
        if (repeat != null) {
            int times = repeat.value();
            result = new RepeatStatement(statement, description, times);
        }
        return result;
    }

    private static class RepeatStatement
    extends Statement {
        private final Statement statement;
        private final int repeat;
        private final Description description;

        public RepeatStatement(Statement statement, Description description, int repeat) {
            this.statement = statement;
            this.description = description;
            this.repeat = repeat;
        }

        public void evaluate() throws Throwable {
            for (int i = 0; i < this.repeat - 1; ++i) {
                try {
                    this.statement.evaluate();
                    return;
                }
                catch (Throwable e) {
                    logger.warn("[UNSTABLE]" + this.description.getClassName() + "#" + this.description.getMethodName() + " fail " + (i + 1) + " times", e);
                    continue;
                }
            }
            this.statement.evaluate();
        }
    }
}

