/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.util;

import java.io.File;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.io.FileUtils;
import org.apache.kylin.common.util.NLocalFileMetadataTestCase;
import org.apache.kylin.common.util.SecretKeyUtil;
import org.junit.Assert;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class SecretKeyUtilTest
extends NLocalFileMetadataTestCase {
    @Test
    public void testEncryptAndDecryptToken() throws Exception {
        String originToken = "12345_1583840099000";
        SecretKey secretKey = SecretKeyUtil.generateNewAESKey();
        byte[] encryptedToken = SecretKeyUtil.encryptToken((SecretKey)secretKey, (String)originToken);
        String decryptedToken = SecretKeyUtil.decryptToken((SecretKey)secretKey, (byte[])encryptedToken);
        Assert.assertEquals((Object)originToken, (Object)decryptedToken);
        byte[] keyBytes = secretKey.getEncoded();
        SecretKeySpec secretKeySpec = new SecretKeySpec(keyBytes, "AES");
        String decryptedToken2 = SecretKeyUtil.decryptToken((SecretKey)secretKeySpec, (byte[])encryptedToken);
        Assert.assertEquals((Object)originToken, (Object)decryptedToken2);
    }

    @Test
    public void testEncryptAndDecryptByStrKey() throws Exception {
        String originToken = "12345_1583840099000";
        String key = "kylin_metadata";
        byte[] encryptedToken = SecretKeyUtil.encryptToken((String)key, (String)originToken);
        String decryptedToken = SecretKeyUtil.decryptToken((String)key, (byte[])encryptedToken);
        Assert.assertEquals((Object)originToken, (Object)decryptedToken);
    }

    @Test
    public void testInitKGSecretKey(@TempDir File tempFolder) throws Exception {
        String mainFolder = tempFolder.getAbsolutePath();
        FileUtils.forceMkdir((File)new File(mainFolder));
        String sourceValue = System.getenv("KYLIN_HOME");
        this.overwriteSystemProp("KYLIN_HOME", mainFolder);
        SecretKeyUtil.initKGSecretKey();
        Assert.assertEquals((long)16L, (long)FileUtils.readFileToByteArray((File)new File(mainFolder + '/' + "kg_secret_key")).length);
        SecretKey secretKey = SecretKeyUtil.readKGSecretKeyFromFile();
        Assert.assertEquals((long)16L, (long)secretKey.getEncoded().length);
        if (null != sourceValue) {
            this.overwriteSystemProp("KYLIN_HOME", sourceValue);
        }
        Assert.assertEquals((Object)sourceValue, (Object)System.getenv("KYLIN_HOME"));
    }
}

